/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.stackframe;

import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.jdwp.handlers.stackframe.IJdwpStackFrameDelegate;
import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;
import org.robovm.debugger.utils.bytebuffer.DataBufferWriter;

public class JdwpStackFrameSetValuesHandler
implements IJdwpRequestHandler {
    private final IJdwpStackFrameDelegate delegate;

    public JdwpStackFrameSetValuesHandler(IJdwpStackFrameDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public short handle(DataBufferReader payload, DataBufferWriter output) {
        long threadId = payload.readLong();
        long frameId = payload.readLong();
        int count = payload.readInt32();
        try {
            this.delegate.setFrameValues(threadId, frameId, payload, count);
        }
        catch (ClassCastException e) {
            return 20;
        }
        catch (DebuggerException e) {
            if (e.getCode() < 0) {
                throw e;
            }
            return (short)e.getCode();
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 16;
    }

    @Override
    public byte getCommand() {
        return 2;
    }

    public String toString() {
        return "StackFrame(16).SetValues(2)";
    }
}

