/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.objectreference;

import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.jdwp.handlers.classtype.JdwpClassTypeInvokeMethodHandler;
import org.robovm.debugger.jdwp.handlers.objectreference.IJdwpInstanceDelegate;
import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;
import org.robovm.debugger.utils.bytebuffer.DataBufferWriter;

public class JdwpObjRefInvokeMethodHandler
implements IJdwpRequestHandler {
    private final IJdwpInstanceDelegate delegate;

    public JdwpObjRefInvokeMethodHandler(IJdwpInstanceDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public short handle(DataBufferReader payload, DataBufferWriter output) {
        long objectId = payload.readLong();
        long threadId = payload.readLong();
        long classId = payload.readLong();
        long methodId = payload.readLong();
        int argCount = payload.readInt32();
        byte[] tags = new byte[argCount];
        Object[] args = new Object[argCount];
        try {
            JdwpClassTypeInvokeMethodHandler.readTaggedArguments(tags, args, payload);
            int invokeOptions = payload.readInt32();
            boolean singleThread = (invokeOptions & 1) != 0;
            this.delegate.jdwpInvokeMethod(objectId, threadId, methodId, false, singleThread, args, output);
        }
        catch (ClassCastException e) {
            return 20;
        }
        catch (DebuggerException e) {
            if (e.getCode() < 0) {
                throw e;
            }
            return (short)e.getCode();
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 9;
    }

    @Override
    public byte getCommand() {
        return 6;
    }

    public String toString() {
        return "ObjectReference(9).InvokeMethod(6)";
    }
}

