/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.method;

import org.robovm.debugger.debuginfo.DebuggerDebugMethodInfo;
import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.state.classdata.MethodInfo;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;
import org.robovm.debugger.utils.bytebuffer.DataBufferWriter;

public class JdwpMethodLineTableHandler
implements IJdwpRequestHandler {
    private final VmDebuggerState state;

    public JdwpMethodLineTableHandler(VmDebuggerState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short handle(DataBufferReader payload, DataBufferWriter output) {
        long refTypeId = payload.readLong();
        long methodId = payload.readLong();
        Object object = this.state.centralLock();
        synchronized (object) {
            MethodInfo methodInfo = this.state.methodsRefIdHolder().objectById(methodId);
            if (methodInfo == null) {
                return 23;
            }
            DebuggerDebugMethodInfo debugInfo = methodInfo.debugInfo();
            if (debugInfo == null) {
                return 101;
            }
            int startLine = debugInfo.startLine();
            int finalLine = debugInfo.finalLine();
            output.writeLong(startLine);
            output.writeLong(finalLine);
            int arraySize = (finalLine - startLine + 1 + 7) / 8;
            this.state.appFileDataMemoryReader().setPosition(methodInfo.bpTableAddr());
            byte[] bpTable = this.state.appFileDataMemoryReader().readBytes(arraySize);
            long savedCntPos = output.position();
            output.writeInt32(0);
            int cnt = 0;
            int idx = 0;
            byte mask = 0;
            for (int lineNo = startLine; lineNo <= finalLine; ++lineNo) {
                if ((idx & 7) == 0) {
                    mask = bpTable[idx >> 3];
                }
                if (!(mask & true)) {
                    output.writeLong(lineNo);
                    output.writeInt32(lineNo);
                    ++cnt;
                }
                ++idx;
                mask = (byte)(mask >> 1);
            }
            output.setPosition(savedCntPos);
            output.writeInt32(cnt);
            output.setPosition(output.size());
            return 0;
        }
    }

    @Override
    public byte getCommandSet() {
        return 6;
    }

    @Override
    public byte getCommand() {
        return 1;
    }

    public String toString() {
        return "Method(6).LineTable(1)";
    }
}

