/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.eventrequest;

import java.util.ArrayList;
import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.IJdwpEventDelegate;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.predicates.EventClassNameMatchPredicate;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.predicates.EventClassTypeIdPredicate;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.predicates.EventExceptionPredicate;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.predicates.EventInstanceIdPredicate;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.predicates.EventLocationPredicate;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.predicates.EventModCountPredicate;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.predicates.EventPredicate;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.predicates.EventStepModPredicate;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.predicates.EventThreadRefIdPredicate;
import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;
import org.robovm.debugger.utils.bytebuffer.DataBufferWriter;

public class JdwpEventReqSetHandler
implements IJdwpRequestHandler {
    private final IJdwpEventDelegate center;

    public JdwpEventReqSetHandler(IJdwpEventDelegate center) {
        this.center = center;
    }

    @Override
    public short handle(DataBufferReader payload, DataBufferWriter output) {
        byte eventKind = payload.readByte();
        byte suspendPolicy = payload.readByte();
        ArrayList<EventPredicate> eventPredicates = new ArrayList<EventPredicate>();
        int modifierCount = payload.readInt32();
        try {
            block15: for (int i = 0; i < modifierCount; ++i) {
                byte modKind = payload.readByte();
                switch (modKind) {
                    case 1: {
                        int caseCount = payload.readInt32();
                        eventPredicates.add(new EventModCountPredicate(modKind, caseCount));
                        continue block15;
                    }
                    case 2: {
                        int exprID = payload.readInt32();
                        continue block15;
                    }
                    case 3: {
                        if (eventKind == 9) {
                            throw new DebuggerException(102);
                        }
                        long threadID = payload.readLong();
                        eventPredicates.add(new EventThreadRefIdPredicate(modKind, threadID));
                        continue block15;
                    }
                    case 4: {
                        long refTypeId = payload.readLong();
                        eventPredicates.add(new EventClassTypeIdPredicate(modKind, refTypeId));
                        continue block15;
                    }
                    case 5: {
                        String machPattern = payload.readStringWithLen();
                        eventPredicates.add(new EventClassNameMatchPredicate(modKind, machPattern, false));
                        continue block15;
                    }
                    case 6: {
                        String excludePattern = payload.readStringWithLen();
                        eventPredicates.add(new EventClassNameMatchPredicate(modKind, excludePattern, true));
                        continue block15;
                    }
                    case 7: {
                        if (eventKind != 1 && eventKind != 2 && eventKind != 4) {
                            throw new DebuggerException(24);
                        }
                        byte tag = payload.readByte();
                        long classID = payload.readLong();
                        long methodID = payload.readLong();
                        long index = payload.readLong();
                        eventPredicates.add(new EventLocationPredicate(modKind, tag, classID, methodID, index));
                        continue block15;
                    }
                    case 8: {
                        if (eventKind != 4) {
                            throw new DebuggerException(102);
                        }
                        long exceptionRefTypeID = payload.readLong();
                        boolean caught = payload.readBoolean();
                        boolean uncaught = payload.readBoolean();
                        eventPredicates.add(new EventExceptionPredicate(modKind, exceptionRefTypeID, caught, uncaught));
                        continue block15;
                    }
                    case 9: {
                        long referenceTypeID = payload.readLong();
                        long fieldID = payload.readLong();
                        continue block15;
                    }
                    case 10: {
                        if (eventKind != 1) {
                            throw new DebuggerException(102);
                        }
                        long stepThreadID = payload.readLong();
                        int stepSize = payload.readInt32();
                        int stepDepth = payload.readInt32();
                        eventPredicates.add(new EventStepModPredicate(modKind, stepThreadID, stepSize, stepDepth));
                        continue block15;
                    }
                    case 11: {
                        long instanceId = payload.readLong();
                        eventPredicates.add(new EventInstanceIdPredicate(modKind, instanceId));
                        continue block15;
                    }
                    default: {
                        throw new DebuggerException("unsupported modifier kind " + modKind, 99);
                    }
                }
            }
            int requestId = this.center.jdwpSetEventRequest(eventKind, suspendPolicy, eventPredicates);
            output.writeInt32(requestId);
            return 0;
        }
        catch (DebuggerException e) {
            if (e.getCode() != -1) {
                return (short)e.getCode();
            }
            throw e;
        }
    }

    @Override
    public byte getCommandSet() {
        return 15;
    }

    @Override
    public byte getCommand() {
        return 1;
    }

    public String toString() {
        return "EventRequest(15).Set(1)";
    }
}

