/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.classtype;

import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.jdwp.handlers.objectreference.IJdwpInstanceDelegate;
import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;
import org.robovm.debugger.utils.bytebuffer.DataBufferWriter;

public class JdwpClassTypeSetValuesHandler
implements IJdwpRequestHandler {
    private final IJdwpInstanceDelegate delegate;

    public JdwpClassTypeSetValuesHandler(IJdwpInstanceDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public short handle(DataBufferReader payload, DataBufferWriter output) {
        long objectId = payload.readLong();
        int count = payload.readInt32();
        try {
            this.delegate.jdwpFieldSetValues(objectId, count, true, payload);
        }
        catch (DebuggerException e) {
            if (e.getCode() < 0) {
                throw e;
            }
            return (short)e.getCode();
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 3;
    }

    @Override
    public byte getCommand() {
        return 2;
    }

    public String toString() {
        return "ClassType(3).SetValues(2)";
    }
}

