/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.hooks.unitls;

import java.io.OutputStream;
import java.nio.ByteOrder;
import org.robovm.debugger.hooks.IHooksApi;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;

public class TargetByteBufferReader
implements DataBufferReader {
    private final IHooksApi hooksApi;
    private final boolean is64bit;
    private long address;

    public TargetByteBufferReader(IHooksApi api, boolean is64bit) {
        this.is64bit = is64bit;
        this.hooksApi = api;
    }

    @Override
    public void expects(int bytes) {
    }

    @Override
    public byte readByte() {
        byte[] bytes = this.hooksApi.readMemory(this.address, 1);
        ++this.address;
        return bytes[0];
    }

    @Override
    public short readInt16() {
        byte[] bytes = this.hooksApi.readMemory(this.address, 2);
        this.address += 2L;
        return (short)(bytes[0] & 0xFF | (bytes[1] & 0xFF) << 8);
    }

    @Override
    public int readInt32() {
        byte[] bytes = this.hooksApi.readMemory(this.address, 4);
        this.address += 4L;
        return bytes[0] & 0xFF | (bytes[1] & 0xFF) << 8 | (bytes[2] & 0xFF) << 16 | (bytes[3] & 0xFF) << 24;
    }

    @Override
    public long readLong() {
        byte[] bytes = this.hooksApi.readMemory(this.address, 8);
        this.address += 8L;
        return (long)(bytes[0] & 0xFF) | (long)(bytes[1] & 0xFF) << 8 | (long)(bytes[2] & 0xFF) << 16 | (long)(bytes[3] & 0xFF) << 24 | (long)(bytes[4] & 0xFF) << 32 | (long)(bytes[5] & 0xFF) << 40 | (long)(bytes[6] & 0xFF) << 48 | (long)(bytes[7] & 0xFF) << 56;
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt32());
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public boolean is64bit() {
        return this.is64bit;
    }

    public String readStringZAtPtr(long addr) {
        return this.hooksApi.readCString(addr);
    }

    @Override
    public byte[] readBytes(int numBytes) {
        if (numBytes <= 0) {
            throw new IllegalArgumentException("invalid number of bytes to read " + numBytes);
        }
        byte[] bytes = this.hooksApi.readMemory(this.address, numBytes);
        this.address += (long)numBytes;
        return bytes;
    }

    @Override
    public void readBytes(byte[] dst, int offset, int numBytes) {
        if (numBytes <= 0) {
            throw new IllegalArgumentException("invalid number of bytes to read " + numBytes);
        }
        byte[] bytes = this.hooksApi.readMemory(this.address, numBytes);
        this.address += (long)numBytes;
        System.arraycopy(bytes, 0, dst, offset, bytes.length);
    }

    @Override
    public void skip(int bytesToSkip) {
        this.address += (long)bytesToSkip;
    }

    @Override
    public long position() {
        return this.address;
    }

    @Override
    public TargetByteBufferReader setPosition(long position) {
        this.address = position;
        return this;
    }

    @Override
    public long limit() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TargetByteBufferReader reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasRemaining() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int remaining() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readStringZ() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readStringZ(long at) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readString(int size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readStringWithLen() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] readBytes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readToStream(OutputStream os, long position, int count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TargetByteBufferReader setByteOrder(ByteOrder order) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TargetByteBufferReader sliceAt(long pos, int size, long newBottomLimit, boolean as64bit) {
        throw new UnsupportedOperationException();
    }
}

