/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.hooks.payloads;

import java.util.Arrays;
import org.robovm.debugger.hooks.payloads.HooksCallStackEntry;
import org.robovm.debugger.hooks.payloads.HooksEventPayload;

public class HooksThreadStoppedEventPayload
extends HooksEventPayload {
    private final long threadObj;
    private final long thread;
    private final long throwable;
    private final int threadStatus;
    private final boolean isCaught;
    private final HooksCallStackEntry[] callStack;

    public HooksThreadStoppedEventPayload(int eventId, long threadObj, long thread, int threadStatus, HooksCallStackEntry[] callStack) {
        super(eventId);
        this.threadObj = threadObj;
        this.thread = thread;
        this.throwable = 0L;
        this.isCaught = false;
        this.threadStatus = threadStatus;
        this.callStack = callStack;
    }

    public HooksThreadStoppedEventPayload(int eventId, long threadObj, long thread, long throwable, boolean isCaught, int threadStatus, HooksCallStackEntry[] callStack) {
        super(eventId);
        this.threadObj = threadObj;
        this.thread = thread;
        this.throwable = throwable;
        this.isCaught = isCaught;
        this.threadStatus = threadStatus;
        this.callStack = callStack;
    }

    public long threadObj() {
        return this.threadObj;
    }

    public long thread() {
        return this.thread;
    }

    public long throwable() {
        return this.throwable;
    }

    public boolean isCaught() {
        return this.isCaught;
    }

    public int getThreadStatus() {
        return this.threadStatus;
    }

    public HooksCallStackEntry[] callStack() {
        return this.callStack;
    }

    public String toString() {
        return "HooksThreadStoppedEventPayload{threadObj=" + this.threadObj + ", thread=" + this.thread + ", throwable=" + this.throwable + ", isCaught=" + this.isCaught + ", callStack=" + Arrays.toString(this.callStack) + "}";
    }
}

