/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.delegates;

import java.nio.ByteOrder;
import java.util.List;
import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.delegates.DebuggerToolBox;
import org.robovm.debugger.delegates.InstanceUtils;
import org.robovm.debugger.delegates.JdwpArrayDelegate;
import org.robovm.debugger.delegates.JdwpEventCenterDelegate;
import org.robovm.debugger.delegates.RuntimeUtils;
import org.robovm.debugger.delegates.StackFrameDelegate;
import org.robovm.debugger.delegates.ThreadDelegate;
import org.robovm.debugger.hooks.IHooksApi;
import org.robovm.debugger.jdwp.IJdwpServerApi;
import org.robovm.debugger.jdwp.handlers.array.IJdwpArrayDelegate;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.IJdwpEventDelegate;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.predicates.EventPredicate;
import org.robovm.debugger.jdwp.handlers.objectreference.IJdwpInstanceDelegate;
import org.robovm.debugger.jdwp.handlers.stackframe.IJdwpStackFrameDelegate;
import org.robovm.debugger.jdwp.handlers.thread.IJdwpThreadDelegate;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.state.instances.VmClassInstance;
import org.robovm.debugger.state.instances.VmStringInstance;
import org.robovm.debugger.utils.DbgLogger;
import org.robovm.debugger.utils.DebuggerThread;
import org.robovm.debugger.utils.IDebuggerToolbox;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;
import org.robovm.debugger.utils.bytebuffer.DataBufferReaderWriter;
import org.robovm.debugger.utils.bytebuffer.DataBufferWriter;
import org.robovm.debugger.utils.bytebuffer.DataByteBufferWriter;

public class AllDelegates
implements IJdwpEventDelegate,
IJdwpArrayDelegate,
IDebuggerToolbox,
IJdwpThreadDelegate,
IJdwpInstanceDelegate,
IJdwpStackFrameDelegate {
    private final DbgLogger log = DbgLogger.get("Delegates");
    private final DebuggerToolBox toolBox;
    private final VmDebuggerState state;
    private final JdwpEventCenterDelegate events;
    private JdwpArrayDelegate arrays;
    private final ThreadDelegate threads;
    private IJdwpServerApi jdwpServerApi;
    private IHooksApi hooksApi;
    private RuntimeUtils runtime;
    private final DataBufferReaderWriter sharedTargetPacket;
    private InstanceUtils instances;
    private StackFrameDelegate stackframes;

    public AllDelegates(DebuggerThread.Catcher catcher, VmDebuggerState state) {
        this.toolBox = new DebuggerToolBox(catcher);
        this.state = state;
        this.threads = new ThreadDelegate(this);
        this.sharedTargetPacket = new DataByteBufferWriter(state.isTarget64bit());
        this.sharedTargetPacket.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.events = new JdwpEventCenterDelegate(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnectedToTarget(IHooksApi api, long runtimeMemoryOffset) {
        Object object = this.state.centralLock();
        synchronized (object) {
            this.hooksApi = api;
            this.runtime = new RuntimeUtils(this, runtimeMemoryOffset);
            this.instances = new InstanceUtils(this);
            this.stackframes = new StackFrameDelegate(this);
            this.arrays = new JdwpArrayDelegate(this);
            this.events.onConnectedToTarget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnectedToJdwp(IJdwpServerApi api) {
        Object object = this.state.centralLock();
        synchronized (object) {
            this.jdwpServerApi = api;
            this.events.onConnectedToJdpw();
        }
    }

    public void shutdown() {
        this.toolBox.shutdown();
    }

    public DbgLogger log() {
        return this.log;
    }

    public DebuggerToolBox toolBox() {
        return this.toolBox;
    }

    public JdwpEventCenterDelegate events() {
        return this.events;
    }

    public VmDebuggerState state() {
        return this.state;
    }

    public JdwpArrayDelegate arrays() {
        return this.arrays;
    }

    public IJdwpServerApi jdwpServerApi() {
        return this.jdwpServerApi;
    }

    public IHooksApi hooksApi() {
        return this.hooksApi;
    }

    public RuntimeUtils runtime() {
        return this.runtime;
    }

    public ThreadDelegate threads() {
        return this.threads;
    }

    public InstanceUtils instances() {
        return this.instances;
    }

    public StackFrameDelegate stackframes() {
        return this.stackframes;
    }

    public DataBufferReaderWriter sharedTargetPacket() {
        return this.sharedTargetPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int jdwpSetEventRequest(byte eventKind, byte suspendPolicy, List<EventPredicate> predicates) {
        Object object = this.state.centralLock();
        synchronized (object) {
            return this.events.jdwpSetEventRequest(eventKind, suspendPolicy, predicates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short jdwpClearEventRequest(byte eventKind, int requestID) {
        Object object = this.state.centralLock();
        synchronized (object) {
            return this.events.jdwpClearEventRequest(eventKind, requestID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jdwpClearAllBreakpoints() {
        Object object = this.state.centralLock();
        synchronized (object) {
            this.events.jdwpClearAllBreakpoints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jdwpHoldEvents() {
        Object object = this.state.centralLock();
        synchronized (object) {
            this.events.jdwpHoldEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jdwpReleaseEvents() {
        Object object = this.state.centralLock();
        synchronized (object) {
            this.events.jdwpReleaseEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int jdwpArrayLength(long arrayId) throws DebuggerException {
        Object object = this.state.centralLock();
        synchronized (object) {
            return this.arrays.jdwpArrayLength(arrayId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jdwpArrayGetValue(long arrayId, int index, int length, DataBufferWriter writer) throws DebuggerException {
        Object object = this.state.centralLock();
        synchronized (object) {
            this.arrays.jdwpArrayGetValue(arrayId, index, length, writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jdwpArraySetValue(long arrayId, int index, int length, DataBufferReader reader) throws DebuggerException {
        Object object = this.state.centralLock();
        synchronized (object) {
            this.arrays.jdwpArraySetValue(arrayId, index, length, reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long jdwpArrayCreateInstance(long arrayTypeId, int length) {
        Object object = this.state.centralLock();
        synchronized (object) {
            return this.arrays.jdwpArrayCreateInstance(arrayTypeId, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jdwpSuspendThread(long threadId) throws DebuggerException {
        Object object = this.state.centralLock();
        synchronized (object) {
            this.threads.jdwpSuspendThread(threadId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jdwpResumeThread(long threadId) throws DebuggerException {
        Object object = this.state.centralLock();
        synchronized (object) {
            this.threads.jdwpResumeThread(threadId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jdwpSuspendAllThreads() {
        Object object = this.state.centralLock();
        synchronized (object) {
            this.threads.jdwpSuspendAllThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jdwpResumeAllThreads() {
        Object object = this.state.centralLock();
        synchronized (object) {
            this.threads.jdwpResumeAllThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VmStringInstance jdwpCreateStringInstance(String value) {
        Object object = this.state.centralLock();
        synchronized (object) {
            return this.instances.createVmStringInstance(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String jdwpGetStringValue(long stringRefId) {
        Object object = this.state.centralLock();
        synchronized (object) {
            return this.instances.readStringValue(stringRefId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jdwpFieldGetValues(long objectId, long[] fields2, boolean isStatic, DataBufferWriter output) {
        Object object = this.state.centralLock();
        synchronized (object) {
            this.instances.jdwpFieldGetValues(objectId, fields2, isStatic, output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jdwpFieldSetValues(long objectId, int fieldsCount, boolean isStatic, DataBufferReader payload) {
        Object object = this.state.centralLock();
        synchronized (object) {
            this.instances.jdwpFieldSetValues(objectId, fieldsCount, isStatic, payload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VmClassInstance jdwpGetClazzObject(long objectId) throws DebuggerException {
        Object object = this.state.centralLock();
        synchronized (object) {
            return this.instances.getClazzObject(objectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jdwpInvokeMethod(long objectOrClassId, long threadId, long methodId, boolean isStatic, boolean singleThread, Object[] args, DataBufferWriter output) {
        Object object = this.state.centralLock();
        synchronized (object) {
            this.instances.jdwpInvokeMethod(objectOrClassId, threadId, methodId, isStatic, singleThread, args, output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getFrameValues(long threadId, long frameId, int[] varIndexes, byte[] varTags, DataBufferWriter output) {
        Object object = this.state.centralLock();
        synchronized (object) {
            this.stackframes.getFrameValues(threadId, frameId, varIndexes, varTags, output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFrameValues(long threadId, long frameId, DataBufferReader payload, int count) {
        Object object = this.state.centralLock();
        synchronized (object) {
            this.stackframes.setFrameValues(threadId, frameId, payload, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getFrameVariable(long threadId, long frameId, String variableName, DataBufferWriter output) {
        Object object = this.state.centralLock();
        synchronized (object) {
            this.stackframes.getFrameVariable(threadId, frameId, variableName, output);
        }
    }

    @Override
    public Thread createThread(Runnable r, String name) {
        return this.toolBox.createThread(r, name);
    }
}

