/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.util.generic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.robovm.compiler.util.generic.ImplForType;
import org.robovm.compiler.util.generic.Type;

public final class ListOfTypes {
    public static final ListOfTypes EMPTY = new ListOfTypes(0);
    private final ArrayList<Type> types;
    private Type[] resolvedTypes;

    public ListOfTypes(int capacity) {
        this.types = new ArrayList(capacity);
    }

    public ListOfTypes(Type[] types) {
        this.types = new ArrayList(types.length);
        for (Type type : types) {
            this.types.add(type);
        }
    }

    public void add(Type type) {
        if (type == null) {
            throw new NullPointerException("type == null");
        }
        this.types.add(type);
    }

    public int length() {
        return this.types.size();
    }

    public Type[] getResolvedTypes() {
        Type[] typeArray;
        Type[] result = this.resolvedTypes;
        if (result != null) {
            typeArray = result;
        } else {
            this.resolvedTypes = this.resolveTypes(this.types);
            typeArray = this.resolvedTypes;
        }
        return typeArray;
    }

    private Type[] resolveTypes(List<Type> unresolved) {
        Type[] result = new Type[unresolved.size()];
        for (int i = 0; i < unresolved.size(); ++i) {
            Type type = unresolved.get(i);
            try {
                result[i] = ((ImplForType)type).getResolvedType();
                continue;
            }
            catch (ClassCastException e) {
                result[i] = type;
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ListOfTypes)) {
            return false;
        }
        ListOfTypes that = (ListOfTypes)obj;
        return Arrays.equals(this.getResolvedTypes(), that.getResolvedTypes());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.types.size(); ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(this.types.get(i));
        }
        return result.toString();
    }
}

