/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.target.ios;

import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.PropertyListParser;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.tuple.Pair;
import org.robovm.compiler.CompilerException;
import org.robovm.compiler.config.AppExtension;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.CpuArch;
import org.robovm.compiler.config.Environment;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.config.Resource;
import org.robovm.compiler.config.WatchKitApp;
import org.robovm.compiler.log.Logger;
import org.robovm.compiler.target.AbstractTarget;
import org.robovm.compiler.target.LaunchParameters;
import org.robovm.compiler.target.Launcher;
import org.robovm.compiler.target.ios.AppLauncherProcess;
import org.robovm.compiler.target.ios.IOSDeviceLaunchParameters;
import org.robovm.compiler.target.ios.IOSSimulatorLaunchParameters;
import org.robovm.compiler.target.ios.ProvisioningProfile;
import org.robovm.compiler.target.ios.SDK;
import org.robovm.compiler.target.ios.SigningIdentity;
import org.robovm.compiler.target.ios.SimLauncherProcess;
import org.robovm.compiler.util.Executor;
import org.robovm.compiler.util.PList;
import org.robovm.compiler.util.ToolchainUtil;
import org.robovm.compiler.util.io.OpenOnWriteFileOutputStream;
import org.robovm.libimobiledevice.AfcClient;
import org.robovm.libimobiledevice.IDevice;
import org.robovm.libimobiledevice.InstallationProxyClient;
import org.robovm.libimobiledevice.util.AppLauncher;
import org.robovm.libimobiledevice.util.AppLauncherCallback;
import org.xml.sax.SAXException;

public class IOSTarget
extends AbstractTarget {
    final List<String> excludedKeys = Arrays.asList("com.apple.developer.icloud-container-development-container-identifiers", "com.apple.developer.icloud-container-environment", "com.apple.developer.icloud-container-identifiers", "com.apple.developer.icloud-services", "com.apple.developer.restricted-resource-mode", "com.apple.developer.ubiquity-container-identifiers", "com.apple.developer.ubiquity-kvstore-identifier", "inter-app-audio", "com.apple.developer.homekit", "com.apple.developer.healthkit", "com.apple.developer.in-app-payments", "com.apple.developer.associated-domains", "com.apple.security.application-groups", "com.apple.developer.maps", "com.apple.developer.networking.vpn.api", "com.apple.external-accessory.wireless-configuration");
    public static final String TYPE = "ios";
    private Arch arch;
    private SDK sdk;
    private File entitlementsPList;
    private SigningIdentity signIdentity;
    private ProvisioningProfile provisioningProfile;
    @Deprecated
    private IDevice device;
    private File partialPListDir;

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Arch getArch() {
        return this.arch;
    }

    @Override
    public LaunchParameters createLaunchParameters() {
        if (IOSTarget.isSimulatorArch(this.arch)) {
            return new IOSSimulatorLaunchParameters();
        }
        return new IOSDeviceLaunchParameters();
    }

    public static boolean isSimulatorArch(Arch arch) {
        Environment env = arch.getEnv();
        CpuArch cpuArch = arch.getCpuArch();
        return env == Environment.Simulator && (cpuArch == CpuArch.x86_64 || cpuArch == CpuArch.arm64);
    }

    public static boolean isDeviceArch(Arch arch) {
        Environment env = arch.getEnv();
        CpuArch cpuArch = arch.getCpuArch();
        return env == Environment.Native && (cpuArch == CpuArch.thumbv7 || cpuArch == CpuArch.arm64);
    }

    private File getPartialPListDir() {
        if (!this.partialPListDir.exists()) {
            this.partialPListDir.mkdirs();
        }
        return this.partialPListDir;
    }

    public List<SDK> getSDKs() {
        if (IOSTarget.isSimulatorArch(this.arch)) {
            return SDK.listSimulatorSDKs();
        }
        return SDK.listDeviceSDKs();
    }

    public IDevice getDevice() {
        return this.device;
    }

    @Override
    protected Launcher createLauncher(LaunchParameters launchParameters) throws IOException {
        if (IOSTarget.isSimulatorArch(this.arch)) {
            return this.createIOSSimLauncher(launchParameters);
        }
        return this.createIOSDevLauncher(launchParameters);
    }

    private Launcher createIOSSimLauncher(LaunchParameters launchParameters) throws IOException {
        return new SimLauncherProcess(this.config.getLogger(), this.getAppDir(), this.getBundleId(), (IOSSimulatorLaunchParameters)launchParameters);
    }

    private Launcher createIOSDevLauncher(LaunchParameters launchParameters) throws IOException {
        final IOSDeviceLaunchParameters deviceLaunchParameters = (IOSDeviceLaunchParameters)launchParameters;
        String deviceUdid = deviceLaunchParameters.getDeviceId();
        int forwardPort = deviceLaunchParameters.getForwardPort();
        AppLauncherCallback callback = deviceLaunchParameters.getAppPathCallback() != null ? new AppLauncherCallback(){
            final AppLauncherCallback delegate;
            {
                this.delegate = deviceLaunchParameters.getAppPathCallback();
            }

            public void setAppLaunchInfo(AppLauncherCallback.AppLauncherInfo info) {
                IOSTarget.this.device = info.getDevice();
                this.delegate.setAppLaunchInfo(info);
            }

            public byte[] filterOutput(byte[] data) {
                return this.delegate.filterOutput(data);
            }
        } : null;
        OutputStream out = null;
        out = launchParameters.getStdoutFifo() != null ? new OpenOnWriteFileOutputStream(launchParameters.getStdoutFifo()) : System.out;
        Map<String, String> env = launchParameters.getEnvironment();
        if (env == null) {
            env = new HashMap<String, String>();
        }
        env.put("OS_ACTIVITY_DT_MODE", "");
        AppLauncher launcher = new AppLauncher(deviceUdid, this.getAppDir()){

            protected void log(String s, Object ... args) {
                IOSTarget.this.config.getLogger().info(s, args);
            }
        }.stdout(out).closeOutOnExit(true).args(launchParameters.getArguments(true).toArray(new String[0])).env(env).forward(forwardPort).appLauncherCallback(callback).xcodePath(ToolchainUtil.findXcodePath()).uploadProgressCallback(new AfcClient.UploadProgressCallback(){
            boolean first = true;

            public void success() {
                IOSTarget.this.config.getLogger().info("[100%%] Upload complete", new Object[0]);
            }

            public void progress(File path, int percentComplete) {
                if (this.first) {
                    IOSTarget.this.config.getLogger().info("[  0%%] Beginning upload...", new Object[0]);
                }
                this.first = false;
                IOSTarget.this.config.getLogger().info("[%3d%%] Uploading %s...", percentComplete, path);
            }

            public void error(String message) {
            }
        }).installStatusCallback(new InstallationProxyClient.StatusCallback(){
            boolean first = true;

            public void success() {
                IOSTarget.this.config.getLogger().info("[100%%] Install complete", new Object[0]);
            }

            public void progress(String status, int percentComplete) {
                if (this.first) {
                    IOSTarget.this.config.getLogger().info("[  0%%] Beginning installation...", new Object[0]);
                }
                this.first = false;
                IOSTarget.this.config.getLogger().info("[%3d%%] %s", percentComplete, status);
            }

            public void error(String message) {
            }
        });
        return new AppLauncherProcess(this.config.getLogger(), launcher, launchParameters);
    }

    @Override
    protected void doBuild(File outFile, List<String> ccArgs, List<File> objectFiles, List<String> libArgs) throws IOException {
        if (!this.config.getFrameworks().contains("UIKit")) {
            libArgs.add("-framework");
            libArgs.add("UIKit");
        }
        String minVersion = this.getMinimumOSVersion();
        int majorVersionNumber = -1;
        try {
            majorVersionNumber = Integer.parseInt(minVersion.substring(0, minVersion.indexOf(46)));
            int minMajorSupportedVersion = Integer.parseInt(this.config.getOs().getMinVersion().substring(0, this.config.getOs().getMinVersion().indexOf(46)));
            if (majorVersionNumber < minMajorSupportedVersion) {
                throw new CompilerException("MinimumOSVersion of " + minVersion + " is not supported. The minimum version for this platform is " + this.config.getOs().getMinVersion());
            }
        }
        catch (NumberFormatException e) {
            throw new CompilerException("Failed to get major version number from MinimumOSVersion string '" + minVersion + "'");
        }
        ccArgs.add("--target=" + this.config.getClangTriple(this.getMinimumOSVersion()));
        if (IOSTarget.isDeviceArch(this.arch) && this.config.isEnableBitcode()) {
            ccArgs.add("-fembed-bitcode");
        }
        ccArgs.add("-isysroot");
        ccArgs.add(this.sdk.getRoot().getAbsolutePath());
        if (this.config.hasSwiftSupport()) {
            libArgs.add("-Xlinker");
            libArgs.add("-rpath");
            libArgs.add("-Xlinker");
            libArgs.add("/usr/lib/swift");
        }
        libArgs.add("-Xlinker");
        libArgs.add("-rpath");
        libArgs.add("-Xlinker");
        libArgs.add("@executable_path/Frameworks");
        libArgs.add("-Xlinker");
        libArgs.add("-rpath");
        libArgs.add("-Xlinker");
        libArgs.add("@loader_path/Frameworks");
        if (!IOSTarget.isDeviceArch(this.arch)) {
            File simEntitlement = this.createSimulatedEntitlementsPList(this.getBundleId());
            ccArgs.add("-Xlinker");
            ccArgs.add("-sectcreate");
            ccArgs.add("-Xlinker");
            ccArgs.add("__TEXT");
            ccArgs.add("-Xlinker");
            ccArgs.add("__entitlements");
            ccArgs.add("-Xlinker");
            ccArgs.add(simEntitlement.getAbsolutePath());
        }
        super.doBuild(outFile, ccArgs, objectFiles, libArgs);
    }

    protected void prepareInstall(File installDir) throws IOException {
        this.createInfoPList(installDir);
        this.generateDsym(this.getDsymDir(installDir), new File(installDir, this.getExecutable()));
        if (IOSTarget.isDeviceArch(this.arch)) {
            this.strip(installDir, this.getExecutable());
            if (!this.config.isEnableBitcode()) {
                this.config.getLogger().info("Striping bitcode from binary: %s", new File(installDir, this.getExecutable()));
                this.stripBitcode(new File(installDir, this.getExecutable()));
            }
            if (this.config.isIosSkipSigning()) {
                this.config.getLogger().warn("Skipping code signing. The resulting app will be unsigned and will not run on unjailbroken devices", new Object[0]);
                this.codesignApp(SigningIdentity.ADHOC, this.getOrCreateEntitlementsPList(false, this.getBundleId()), installDir);
            } else {
                String appIdPrefix = this.provisioningProfile.getAppIdPrefix();
                this.copyProvisioningProfile(this.provisioningProfile, installDir);
                boolean getTaskAllow = this.provisioningProfile.getType() == ProvisioningProfile.Type.Development;
                this.signFrameworks(this.signIdentity, installDir);
                this.provisionAppExtensions(this.config.getAppExtensions(), this.signIdentity, installDir);
                this.signAppExtensions(this.signIdentity, installDir, appIdPrefix, getTaskAllow);
                if (this.config.getWatchKitApp() != null) {
                    this.provisionWatchApp(this.signIdentity, installDir);
                    this.signWatchApp(this.signIdentity, installDir, appIdPrefix, getTaskAllow);
                }
                this.codesignApp(this.signIdentity, this.getOrCreateEntitlementsPList(getTaskAllow, this.getBundleId()), installDir);
            }
        }
    }

    private void copyProvisioningProfile(ProvisioningProfile profile, File destDir) throws IOException {
        this.config.getLogger().info("Copying %s provisioning profile: %s (%s)", new Object[]{profile.getType(), profile.getName(), profile.getEntitlements().objectForKey("application-identifier")});
        FileUtils.copyFile((File)profile.getFile(), (File)new File(destDir, "embedded.mobileprovision"));
    }

    @Override
    public void prepareLaunch() throws IOException {
        this.prepareLaunch(this.getAppDir());
    }

    protected void prepareLaunch(File appDir) throws IOException {
        super.doInstall(appDir, this.getExecutable(), appDir);
        this.createInfoPList(appDir);
        this.generateDsym(this.getDsymDir(appDir), new File(appDir, this.getExecutable()));
        this.copyToIndexedDir(appDir, this.getExecutable(), this.getDsymDir(appDir), new File(appDir, this.getExecutable()));
        this.strip(appDir, this.getExecutable());
        if (IOSTarget.isDeviceArch(this.arch)) {
            if (this.config.isIosSkipSigning()) {
                this.config.getLogger().warn("Skiping code signing. The resulting app will be unsigned and will not run on unjailbroken devices", new Object[0]);
                this.codesignApp(SigningIdentity.ADHOC, this.getOrCreateEntitlementsPList(true, this.getBundleId()), appDir);
            } else {
                String appIdPrefix = this.provisioningProfile.getAppIdPrefix();
                this.copyProvisioningProfile(this.provisioningProfile, appDir);
                boolean getTaskAllow = this.provisioningProfile.getType() == ProvisioningProfile.Type.Development;
                this.signFrameworks(this.signIdentity, appDir);
                this.provisionAppExtensions(this.config.getAppExtensions(), this.signIdentity, appDir);
                this.signAppExtensions(this.signIdentity, appDir, appIdPrefix, getTaskAllow);
                if (this.config.getWatchKitApp() != null) {
                    this.provisionWatchApp(this.signIdentity, appDir);
                    this.signWatchApp(this.signIdentity, appDir, appIdPrefix, getTaskAllow);
                }
                this.codesignApp(this.signIdentity, this.getOrCreateEntitlementsPList(getTaskAllow, this.getBundleId()), appDir);
            }
        } else {
            if (this.sdk.getVersionCode() >= 721664) {
                this.signFrameworks(SigningIdentity.ADHOC, appDir);
                this.signAppExtensions(SigningIdentity.ADHOC, appDir, null, true);
                if (this.config.getWatchKitApp() != null) {
                    this.signWatchApp(SigningIdentity.ADHOC, appDir, null, true);
                }
            }
            this.codesignApp(SigningIdentity.ADHOC, this.createEntitlementsPList(true), appDir);
        }
    }

    private void signFrameworks(SigningIdentity identity, File appDir) throws IOException {
        File frameworksDir = new File(appDir, "Frameworks");
        if (frameworksDir.exists() && frameworksDir.isDirectory()) {
            for (File swiftLib : frameworksDir.listFiles()) {
                if (!swiftLib.getName().endsWith(".dylib")) continue;
                this.codesignSwiftLib(identity, swiftLib);
            }
            for (File framework : frameworksDir.listFiles()) {
                if (!framework.isDirectory() || !framework.getName().endsWith(".framework")) continue;
                this.codesignCustomFramework(identity, framework);
            }
        }
    }

    private void signAppExtensions(SigningIdentity identity, File appDir, String appIdPrefix, boolean getTaskAllow) throws IOException {
        File extensionsDir = new File(appDir, "PlugIns");
        if (extensionsDir.exists() && extensionsDir.isDirectory()) {
            for (File extension : extensionsDir.listFiles()) {
                if (!extension.isDirectory() || !extension.getName().endsWith(".appex")) continue;
                this.signSingleAppExtension(identity, extension, appIdPrefix, getTaskAllow);
            }
        }
    }

    private void signSingleAppExtension(SigningIdentity identity, File extDir, String appIdPrefix, boolean getTaskAllow) throws IOException {
        Object appExBundleId = null;
        if (appIdPrefix != null) {
            File infoPlistFile = new File(extDir, "Info.plist");
            try {
                NSDictionary infoPlist = (NSDictionary)PropertyListParser.parse((File)infoPlistFile);
                appExBundleId = infoPlist.get((Object)"CFBundleIdentifier").toString();
            }
            catch (PropertyListFormatException | ParseException | ParserConfigurationException | SAXException e) {
                throw new IOException(e);
            }
            appExBundleId = appIdPrefix + "." + (String)appExBundleId;
        }
        File entitlements = this.createEntitlementForAppEx(getTaskAllow, (String)appExBundleId);
        this.codesignAppExtension(identity, entitlements, extDir);
    }

    private void signWatchApp(SigningIdentity identity, File appDir, String appIdPrefix, boolean getTaskAllow) throws IOException {
        WatchKitApp waConfig = this.config.getWatchKitApp();
        String waName = waConfig.getWatchAppName();
        File waDir = new File(appDir, "Watch/" + waName);
        if (!waDir.exists() || !waDir.isDirectory()) {
            throw new IllegalStateException("Error while signing WatchApp, watch directory doesn't exist: " + waDir.getAbsolutePath());
        }
        this.signAppExtensions(identity, waDir, appIdPrefix, getTaskAllow);
        this.signSingleAppExtension(identity, waDir, appIdPrefix, getTaskAllow);
    }

    private File createEntitlementForAppEx(boolean getTaskAllow, String bundleId) throws IOException {
        try {
            File destFile = new File(this.config.getTmpDir(), "AppExtEntitlements.plist");
            NSDictionary dict = new NSDictionary();
            if (bundleId != null) {
                dict.put("application-identifier", (Object)bundleId);
            }
            String prefix = IOSTarget.isDeviceArch(this.arch) ? "" : "com.apple.security.";
            dict.put(prefix + "get-task-allow", (Object)getTaskAllow);
            PropertyListParser.saveAsXML((NSObject)dict, (File)destFile);
            return destFile;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void provisionAppExtensions(List<AppExtension> extensions, SigningIdentity signIdentity, File installDir) throws IOException {
        File pluginsDir = new File(installDir, "PlugIns");
        if (pluginsDir.exists() && pluginsDir.isDirectory()) {
            HashMap extensionsMap = new HashMap();
            extensions.forEach(e -> extensionsMap.put(e.getNameWithExt(".appex"), e));
            for (File extPath : pluginsDir.listFiles()) {
                if (!extPath.isDirectory() || !extPath.getName().endsWith(".appex")) {
                    this.config.getLogger().info("Skipping not expected file/dir '%s' in PlugIns folder: %s", extPath.getName(), pluginsDir.getAbsolutePath());
                    continue;
                }
                String name = extPath.getName();
                AppExtension extension = (AppExtension)extensionsMap.get(name);
                if (extension == null) {
                    extension = AppExtension.DEFAULT_RULE;
                    this.config.getLogger().info("Using default signing rules for app extension " + name, new Object[0]);
                }
                this.provisionSingleAppExtension(extension, signIdentity, extPath);
            }
        }
    }

    private void provisionSingleAppExtension(AppExtension extension, SigningIdentity signIdentity, File extPath) throws IOException {
        String appExBundleId;
        if (extension.skipSigning()) {
            return;
        }
        File infoPlistFile = new File(extPath, "Info.plist");
        try {
            NSDictionary infoPlist = (NSDictionary)PropertyListParser.parse((File)infoPlistFile);
            appExBundleId = infoPlist.get((Object)"CFBundleIdentifier").toString();
        }
        catch (PropertyListFormatException | ParseException | ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
        String profileName = extension.getProfile();
        ProvisioningProfile appExtProfile = profileName != null ? ProvisioningProfile.find(ProvisioningProfile.list(), profileName) : ProvisioningProfile.find(ProvisioningProfile.list(), signIdentity, appExBundleId);
        if (appExtProfile == null) {
            throw new RuntimeException("Failed to locate provisioning profile for " + extPath.getName());
        }
        this.config.getLogger().info("Copying %s provisioning profile for : %s (%s)", new Object[]{appExtProfile.getType(), appExtProfile.getName(), appExtProfile.getEntitlements().objectForKey("application-identifier")});
        FileUtils.copyFile((File)appExtProfile.getFile(), (File)new File(extPath, "embedded.mobileprovision"));
    }

    private void provisionWatchApp(SigningIdentity signIdentity, File installDir) throws IOException {
        WatchKitApp waConfig = this.config.getWatchKitApp();
        File waDir = new File(installDir, "Watch/" + waConfig.getWatchAppName());
        this.provisionSingleAppExtension(waConfig.getApp(), signIdentity, waDir);
        this.provisionAppExtensions(waConfig.getExtensions(), signIdentity, new File(waDir, "/PlugIns"));
    }

    private void codesignApp(SigningIdentity identity, File entitlementsPList, File appDir) throws IOException {
        this.config.getLogger().info("Code signing app using identity '%s' with fingerprint %s", identity.getName(), identity.getFingerprint());
        this.codesign(identity, entitlementsPList, false, false, true, appDir);
    }

    private void codesignSwiftLib(SigningIdentity identity, File swiftLib) throws IOException {
        this.config.getLogger().info("Code signing swift dylib '%s' using identity '%s' with fingerprint %s", swiftLib.getName(), identity.getName(), identity.getFingerprint());
        this.codesign(identity, null, false, true, false, swiftLib);
    }

    private void codesignCustomFramework(SigningIdentity identity, File frameworkDir) throws IOException {
        this.config.getLogger().info("Code signing framework '%s' using identity '%s' with fingerprint %s", frameworkDir.getName(), identity.getName(), identity.getFingerprint());
        this.codesign(identity, null, true, false, true, frameworkDir);
    }

    private void codesignAppExtension(SigningIdentity identity, File entitlementsPList, File extensionDir) throws IOException {
        this.config.getLogger().info("Code signing app-extension '%s' using identity '%s' with fingerprint %s", extensionDir.getName(), identity.getName(), identity.getFingerprint());
        this.codesign(identity, entitlementsPList, false, false, true, extensionDir);
    }

    private void codesign(SigningIdentity identity, File entitlementsPList, boolean preserveMetadata, boolean verbose, boolean allocate, File target) throws IOException {
        boolean generateDerEntitlement = true;
        this.codesign(identity, entitlementsPList, preserveMetadata, generateDerEntitlement, verbose, allocate, target);
    }

    private void codesign(SigningIdentity identity, File entitlementsPList, boolean preserveMetadata, boolean generateDerEntitlement, boolean verbose, boolean allocate, File target) throws IOException {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("-f");
        args.add("-s");
        args.add(identity.getFingerprint());
        if (entitlementsPList != null) {
            args.add("--entitlements");
            args.add(entitlementsPList);
        }
        if (preserveMetadata) {
            args.add("--preserve-metadata=identifier,entitlements");
        }
        if (generateDerEntitlement) {
            args.add("--generate-entitlement-der");
        }
        if (verbose) {
            args.add("--verbose");
        }
        if (identity == SigningIdentity.ADHOC) {
            args.add("--timestamp=none");
        }
        args.add(target);
        Executor executor = new Executor(this.config.getLogger(), "codesign");
        if (allocate) {
            executor.addEnv("CODESIGN_ALLOCATE", ToolchainUtil.findXcodeCommand("codesign_allocate", "iphoneos"));
        }
        executor.args(args);
        executor.exec();
    }

    private File createEntitlementsPList(boolean getTaskAllow) throws IOException {
        try {
            File destFile = new File(this.config.getTmpDir(), "Entitlements.plist");
            NSDictionary dict = new NSDictionary();
            dict.put("com.apple.security.get-task-allow", (Object)getTaskAllow);
            PropertyListParser.saveAsXML((NSObject)dict, (File)destFile);
            return destFile;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private File createSimulatedEntitlementsPList(String bundleId) throws IOException {
        try {
            NSDictionary dict;
            String teamID = this.config.getProperties().getProperty("teamID");
            if (teamID == null && (teamID = new BigInteger(MessageDigest.getInstance("MD5").digest(bundleId.getBytes())).toString(36).toUpperCase()).length() > 10) {
                teamID = teamID.substring(0, 10);
            }
            File destFile = new File(this.config.getTmpDir(), "Entitlements-Simulated.plist");
            if (this.entitlementsPList != null) {
                Properties properties = new Properties(this.config.getProperties());
                properties.setProperty("teamID", teamID);
                dict = new PList(this.entitlementsPList).parse(properties).getDictionary();
            } else {
                dict = new NSDictionary();
            }
            dict.put("application-identifier", (Object)(teamID + "." + bundleId));
            PropertyListParser.saveAsXML((NSObject)dict, (File)destFile);
            return destFile;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private File getOrCreateEntitlementsPList(boolean getTaskAllow, String bundleId) throws IOException {
        try {
            File destFile = new File(this.config.getTmpDir(), "Entitlements.plist");
            NSDictionary dict = null;
            if (this.provisioningProfile != null) {
                String teamID = this.provisioningProfile.getAppIdPrefix();
                if (this.entitlementsPList != null) {
                    Properties properties = new Properties(this.config.getProperties());
                    properties.setProperty("teamID", teamID);
                    dict = new PList(this.entitlementsPList).parse(properties).getDictionary();
                } else {
                    dict = new NSDictionary();
                }
                NSDictionary profileEntitlements = this.provisioningProfile.getEntitlements();
                for (String key : profileEntitlements.allKeys()) {
                    if (dict.objectForKey(key) != null || this.excludedKeys.contains(key)) continue;
                    dict.put(key, profileEntitlements.objectForKey(key));
                }
                dict.put("application-identifier", (Object)(teamID + "." + bundleId));
            } else {
                dict = this.entitlementsPList == null ? new NSDictionary() : (NSDictionary)PropertyListParser.parse((File)this.entitlementsPList);
            }
            dict.put("get-task-allow", (Object)getTaskAllow);
            PropertyListParser.saveAsXML((NSObject)dict, (File)destFile);
            return destFile;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private File generateDsym(File dsymDir, File exePath) throws IOException {
        FileUtils.deleteDirectory((File)dsymDir);
        ToolchainUtil.generateDsym(this.config, dsymDir, exePath);
        return dsymDir;
    }

    private void dsymToSymbols(File symbolsDir, File dsymDir, String executable) throws IOException {
        File dsymExecutable = new File(dsymDir, "/Contents/Resources/DWARF/" + executable);
        FileUtils.deleteDirectory((File)symbolsDir);
        symbolsDir.mkdirs();
        ToolchainUtil.dsymToSymbols(this.config, dsymExecutable, symbolsDir);
    }

    private void strip(File dir, String executable) throws IOException {
        new Executor(this.config.getLogger(), "xcrun").args("strip", "-x", new File(dir, executable)).exec();
    }

    @Override
    protected void doInstall(File installDir, String executable, File resourcesDir) throws IOException {
        super.doInstall(installDir, this.getExecutable(), resourcesDir);
        this.prepareInstall(installDir);
    }

    @Override
    protected Process doLaunch(LaunchParameters launchParameters) throws IOException {
        if (!this.config.isManuallyPreparedForLaunch()) {
            this.prepareLaunch();
        }
        Process process = super.doLaunch(launchParameters);
        return process;
    }

    @Override
    public List<Arch> getDefaultArchs() {
        return Arrays.asList(new Arch(CpuArch.thumbv7), new Arch(CpuArch.arm64));
    }

    @Override
    public void archive() throws IOException {
        this.config.getLogger().info("Creating IPA in %s", this.config.getInstallDir());
        this.config.getInstallDir().mkdirs();
        File tmpDir = new File(this.config.getInstallDir(), this.getExecutable() + ".app");
        FileUtils.deleteDirectory((File)tmpDir);
        tmpDir.mkdirs();
        super.doInstall(tmpDir, this.getExecutable(), tmpDir);
        this.prepareInstall(tmpDir);
        this.packageApplication(tmpDir);
    }

    private void packageApplication(File appDir) throws IOException {
        String[] plugins;
        File pluginsDir;
        String[] swiftLibs;
        File ipaFile = new File(this.config.getInstallDir(), this.getExecutable() + ".ipa");
        FileUtils.deleteQuietly((File)ipaFile);
        this.config.getLogger().info("Packaging IPA %s from %s", ipaFile.getName(), appDir.getName());
        File tmpDir = new File(this.config.getInstallDir(), "ipabuild");
        FileUtils.deleteDirectory((File)tmpDir);
        tmpDir.mkdirs();
        File payloadDir = new File(tmpDir, "Payload");
        payloadDir.mkdir();
        this.config.getLogger().info("Copying %s to %s", appDir.getName(), payloadDir);
        new Executor(this.config.getLogger(), "cp").args("-Rp", appDir, payloadDir).exec();
        this.config.getLogger().info("Generating Symbols from dsym", new Object[0]);
        this.dsymToSymbols(new File(tmpDir, "Symbols"), this.getDsymDir(appDir), this.getExecutable());
        File frameworksDir = new File(appDir, "Frameworks");
        if (frameworksDir.exists() && this.config.hasSwiftSupport() && this.config.getSwiftSupport().shouldCopySwiftLibs() && (swiftLibs = frameworksDir.list((FilenameFilter)new AndFileFilter((IOFileFilter)new PrefixFileFilter("libswift"), (IOFileFilter)new SuffixFileFilter(".dylib")))) != null && swiftLibs.length > 0) {
            File swiftSupportDir = new File(tmpDir, "SwiftSupport");
            if (this.config.getOs() == OS.ios) {
                if (this.config.getArch().isArm()) {
                    swiftSupportDir = new File(swiftSupportDir, "iphoneos");
                }
            } else {
                swiftSupportDir = new File(swiftSupportDir, "mac");
            }
            swiftSupportDir.mkdirs();
            this.copySwiftLibs(Arrays.asList(swiftLibs), swiftSupportDir, false);
        }
        if ((pluginsDir = new File(appDir, "PlugIns")).exists() && (plugins = pluginsDir.list()) != null && plugins.length > 0) {
            String iStickersExtId = "com.apple.message-payload-provider";
            boolean hasStickers = false;
            for (String p : plugins) {
                File infoPlistFile = new File(new File(pluginsDir, p), "Info.plist");
                if (!infoPlistFile.exists()) continue;
                try {
                    NSDictionary infoPlist = (NSDictionary)PropertyListParser.parse((File)infoPlistFile);
                    NSDictionary extensionDict = (NSDictionary)infoPlist.get((Object)"NSExtension");
                    if (extensionDict == null) continue;
                    hasStickers |= "com.apple.message-payload-provider".equals(extensionDict.get((Object)"NSExtensionPointIdentifier").toJavaObject());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (hasStickers) {
                this.config.getLogger().info("Copying support files for Stickers app extension", new Object[0]);
                File xcodePath = new File(ToolchainUtil.findXcodePath());
                File stickersExtSupportStub = new File(xcodePath, "Platforms/iPhoneOS.platform/Library/Application Support/MessagesApplicationExtensionStub/MessagesApplicationExtensionStub");
                if (!stickersExtSupportStub.exists()) {
                    throw new FileNotFoundException("Stickers support: MessagesApplicationExtensionStub not found in " + stickersExtSupportStub.getAbsolutePath());
                }
                File stickersExtSupportDestDir = new File(tmpDir, "MessagesApplicationExtensionSupport");
                stickersExtSupportDestDir.mkdir();
                Files.copy(stickersExtSupportStub.toPath(), new File(stickersExtSupportDestDir, stickersExtSupportStub.getName()).toPath(), StandardCopyOption.COPY_ATTRIBUTES);
            }
        }
        if (this.config.getWatchKitApp() != null) {
            this.config.getLogger().info("Copying support files for WatchKit app extension", new Object[0]);
            File xcodePath = new File(ToolchainUtil.findXcodePath());
            File wk = new File(xcodePath, "Platforms/WatchOS.platform/Developer/SDKs/WatchOS.sdk/Library/Application Support/WatchKit/WK");
            if (!wk.exists()) {
                throw new FileNotFoundException("WatchKitSupport support not found in " + wk.getAbsolutePath());
            }
            File watchKitSupport2 = new File(tmpDir, "WatchKitSupport2");
            watchKitSupport2.mkdir();
            Files.copy(wk.toPath(), new File(watchKitSupport2, wk.getName()).toPath(), StandardCopyOption.COPY_ATTRIBUTES);
        }
        this.config.getLogger().info("Zipping %s to %s", tmpDir, ipaFile);
        new Executor(Logger.NULL_LOGGER, "zip").wd(tmpDir).args("--symlinks", "--recurse-paths", ipaFile, ".").exec();
        this.config.getLogger().info("Deleting temp dir %s", tmpDir);
        FileUtils.deleteDirectory((File)tmpDir);
    }

    @Override
    protected void copyResources(File destDir) throws IOException {
        final ArrayList<File> xcassets = new ArrayList<File>();
        Resource.Walker walker = new Resource.Walker(){

            @Override
            public boolean processDir(Resource resource, File dir, File destDir) throws IOException {
                if (dir.getName().endsWith(".atlas")) {
                    destDir.mkdirs();
                    ToolchainUtil.textureatlas(IOSTarget.this.config, dir, destDir);
                    return false;
                }
                if (dir.getName().endsWith(".xcassets")) {
                    xcassets.add(dir);
                    return false;
                }
                return true;
            }

            @Override
            public void processFile(Resource resource, File file, File destDir) throws IOException {
                if (IOSTarget.isDeviceArch(IOSTarget.this.arch) && !resource.isSkipPngCrush() && file.getName().toLowerCase().endsWith(".png")) {
                    destDir.mkdirs();
                    File outFile = new File(destDir, file.getName());
                    ToolchainUtil.pngcrush(IOSTarget.this.config, file, outFile);
                } else if (file.getName().toLowerCase().endsWith(".strings")) {
                    destDir.mkdirs();
                    File outFile = new File(destDir, file.getName());
                    ToolchainUtil.compileStrings(IOSTarget.this.config, file, outFile);
                } else if (file.getName().toLowerCase().endsWith(".storyboard")) {
                    destDir.mkdirs();
                    ToolchainUtil.ibtool(IOSTarget.this.config, IOSTarget.this.createPartialInfoPlistFile(file), file, destDir);
                } else if (file.getName().toLowerCase().endsWith(".xib")) {
                    destDir.mkdirs();
                    Object fileName = file.getName();
                    fileName = ((String)fileName).substring(0, ((String)fileName).lastIndexOf(46)) + ".nib";
                    File outFile = new File(destDir, (String)fileName);
                    ToolchainUtil.ibtool(IOSTarget.this.config, IOSTarget.this.createPartialInfoPlistFile(file), file, outFile);
                } else {
                    IOSTarget.this.copyFile(resource, file, destDir);
                }
            }
        };
        for (Resource res : this.config.getResources()) {
            res.walk(walker, destDir);
        }
        if (!xcassets.isEmpty()) {
            ToolchainUtil.actool(this.config, this.createPartialInfoPlistFile((File)xcassets.get(0)), this.getAppDir(), xcassets);
        }
    }

    private File createPartialInfoPlistFile(File f) throws IOException {
        File tmpFile = File.createTempFile(f.getName() + "_", ".plist", this.getPartialPListDir());
        tmpFile.delete();
        return tmpFile;
    }

    @Override
    protected File getAppDir() {
        File dir = null;
        if (!this.config.isSkipInstall()) {
            dir = new File(this.config.getInstallDir(), this.getExecutable() + ".app");
            if (!dir.exists()) {
                dir = this.config.getInstallDir();
            }
        } else {
            dir = new File(this.config.getTmpDir(), this.getExecutable() + ".app");
            dir.mkdirs();
        }
        return dir;
    }

    @Override
    protected String getExecutable() {
        String bundleExecutable;
        if (this.config.getIosInfoPList() != null && (bundleExecutable = this.config.getIosInfoPList().getBundleExecutable()) != null) {
            return bundleExecutable;
        }
        return this.config.getExecutableName();
    }

    @Override
    protected String getBundleId() {
        String bundleIdentifier;
        if (this.config.getIosInfoPList() != null && (bundleIdentifier = this.config.getIosInfoPList().getBundleIdentifier()) != null) {
            return bundleIdentifier;
        }
        return this.config.getMainClass() != null ? this.config.getMainClass() : this.config.getExecutableName();
    }

    protected File getDsymDir(File appDir) {
        return new File(appDir.getParentFile(), appDir.getName() + ".dSYM");
    }

    protected String getMinimumOSVersion() {
        String minVersion;
        if (this.config.getIosInfoPList() != null && (minVersion = this.config.getIosInfoPList().getMinimumOSVersion()) != null) {
            return minVersion;
        }
        return this.config.getOs().getMinVersion();
    }

    private void putIfAbsent(NSDictionary dict, String key, String value) {
        if (dict.objectForKey(key) == null) {
            dict.put(key, (Object)value);
        }
    }

    protected void customizeInfoPList(NSDictionary dict) {
        if (IOSTarget.isSimulatorArch(this.arch)) {
            dict.put("CFBundleSupportedPlatforms", (NSObject)new NSArray(new NSObject[]{new NSString("iPhoneSimulator")}));
        } else {
            dict.put("CFBundleSupportedPlatforms", (NSObject)new NSArray(new NSObject[]{new NSString("iPhoneOS")}));
            dict.put("DTPlatformVersion", (Object)this.sdk.getPlatformVersion());
            dict.put("DTPlatformBuild", (Object)this.sdk.getPlatformBuild());
            dict.put("DTSDKBuild", (Object)this.sdk.getBuild());
            try {
                File versionPListFile = new File(new File(ToolchainUtil.findXcodePath()).getParentFile(), "version.plist");
                NSDictionary versionPList = (NSDictionary)PropertyListParser.parse((File)versionPListFile);
                File xcodeInfoPListFile = new File(new File(ToolchainUtil.findXcodePath()).getParentFile(), "Info.plist");
                NSDictionary xcodeInfoPList = (NSDictionary)PropertyListParser.parse((File)xcodeInfoPListFile);
                NSString dtXcodeBuild = (NSString)versionPList.objectForKey("ProductBuildVersion");
                if (dtXcodeBuild == null) {
                    throw new NoSuchElementException("No ProductBuildVersion in " + versionPListFile.getAbsolutePath());
                }
                NSString dtXcode = (NSString)xcodeInfoPList.objectForKey("DTXcode");
                if (dtXcode == null) {
                    throw new NoSuchElementException("No DTXcode in " + xcodeInfoPListFile.getAbsolutePath());
                }
                this.putIfAbsent(dict, "DTXcode", dtXcode.toString());
                this.putIfAbsent(dict, "DTXcodeBuild", dtXcodeBuild.toString());
            }
            catch (Exception e) {
                this.config.getLogger().warn("Failed to read DTXcodeBuild/DTXcode from current Xcode install. Will use fake values. (%s: %s)", e.getClass().getName(), e.getMessage());
            }
            this.putIfAbsent(dict, "DTXcode", "0611");
            this.putIfAbsent(dict, "DTXcodeBuild", "6A2008a");
        }
    }

    protected void createInfoPList(File dir) throws IOException {
        NSDictionary dict = new NSDictionary();
        if (this.config.getIosInfoPList() != null && this.config.getIosInfoPList().getDictionary() != null) {
            NSDictionary infoPListDict = this.config.getIosInfoPList().getDictionary();
            for (String key : infoPListDict.allKeys()) {
                dict.put(key, infoPListDict.objectForKey(key));
            }
        } else {
            dict.put("CFBundleVersion", (Object)"1.0");
            dict.put("CFBundleExecutable", (Object)this.config.getExecutableName());
            dict.put("CFBundleName", (Object)this.config.getExecutableName());
            dict.put("CFBundleIdentifier", (Object)this.getBundleId());
            dict.put("CFBundlePackageType", (Object)"APPL");
            dict.put("LSRequiresIPhoneOS", (Object)true);
            NSObject supportedDeviceFamilies = this.sdk.getDefaultProperty("SUPPORTED_DEVICE_FAMILIES");
            if (supportedDeviceFamilies != null) {
                NSString defFamilies;
                NSArray families = null;
                if (supportedDeviceFamilies instanceof NSString) {
                    defFamilies = (NSString)supportedDeviceFamilies;
                    String[] parts = defFamilies.toString().split(",");
                    families = new NSArray(parts.length);
                    for (int i = 0; i < families.count(); ++i) {
                        families.setValue(i, (Object)new NSNumber(parts[i].trim()));
                    }
                } else {
                    defFamilies = (NSArray)supportedDeviceFamilies;
                    families = new NSArray(defFamilies.count());
                    for (int i = 0; i < families.count(); ++i) {
                        families.setValue(i, (Object)new NSNumber(defFamilies.objectAtIndex(i).toString()));
                    }
                }
                dict.put("UIDeviceFamily", (NSObject)families);
            }
            dict.put("UISupportedInterfaceOrientations", (NSObject)new NSArray(new NSObject[]{new NSString("UIInterfaceOrientationPortrait"), new NSString("UIInterfaceOrientationLandscapeLeft"), new NSString("UIInterfaceOrientationLandscapeRight"), new NSString("UIInterfaceOrientationPortraitUpsideDown")}));
            dict.put("UISupportedInterfaceOrientations~ipad", (NSObject)new NSArray(new NSObject[]{new NSString("UIInterfaceOrientationPortrait"), new NSString("UIInterfaceOrientationLandscapeLeft"), new NSString("UIInterfaceOrientationLandscapeRight"), new NSString("UIInterfaceOrientationPortraitUpsideDown")}));
            dict.put("UIRequiredDeviceCapabilities", (NSObject)new NSArray(new NSObject[]{new NSString("armv7")}));
        }
        dict.put("DTPlatformName", (Object)this.sdk.getPlatformName());
        dict.put("DTSDKName", (Object)this.sdk.getCanonicalName());
        for (String[] f : FileUtils.listFiles((File)this.getPartialPListDir(), (String[])new String[]{"plist"}, (boolean)false)) {
            try {
                NSDictionary d = (NSDictionary)PropertyListParser.parse((File)f);
                dict.putAll((Map)d);
            }
            catch (Exception e) {
                throw new CompilerException(e);
            }
        }
        if (dict.objectForKey("MinimumOSVersion") == null) {
            dict.put("MinimumOSVersion", (Object)this.config.getOs().getMinVersion());
        }
        this.customizeInfoPList(dict);
        NSDictionary newDict = new NSDictionary();
        if (dict.objectForKey("CFBundleShortVersionString") != null) {
            newDict.put("CFBundleShortVersionString", dict.objectForKey("CFBundleShortVersionString"));
            dict.remove("CFBundleShortVersionString");
        }
        if (dict.objectForKey("CFBundleVersion") != null) {
            newDict.put("CFBundleVersion", dict.objectForKey("CFBundleVersion"));
            dict.remove("CFBundleVersion");
        }
        for (String key : dict.allKeys()) {
            newDict.put(key, dict.objectForKey(key));
        }
        File tmpInfoPlist = new File(this.config.getTmpDir(), "Info.plist");
        PropertyListParser.saveAsBinary((NSObject)newDict, (File)tmpInfoPlist);
        this.config.getLogger().info("Installing Info.plist to %s", dir);
        FileUtils.copyFile((File)tmpInfoPlist, (File)new File(dir, tmpInfoPlist.getName()));
    }

    @Override
    public void init(Config config) {
        super.init(config);
        if (config.getArch() == null) {
            this.arch = new Arch(CpuArch.arm64, Environment.Native);
        } else {
            if (!IOSTarget.isSimulatorArch(config.getArch()) && !IOSTarget.isDeviceArch(config.getArch())) {
                throw new IllegalArgumentException("Arch '" + config.getArch() + "' is unsupported for iOS target");
            }
            this.arch = config.getArch();
        }
        if (config.getIosInfoPList() != null) {
            config.getIosInfoPList().parse(config.getProperties());
        }
        if (IOSTarget.isDeviceArch(this.arch) && !config.isSkipLinking() && !config.isIosSkipSigning()) {
            this.signIdentity = config.getIosSignIdentity();
            this.provisioningProfile = config.getIosProvisioningProfile();
            String bundleId = "*";
            if (config.getIosInfoPList() != null && config.getIosInfoPList().getBundleIdentifier() != null) {
                bundleId = config.getIosInfoPList().getBundleIdentifier();
            }
            if (this.signIdentity == null && this.provisioningProfile == null) {
                Pair<SigningIdentity, ProvisioningProfile> pair = ProvisioningProfile.find(ProvisioningProfile.list(), SigningIdentity.list("/(?i)iPhone Developer|iOS Development|Apple Development/"), bundleId);
                this.signIdentity = (SigningIdentity)pair.getLeft();
                this.provisioningProfile = (ProvisioningProfile)pair.getRight();
            } else if (this.signIdentity == null) {
                this.signIdentity = SigningIdentity.find(SigningIdentity.list(), "/(?i)iPhone Developer|iOS Development|Apple Development/", this.provisioningProfile);
            } else if (this.provisioningProfile == null) {
                this.provisioningProfile = ProvisioningProfile.find(ProvisioningProfile.list(), this.signIdentity, bundleId);
            }
        }
        String sdkVersion = config.getIosSdkVersion();
        List<SDK> sdks = this.getSDKs();
        if (sdkVersion == null) {
            if (sdks.isEmpty()) {
                throw new IllegalArgumentException("No " + (IOSTarget.isDeviceArch(this.arch) ? "device" : "simulator") + " SDKs installed");
            }
            Collections.sort(sdks);
            this.sdk = sdks.get(sdks.size() - 1);
        } else {
            for (SDK sdk : sdks) {
                if (!sdk.getVersion().equals(sdkVersion)) continue;
                this.sdk = sdk;
                break;
            }
            if (this.sdk == null) {
                throw new IllegalArgumentException("No SDK found matching version string " + sdkVersion);
            }
        }
        this.entitlementsPList = config.getIosEntitlementsPList();
        this.partialPListDir = new File(config.getTmpDir(), "partial-plists");
        try {
            if (this.partialPListDir.exists()) {
                FileUtils.cleanDirectory((File)this.partialPListDir);
            }
        }
        catch (IOException e) {
            throw new CompilerException(e);
        }
    }

    @Override
    public OS getOs() {
        return OS.ios;
    }

    @Override
    public boolean canLaunchInPlace() {
        return false;
    }

    private void copyToIndexedDir(File dir, String executable, File dsymDir, File exePath) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        File indexedDir = new File(System.getProperty("user.home"), "Library/Developer/Xcode/DerivedData/RoboVM/Build/Products/" + FilenameUtils.removeExtension((String)dir.getName()) + "_" + sdf.format(new Date()));
        indexedDir.mkdirs();
        File indexedDSymDir = new File(indexedDir, dsymDir.getName());
        File indexedAppDir = new File(indexedDir, dir.getName());
        indexedAppDir.mkdirs();
        try {
            FileUtils.copyFile((File)exePath, (File)new File(indexedAppDir, executable));
        }
        catch (IOException e) {
            this.config.getLogger().error("Failed to copy %s to indexed dir %s: %s", exePath.getAbsolutePath(), indexedAppDir.getAbsolutePath(), e.getMessage());
        }
        try {
            FileUtils.copyDirectory((File)dsymDir, (File)indexedDSymDir);
        }
        catch (IOException e) {
            this.config.getLogger().error("Failed to copy %s to indexed dir %s: %s", dsymDir.getAbsolutePath(), indexedDir.getAbsolutePath(), e.getMessage());
        }
        ArrayList<File> dirs = new ArrayList<File>(Arrays.asList(indexedDir.getParentFile().listFiles((FileFilter)new AndFileFilter((IOFileFilter)new PrefixFileFilter(FilenameUtils.removeExtension((String)dir.getName())), (IOFileFilter)new RegexFileFilter(".*_\\d{14}")))));
        Collections.sort(dirs, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return Long.compare(o1.lastModified(), o2.lastModified());
            }
        });
        if (dirs.size() > 3) {
            for (File f : dirs.subList(0, dirs.size() - 3)) {
                try {
                    FileUtils.deleteDirectory((File)f);
                }
                catch (IOException e) {
                    this.config.getLogger().error("Failed to delete diretcory %s", f.getAbsolutePath(), e.getMessage());
                }
            }
        }
    }
}

