/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.log;

import java.io.IOException;
import java.io.OutputStream;
import org.robovm.compiler.log.Logger;

public abstract class LoggerOutputStream
extends OutputStream {
    protected final Logger logger;
    private byte[] buffer = new byte[1024];
    private int start = 0;
    private int end = 0;

    public LoggerOutputStream(Logger logger) {
        this.logger = logger;
    }

    protected abstract void log(byte[] var1, int var2, int var3);

    @Override
    public void close() throws IOException {
        if (this.start < this.end) {
            this.log(this.buffer, this.start, this.end - this.start);
        }
        super.close();
    }

    @Override
    public void write(int b) throws IOException {
        if (b == 13) {
            return;
        }
        if (b == 10) {
            this.log(this.buffer, this.start, this.end - this.start);
            this.end = 0;
            this.start = 0;
            return;
        }
        if (this.end == this.buffer.length) {
            if (this.start > 0) {
                System.arraycopy(this.buffer, this.start, this.buffer, 0, this.end - this.start);
                this.end -= this.start;
                this.start = 0;
            } else {
                byte[] newBuffer = new byte[this.buffer.length * 2];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                this.buffer = newBuffer;
            }
        }
        this.buffer[this.end++] = (byte)b;
    }
}

