/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.Writer;
import org.robovm.compiler.llvm.Metadata;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.UnnamedMetadataRef;
import org.robovm.compiler.llvm.Writable;

public class UnnamedMetadata
implements Writable {
    private final int index;
    private Metadata value;

    public UnnamedMetadata(int index) {
        this.index = index;
    }

    public UnnamedMetadata(int index, Metadata value) {
        this.index = index;
        this.value = value;
    }

    public void setValue(Metadata value) {
        this.value = value;
    }

    public UnnamedMetadataRef ref() {
        return new UnnamedMetadataRef(this);
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return "!" + this.index;
    }

    public void writeDefinition(Writer writer) throws IOException {
        writer.write(33);
        writer.write(Integer.toString(this.index));
        writer.write(" = ");
        if (this.value.getType() != Type.METADATA) {
            this.value.getType().write(writer);
            writer.write(32);
        }
        this.value.write(writer);
    }

    public String getDefinition() {
        return this.toString(this::writeDefinition);
    }

    @Override
    public void write(Writer writer) throws IOException {
        throw new IllegalStateException("Use writeDefinition!");
    }
}

