/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.robovm.compiler.llvm.BasicBlock;
import org.robovm.compiler.llvm.Instruction;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Variable;
import org.robovm.compiler.llvm.VariableRef;

public class Phi
extends Instruction {
    private final Variable result;
    private final VariableRef[] vars;

    public Phi(Variable result, VariableRef ... vars) {
        if (vars.length < 2) {
            throw new IllegalArgumentException("At least two variables expected");
        }
        Type t = result.getType();
        for (int i = 0; i < vars.length; ++i) {
            if (vars[i].getType().equals(t)) continue;
            throw new IllegalArgumentException("Type mismatch in variable " + vars[i]);
        }
        this.result = result;
        this.vars = vars;
    }

    @Override
    public Set<Variable> getWritesTo() {
        return Collections.singleton(this.result);
    }

    @Override
    public Set<VariableRef> getReadsFrom() {
        return new HashSet<VariableRef>(Arrays.asList(this.vars));
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write(this.result.toString());
        writer.write(" = phi ");
        this.result.getType().write(writer);
        for (int i = 0; i < this.vars.length; ++i) {
            if (i > 0) {
                writer.write(", ");
            }
            writer.write("[ ");
            writer.write(this.vars[i].toString());
            writer.write(", ");
            BasicBlock bb = this.basicBlock.getFunction().getDefinedIn(this.vars[i]);
            writer.write(37);
            writer.write(bb.getName());
            writer.write(" ]");
        }
    }

    public String toString() {
        return this.toString(this::write);
    }
}

