/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.robovm.compiler.llvm.Metadata;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Value;

public class MetadataNode
extends Metadata {
    private final Value[] values;

    public MetadataNode(Value ... values) {
        this.values = values;
    }

    public MetadataNode(List<? extends Value> values) {
        this.values = values.toArray(new Value[values.size()]);
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write("!{");
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                writer.write(", ");
            }
            if (this.values[i] == null) {
                writer.write("null");
                continue;
            }
            if (this.values[i].getType() != Type.METADATA) {
                this.values[i].getType().write(writer);
                writer.write(32);
            }
            this.values[i].write(writer);
        }
        writer.write(125);
    }

    public String toString() {
        return this.toString(this::write);
    }
}

