/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.Writer;
import org.robovm.compiler.llvm.BinaryOpConstant;
import org.robovm.compiler.llvm.Constant;
import org.robovm.compiler.llvm.Type;

public abstract class IntegerBinaryConstant
extends BinaryOpConstant {
    private final String name;

    protected IntegerBinaryConstant(String name, Constant op1, Constant op2) {
        super(op1, op2);
        if (!op1.isInteger() || !op2.isInteger()) {
            throw new IllegalArgumentException("Integer type expected");
        }
        if (!op1.getType().equals(op2.getType())) {
            throw new IllegalArgumentException("Type mismatch ");
        }
        this.name = name;
    }

    @Override
    public Type getType() {
        return this.op1.getType();
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write(this.name);
        writer.write(" (");
        this.op1.getType().write(writer);
        writer.write(32);
        this.op1.write(writer);
        writer.write(", ");
        this.op2.getType().write(writer);
        writer.write(32);
        this.op2.write(writer);
        writer.write(41);
    }

    public String toString() {
        return this.toString(this::write);
    }
}

