/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.Writer;
import org.robovm.compiler.llvm.AggregateType;
import org.robovm.compiler.llvm.Constant;
import org.robovm.compiler.llvm.PointerType;
import org.robovm.compiler.llvm.Type;

public class ConstantGetelementptr
extends Constant {
    private final Constant cst;
    private final int[] idx;

    public ConstantGetelementptr(Constant cst, int ... idx) {
        if (!cst.isPointer()) {
            throw new IllegalArgumentException("PointerType expected");
        }
        if (!(((PointerType)cst.getType()).getBase() instanceof AggregateType)) {
            throw new IllegalArgumentException("PointerType should point to AggregateType");
        }
        if (idx == null || idx.length == 0) {
            throw new IllegalArgumentException("No indexes");
        }
        this.cst = cst;
        this.idx = idx;
    }

    @Override
    public Type getType() {
        Type t = (AggregateType)((PointerType)this.cst.getType()).getBase();
        for (int i = 1; i < this.idx.length; ++i) {
            t = t.getTypeAt(this.idx[i]);
        }
        return new PointerType(t);
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write("getelementptr (");
        this.cst.getType().write(writer);
        writer.write(32);
        this.cst.write(writer);
        for (int j : this.idx) {
            writer.write(", i32 ");
            writer.write(Integer.toString(j));
        }
        writer.write(41);
    }

    public String toString() {
        return this.toString(this::write);
    }
}

