/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.Writer;
import org.robovm.compiler.llvm.ArrayType;
import org.robovm.compiler.llvm.Constant;
import org.robovm.compiler.llvm.Type;

public class ByteArrayConstant
extends Constant {
    private final ArrayType type;
    private final byte[] values;

    public ByteArrayConstant(byte ... values) {
        this.type = new ArrayType(values.length, Type.I8);
        this.values = values;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write(91);
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                writer.write(", ");
            }
            writer.write("i8 ");
            writer.write(Byte.toString(this.values[i]));
        }
        writer.write(93);
    }

    public String toString() {
        return this.toString(this::write);
    }
}

