/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.robovm.compiler.llvm.BasicBlockRef;
import org.robovm.compiler.llvm.Instruction;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.VariableRef;

public class Br
extends Instruction {
    private final Value cond;
    private final BasicBlockRef destTrue;
    private final BasicBlockRef destFalse;

    public Br(BasicBlockRef dest) {
        this.cond = null;
        this.destTrue = dest;
        this.destFalse = null;
    }

    public Br(Value cond, BasicBlockRef destTrue, BasicBlockRef destFalse) {
        if (cond.getType() != Type.I1) {
            throw new IllegalArgumentException("Condition must have type " + Type.I1);
        }
        this.cond = cond;
        this.destTrue = destTrue;
        this.destFalse = destFalse;
    }

    @Override
    public Set<VariableRef> getReadsFrom() {
        if (this.cond instanceof VariableRef) {
            return Collections.singleton((VariableRef)this.cond);
        }
        return super.getReadsFrom();
    }

    @Override
    public Set<BasicBlockRef> getBranchTargets() {
        HashSet<BasicBlockRef> result = new HashSet<BasicBlockRef>();
        result.add(this.destTrue);
        if (this.cond != null) {
            result.add(this.destFalse);
        }
        return result;
    }

    @Override
    public void write(Writer writer) throws IOException {
        if (this.cond != null) {
            writer.write("br i1 ");
            this.cond.write(writer);
            writer.append(", label %").append(this.destTrue.getName()).append(", label %").append(this.destFalse.getName());
        } else {
            writer.append("br label %").append(this.destTrue.getName());
        }
    }

    public String toString() {
        return this.toString(this::write);
    }
}

