/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.Writer;
import org.robovm.compiler.llvm.AggregateType;
import org.robovm.compiler.llvm.Type;

public class ArrayType
extends AggregateType {
    private final long size;
    private final Type elementType;

    public ArrayType(long size, Type elementType) {
        this.size = size;
        this.elementType = elementType;
    }

    public ArrayType(String alias, long size, Type elementType) {
        super(alias);
        this.size = size;
        this.elementType = elementType;
    }

    public Type getElementType() {
        return this.elementType;
    }

    public long getSize() {
        return this.size;
    }

    @Override
    public Type getTypeAt(int index) {
        return this.elementType;
    }

    @Override
    public int getTypeCount() {
        return (int)this.size;
    }

    @Override
    public void writeDefinition(Writer writer) throws IOException {
        writer.append('[').append(Long.toString(this.size)).append(" x ");
        this.elementType.write(writer);
        writer.write("]");
    }

    @Override
    public String getDefinition() {
        return this.toString(this::writeDefinition);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.elementType == null ? 0 : this.elementType.hashCode());
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayType other = (ArrayType)obj;
        if (this.elementType == null ? other.elementType != null : !this.elementType.equals(other.elementType)) {
            return false;
        }
        return this.size == other.size;
    }
}

