/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.Writer;
import org.robovm.compiler.llvm.AliasRef;
import org.robovm.compiler.llvm.Constant;
import org.robovm.compiler.llvm.Linkage;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Writable;

public class Alias
implements Writable {
    private final String name;
    private final Linkage linkage;
    private final Constant value;

    public Alias(String name, Constant aliasee) {
        this(name, null, aliasee);
    }

    public Alias(String name, Linkage linkage, Constant aliasee) {
        this.name = name;
        this.linkage = linkage;
        this.value = aliasee;
    }

    public AliasRef ref() {
        return new AliasRef(this);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.value.getType();
    }

    public void writeDefinition(Writer writer) throws IOException {
        writer.write("@\"");
        writer.write(this.name);
        writer.write("\" = ");
        if (this.linkage != null) {
            writer.write(this.linkage.toString());
            writer.write(32);
        }
        writer.write("alias ");
        this.value.getType().write(writer);
        writer.write(32);
        this.value.write(writer);
    }

    public String getDefinition() {
        return this.toString(this::writeDefinition);
    }

    @Override
    public void write(Writer writer) throws IOException {
        throw new IllegalStateException("writeDefinition to be used");
    }

    public String toString() {
        return this.name;
    }
}

