/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.config.Qualified;
import org.robovm.compiler.util.XCFrameworkPlist;

final class ResolvedLocations {
    final List<File> frameworkPaths;
    final List<Config.Lib> libs;
    final List<String> frameworks;
    final List<String> weakFrameworks;

    private ResolvedLocations(List<File> frameworkPaths, List<Config.Lib> libs, List<String> frameworks, List<String> weakFrameworks) {
        this.frameworkPaths = frameworkPaths;
        this.libs = libs;
        this.frameworks = frameworks;
        this.weakFrameworks = weakFrameworks;
    }

    static class Resolver {
        private final OS os;
        private final Arch arch;
        private List<Config.QualifiedFile> frameworkPaths;
        private List<Config.Lib> libs;
        private List<Config.QualifiedEntry> frameworks;
        private List<Config.QualifiedEntry> weakFrameworks;
        private Predicate<Qualified> qualifier = v -> true;
        private boolean xcFrameworkLookup;
        private List<Config.QualifiedFile> xcFrameworks;
        final List<String> resolvedFrameworks = new ArrayList<String>();
        final List<String> resolvedWeakFrameworks = new ArrayList<String>();
        final List<File> resolvedFrameworkPaths = new ArrayList<File>();
        final List<Config.Lib> resolvedLibs = new ArrayList<Config.Lib>();

        Resolver(OS os, Arch arch) {
            this.os = os;
            this.arch = arch;
        }

        Resolver setLibs(List<Config.Lib> libs) {
            this.libs = libs;
            return this;
        }

        Resolver setFrameworkPaths(List<Config.QualifiedFile> frameworkPaths) {
            this.frameworkPaths = frameworkPaths;
            return this;
        }

        Resolver setFrameworks(List<Config.QualifiedEntry> frameworks) {
            this.frameworks = frameworks;
            return this;
        }

        Resolver setWeakFrameworks(List<Config.QualifiedEntry> weakFrameworks) {
            this.weakFrameworks = weakFrameworks;
            return this;
        }

        Resolver setQualifier(Predicate<Qualified> qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        Resolver setXcFrameworkLookup(boolean xcFrameworkLookup) {
            this.xcFrameworkLookup = xcFrameworkLookup;
            return this;
        }

        Resolver setXcFrameworks(List<Config.QualifiedFile> xcFrameworks) {
            this.xcFrameworks = xcFrameworks;
            return this;
        }

        ResolvedLocations resolve() {
            this.applyQualifiers();
            if (this.xcFrameworkLookup && this.frameworks != null && !this.frameworks.isEmpty() && this.frameworkPaths != null && !this.frameworkPaths.isEmpty()) {
                this.performLookup();
            }
            if (this.xcFrameworks != null && !this.xcFrameworks.isEmpty()) {
                this.handleXCFrameworks();
            }
            return new ResolvedLocations(this.resolvedFrameworkPaths.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(this.resolvedFrameworkPaths), this.resolvedLibs.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(this.resolvedLibs), this.resolvedFrameworks.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(this.resolvedFrameworks), this.resolvedWeakFrameworks.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(this.resolvedWeakFrameworks));
        }

        private void applyQualifiers() {
            if (this.frameworks != null && !this.frameworks.isEmpty()) {
                this.resolvedFrameworks.addAll(this.frameworks.stream().filter(this.qualifier).map(f -> f.entry).collect(Collectors.toList()));
            }
            if (this.weakFrameworks != null && !this.weakFrameworks.isEmpty()) {
                this.resolvedWeakFrameworks.addAll(this.weakFrameworks.stream().filter(this.qualifier).map(f -> f.entry).collect(Collectors.toList()));
            }
            if (this.frameworkPaths != null && !this.frameworkPaths.isEmpty()) {
                this.resolvedFrameworkPaths.addAll(this.frameworkPaths.stream().filter(this.qualifier).map(f -> f.entry).collect(Collectors.toList()));
            }
            if (this.libs != null && !this.libs.isEmpty()) {
                this.resolvedLibs.addAll(this.libs.stream().filter(this.qualifier).collect(Collectors.toList()));
            }
        }

        private void performLookup() {
            List frameworkPathChains = this.resolvedFrameworkPaths.stream().map(f -> new ArrayList<File>(){
                {
                    this.add(f);
                }
            }).collect(Collectors.toList());
            ArrayList<String> frameworkNames = new ArrayList<String>(this.resolvedFrameworks);
            this.resolvedFrameworks.clear();
            for (String frameworkName : frameworkNames) {
                List pathChain;
                File path;
                File guess;
                boolean xcFrameworkFound = false;
                Iterator iterator = frameworkPathChains.iterator();
                while (iterator.hasNext() && !(guess = new File(path = (File)(pathChain = (List)iterator.next()).get(0), frameworkName + ".framework")).isDirectory()) {
                    guess = new File(path, frameworkName + ".xcframework");
                    if (!guess.isDirectory()) continue;
                    this.processXCFramework(guess, pathChain, this.resolvedFrameworks, this.resolvedLibs);
                    xcFrameworkFound = true;
                    break;
                }
                if (xcFrameworkFound) continue;
                this.resolvedFrameworks.add(frameworkName);
            }
            this.resolvedFrameworkPaths.clear();
            this.resolvedFrameworkPaths.addAll(frameworkPathChains.stream().flatMap(Collection::stream).collect(Collectors.toList()));
        }

        private void handleXCFrameworks() {
            List xcFrameworkLocations = this.xcFrameworks.stream().filter(this.qualifier).map(f -> f.entry).collect(Collectors.toList());
            for (File xcFrameworkLocation : xcFrameworkLocations) {
                this.processXCFramework(xcFrameworkLocation, this.resolvedFrameworkPaths, this.resolvedFrameworks, this.resolvedLibs);
            }
        }

        private void processXCFramework(File xcFrameworkLocation, List<File> destLocations, List<String> destFrameworks, List<Config.Lib> destLibs) {
            block6: {
                try {
                    String frameworkName = xcFrameworkLocation.getName();
                    XCFrameworkPlist plist = XCFrameworkPlist.load(xcFrameworkLocation);
                    Predicate<XCFrameworkPlist.Library> acceptedLibsPredicate = l -> l.getPlatform() == this.os && l.supportCpuArch(this.arch.getCpuArch()) && l.getVariant() == this.arch.getEnv();
                    List matchingLibs = Arrays.stream(plist.getAvailableLibraries()).filter(acceptedLibsPredicate).collect(Collectors.toList());
                    if (matchingLibs.size() == 1) {
                        XCFrameworkPlist.Library library = (XCFrameworkPlist.Library)matchingLibs.get(0);
                        String libPath = library.getPath();
                        if (libPath.endsWith(".framework")) {
                            File p = new File(xcFrameworkLocation, library.getIdentifier());
                            destLocations.add(p);
                            destFrameworks.add(libPath.substring(0, libPath.length() - ".framework".length()));
                            break block6;
                        }
                        if (libPath.endsWith(".a")) {
                            File staticLibFile = new File(new File(xcFrameworkLocation, library.getIdentifier()), libPath);
                            destLibs.add(new Config.Lib(staticLibFile.getAbsolutePath(), false));
                            break block6;
                        }
                        String message = String.format("Unsupported library type %s matched %s %s, in '%s'", new Object[]{libPath, this.os, this.arch.getEnv().getLlvmName(), frameworkName});
                        throw new IllegalArgumentException(message);
                    }
                    if (matchingLibs.isEmpty()) {
                        String message = String.format("While building for %s %s, no library for this platform was found in '%s'", new Object[]{this.os, this.arch, frameworkName});
                        throw new IllegalArgumentException(message);
                    }
                    String message = String.format("Multiple libraries were found matching %s %s in '%s'", new Object[]{this.os, this.arch, frameworkName});
                    throw new IllegalArgumentException(message);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to handle xcframework " + xcFrameworkLocation.getAbsolutePath(), e);
                }
            }
        }
    }
}

