/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.util.ArrayList;

public class Strings {
    public static String getStringVarName(byte[] bytes) {
        StringBuilder sb = new StringBuilder("str_");
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57) {
                sb.append((char)b);
                continue;
            }
            sb.append(String.format("_%02X", b));
        }
        return sb.toString();
    }

    public static byte[] stringToModifiedUtf8(String unicode) {
        return Strings.stringToModifiedUtf8(unicode, false);
    }

    public static byte[] stringToModifiedUtf8Z(String unicode) {
        return Strings.stringToModifiedUtf8(unicode, true);
    }

    private static byte[] stringToModifiedUtf8(String unicode, boolean zeroTerminate) {
        ArrayList<Byte> s = new ArrayList<Byte>();
        for (int i = 0; i < unicode.length(); ++i) {
            int b5_0;
            char ch = unicode.charAt(i);
            if (ch == '\u0000') {
                s.add((byte)-64);
                s.add((byte)-128);
                continue;
            }
            if (ch < '\u0080') {
                s.add((byte)ch);
                continue;
            }
            if (ch < '\u0800') {
                b5_0 = ch & 0x3F;
                int b10_6 = ch >> 6 & 0x1F;
                s.add((byte)(0xC0 | b10_6));
                s.add((byte)(0x80 | b5_0));
                continue;
            }
            b5_0 = ch & 0x3F;
            int b11_6 = ch >> 6 & 0x3F;
            int b15_12 = ch >> 12 & 0xF;
            s.add((byte)(0xE0 | b15_12));
            s.add((byte)(0x80 | b11_6));
            s.add((byte)(0x80 | b5_0));
        }
        if (zeroTerminate) {
            s.add((byte)0);
        }
        byte[] result = new byte[s.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Byte)s.get(i);
        }
        return result;
    }
}

