/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import org.robovm.compiler.AbstractMethodCompiler;
import org.robovm.compiler.FunctionBuilder;
import org.robovm.compiler.Functions;
import org.robovm.compiler.Mangler;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.Symbols;
import org.robovm.compiler.Types;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.llvm.Bitcast;
import org.robovm.compiler.llvm.Br;
import org.robovm.compiler.llvm.FloatingPointConstant;
import org.robovm.compiler.llvm.FloatingPointType;
import org.robovm.compiler.llvm.Function;
import org.robovm.compiler.llvm.FunctionRef;
import org.robovm.compiler.llvm.FunctionType;
import org.robovm.compiler.llvm.Global;
import org.robovm.compiler.llvm.Icmp;
import org.robovm.compiler.llvm.IntegerConstant;
import org.robovm.compiler.llvm.IntegerType;
import org.robovm.compiler.llvm.Label;
import org.robovm.compiler.llvm.Linkage;
import org.robovm.compiler.llvm.NullConstant;
import org.robovm.compiler.llvm.PointerType;
import org.robovm.compiler.llvm.Ret;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;
import org.robovm.compiler.llvm.VariableRef;
import soot.SootMethod;

public class NativeMethodCompiler
extends AbstractMethodCompiler {
    public NativeMethodCompiler(Config config) {
        super(config);
    }

    @Override
    protected Function doCompile(ModuleBuilder moduleBuilder, SootMethod method) {
        Function fn = this.createMethodFunction(method);
        moduleBuilder.addFunction(fn);
        VariableRef env = fn.getParameterRef(0);
        ArrayList<Value> args = new ArrayList<Value>(Arrays.asList(fn.getParameterRefs()));
        if (method.isStatic()) {
            FunctionRef ldcFn = FunctionBuilder.ldcInternal(this.sootMethod.getDeclaringClass()).ref();
            Value clazz = Functions.call(fn, (Value)ldcFn, env);
            args.add(1, clazz);
        }
        Functions.pushNativeFrame(fn);
        FunctionRef targetFn = this.createNative(moduleBuilder, method);
        Value result = Functions.call(fn, (Value)targetFn, args);
        Functions.popNativeFrame(fn);
        Functions.call(fn, (Value)Functions.BC_THROW_IF_EXCEPTION_OCCURRED, env);
        fn.add(new Ret(result));
        return fn;
    }

    private boolean isLongNativeFunctionNameRequired(SootMethod method) {
        int nativeCount = 0;
        for (SootMethod m : this.sootClass.getMethods()) {
            if (!m.isNative() || !m.getName().equals(method.getName())) continue;
            ++nativeCount;
        }
        return nativeCount > 1;
    }

    private FunctionRef createNative(ModuleBuilder mb, SootMethod method) {
        String targetInternalName = Types.getInternalName(method.getDeclaringClass());
        String methodName = method.getName();
        String methodDesc = Types.getDescriptor(method);
        FunctionType nativeFunctionType = Types.getNativeFunctionType(methodDesc, method.isStatic());
        String shortName = Mangler.mangleNativeMethod(targetInternalName, methodName);
        String longName = Mangler.mangleNativeMethod(targetInternalName, methodName, methodDesc);
        Function fn = new FunctionBuilder(longName, nativeFunctionType).linkage(Linkage.weak).build();
        Global g = new Global(Symbols.nativeMethodPtrSymbol(targetInternalName, methodName, methodDesc), new NullConstant(Type.I8_PTR));
        mb.addGlobal(g);
        FunctionRef ldcFn = FunctionBuilder.ldcInternal(targetInternalName).ref();
        Value theClass = Functions.call(fn, (Value)ldcFn, fn.getParameterRef(0));
        Value implI8Ptr = Functions.call(fn, (Value)Functions.BC_RESOLVE_NATIVE, fn.getParameterRef(0), theClass, mb.getString(methodName), mb.getString(methodDesc), mb.getString(shortName), mb.getString(longName), g.ref());
        Variable nullTest = fn.newVariable(Type.I1);
        fn.add(new Icmp(nullTest, Icmp.Condition.ne, implI8Ptr, new NullConstant(Type.I8_PTR)));
        Label trueLabel = new Label();
        Label falseLabel = new Label();
        fn.add(new Br(nullTest.ref(), fn.newBasicBlockRef(trueLabel), fn.newBasicBlockRef(falseLabel)));
        fn.newBasicBlock(falseLabel);
        if (fn.getType().getReturnType() instanceof IntegerType) {
            fn.add(new Ret(new IntegerConstant(0L, (IntegerType)fn.getType().getReturnType())));
        } else if (fn.getType().getReturnType() instanceof FloatingPointType) {
            fn.add(new Ret(new FloatingPointConstant(0.0, (FloatingPointType)fn.getType().getReturnType())));
        } else if (fn.getType().getReturnType() instanceof PointerType) {
            fn.add(new Ret(new NullConstant((PointerType)fn.getType().getReturnType())));
        } else {
            fn.add(new Ret());
        }
        fn.newBasicBlock(trueLabel);
        Variable impl = fn.newVariable(nativeFunctionType);
        fn.add(new Bitcast(impl, implI8Ptr, impl.getType()));
        Value result = Functions.call(fn, (Value)impl.ref(), fn.getParameterRefs());
        fn.add(new Ret(result));
        mb.addFunction(fn);
        FunctionRef targetFn = fn.ref();
        if (!this.isLongNativeFunctionNameRequired(method)) {
            Function fnShort = new FunctionBuilder(shortName, nativeFunctionType).linkage(Linkage.weak).build();
            Value resultInner = Functions.call(fnShort, (Value)fn.ref(), fnShort.getParameterRefs());
            fnShort.add(new Ret(resultInner));
            mb.addFunction(fnShort);
            targetFn = fnShort.ref();
        }
        return targetFn;
    }
}

