/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.Symbols;
import org.robovm.compiler.Types;
import org.robovm.compiler.llvm.ArrayConstant;
import org.robovm.compiler.llvm.ArrayType;
import org.robovm.compiler.llvm.Constant;
import org.robovm.compiler.llvm.FloatingPointConstant;
import org.robovm.compiler.llvm.Global;
import org.robovm.compiler.llvm.IntegerConstant;
import org.robovm.compiler.llvm.Linkage;
import org.robovm.compiler.llvm.StructureConstant;
import org.robovm.compiler.llvm.StructureType;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Value;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.tagkit.AnnotationAnnotationElem;
import soot.tagkit.AnnotationArrayElem;
import soot.tagkit.AnnotationClassElem;
import soot.tagkit.AnnotationDefaultTag;
import soot.tagkit.AnnotationDoubleElem;
import soot.tagkit.AnnotationElem;
import soot.tagkit.AnnotationEnumElem;
import soot.tagkit.AnnotationFloatElem;
import soot.tagkit.AnnotationIntElem;
import soot.tagkit.AnnotationLongElem;
import soot.tagkit.AnnotationStringElem;
import soot.tagkit.AnnotationTag;
import soot.tagkit.EnclosingMethodTag;
import soot.tagkit.Host;
import soot.tagkit.InnerClassTag;
import soot.tagkit.SignatureTag;
import soot.tagkit.SourceFileTag;
import soot.tagkit.Tag;
import soot.tagkit.VisibilityAnnotationTag;
import soot.tagkit.VisibilityParameterAnnotationTag;

public class AttributesEncoder {
    private static final byte SOURCE_FILE = 1;
    private static final byte SIGNATURE = 2;
    private static final byte INNER_CLASS = 3;
    private static final byte ENCLOSING_METHOD = 4;
    private static final byte EXCEPTIONS = 5;
    private static final byte RUNTIME_VISIBLE_ANNOTATIONS = 6;
    private static final byte RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS = 7;
    private static final byte ANNOTATION_DEFAULT = 8;
    private ModuleBuilder mb;
    private Set<String> dependencies;
    private Global classAttributes;
    private Map<SootField, Global> fieldAttributes;
    private Map<SootMethod, Global> methodAttributes;

    public void encode(ModuleBuilder mb, SootClass sootClass) {
        Global g;
        this.mb = mb;
        this.dependencies = new HashSet<String>();
        this.classAttributes = null;
        this.fieldAttributes = new HashMap<SootField, Global>();
        this.methodAttributes = new HashMap<SootMethod, Global>();
        this.encodeAttributes((Host)sootClass);
        Constant classAttributes = this.encodeAttributes((Host)sootClass);
        if (classAttributes != null) {
            Global g2 = new Global(Symbols.classAttributesSymbol(sootClass), Linkage._private, classAttributes, true);
            mb.addGlobal(g2);
            this.classAttributes = g2;
        }
        for (SootField field : sootClass.getFields()) {
            Constant fieldAttributes = this.encodeAttributes((Host)field);
            if (fieldAttributes == null) continue;
            g = new Global(Symbols.fieldAttributesSymbol(field), Linkage._private, fieldAttributes, true);
            mb.addGlobal(g);
            this.fieldAttributes.put(field, g);
        }
        for (SootMethod method : sootClass.getMethods()) {
            Constant methodAttributes = this.encodeAttributes((Host)method);
            if (methodAttributes == null) continue;
            g = new Global(Symbols.methodAttributesSymbol(method), Linkage._private, methodAttributes, true);
            mb.addGlobal(g);
            this.methodAttributes.put(method, g);
        }
    }

    public Set<String> getDependencies() {
        return this.dependencies;
    }

    public boolean classHasAttributes() {
        return this.classAttributes != null;
    }

    public Global getClassAttributes() {
        return this.classAttributes;
    }

    public boolean fieldHasAttributes(SootField f) {
        return this.fieldAttributes.containsKey(f);
    }

    public Global getFieldAttributes(SootField f) {
        return this.fieldAttributes.get(f);
    }

    public boolean methodHasAttributes(SootMethod m) {
        return this.methodAttributes.containsKey(m);
    }

    public Global getMethodAttributes(SootMethod m) {
        return this.methodAttributes.get(m);
    }

    private StructureType getAnnotationElementType(AnnotationElem ae) {
        if (ae instanceof AnnotationIntElem) {
            return new StructureType(Type.I8, Type.I32);
        }
        if (ae instanceof AnnotationLongElem) {
            return new StructureType(Type.I8, Type.I64);
        }
        if (ae instanceof AnnotationFloatElem) {
            return new StructureType(Type.I8, Type.FLOAT);
        }
        if (ae instanceof AnnotationDoubleElem) {
            return new StructureType(Type.I8, Type.DOUBLE);
        }
        if (ae instanceof AnnotationStringElem) {
            return new StructureType(Type.I8, Type.I8_PTR);
        }
        if (ae instanceof AnnotationClassElem) {
            return new StructureType(Type.I8, Type.I8_PTR);
        }
        if (ae instanceof AnnotationEnumElem) {
            return new StructureType(Type.I8, Type.I8_PTR, Type.I8_PTR);
        }
        if (ae instanceof AnnotationArrayElem) {
            AnnotationArrayElem aae = (AnnotationArrayElem)ae;
            Type[] types = new Type[aae.getNumValues() + 2];
            types[0] = Type.I8;
            types[1] = Type.I16;
            for (int i = 0; i < aae.getNumValues(); ++i) {
                types[i + 2] = this.getAnnotationElementType(aae.getValueAt(i));
            }
            return new StructureType(types);
        }
        if (ae instanceof AnnotationAnnotationElem) {
            AnnotationAnnotationElem aae = (AnnotationAnnotationElem)ae;
            return new StructureType(Type.I8, this.getAnnotationTagType(aae.getValue()));
        }
        throw new IllegalArgumentException("Unknown AnnotationElem type: " + ae.getClass());
    }

    private StructureConstant encodeAnnotationElementValue(AnnotationElem ae) {
        StructureType type = this.getAnnotationElementType(ae);
        IntegerConstant kind = new IntegerConstant((byte)ae.getKind());
        if (ae instanceof AnnotationIntElem) {
            AnnotationIntElem aie = (AnnotationIntElem)ae;
            return new StructureConstant(type, kind, new IntegerConstant(aie.getValue()));
        }
        if (ae instanceof AnnotationLongElem) {
            AnnotationLongElem ale = (AnnotationLongElem)ae;
            return new StructureConstant(type, kind, new IntegerConstant(ale.getValue()));
        }
        if (ae instanceof AnnotationFloatElem) {
            AnnotationFloatElem afe = (AnnotationFloatElem)ae;
            return new StructureConstant(type, kind, new FloatingPointConstant(afe.getValue()));
        }
        if (ae instanceof AnnotationDoubleElem) {
            AnnotationDoubleElem ade = (AnnotationDoubleElem)ae;
            return new StructureConstant(type, kind, new FloatingPointConstant(ade.getValue()));
        }
        if (ae instanceof AnnotationStringElem) {
            AnnotationStringElem ase = (AnnotationStringElem)ae;
            return new StructureConstant(type, kind, this.getStringOrNull(ase.getValue()));
        }
        if (ae instanceof AnnotationClassElem) {
            AnnotationClassElem ace = (AnnotationClassElem)ae;
            this.addDependencyIfNeeded(ace.getDesc());
            return new StructureConstant(type, kind, this.getStringOrNull(ace.getDesc()));
        }
        if (ae instanceof AnnotationEnumElem) {
            AnnotationEnumElem aee = (AnnotationEnumElem)ae;
            this.addDependencyIfNeeded(aee.getTypeName());
            return new StructureConstant(type, kind, this.getStringOrNull(aee.getTypeName()), this.getStringOrNull(aee.getConstantName()));
        }
        if (ae instanceof AnnotationArrayElem) {
            AnnotationArrayElem aae = (AnnotationArrayElem)ae;
            Value[] values = new Value[aae.getNumValues() + 2];
            values[0] = kind;
            values[1] = new IntegerConstant((char)aae.getNumValues());
            for (int i = 0; i < aae.getNumValues(); ++i) {
                values[i + 2] = this.encodeAnnotationElementValue(aae.getValueAt(i));
            }
            return new StructureConstant(type, values);
        }
        if (ae instanceof AnnotationAnnotationElem) {
            AnnotationAnnotationElem aae = (AnnotationAnnotationElem)ae;
            return new StructureConstant(type, kind, this.encodeAnnotationTagValue(aae.getValue()));
        }
        throw new IllegalArgumentException("Unknown AnnotationElem type: " + ae.getClass());
    }

    private StructureType getAnnotationTagType(AnnotationTag tag) {
        Type[] types = new Type[tag.getNumElems() * 2 + 2];
        types[0] = Type.I8_PTR;
        types[1] = Type.I32;
        for (int i = 0; i < tag.getNumElems(); ++i) {
            types[i * 2 + 2] = Type.I8_PTR;
            types[i * 2 + 2 + 1] = this.getAnnotationElementType(tag.getElemAt(i));
        }
        return new StructureType(types);
    }

    private StructureConstant encodeAnnotationTagValue(AnnotationTag tag) {
        Value[] values = new Value[tag.getNumElems() * 2 + 2];
        values[0] = this.getString(tag.getType());
        this.addDependencyIfNeeded(tag.getType());
        values[1] = new IntegerConstant(tag.getNumElems());
        for (int i = 0; i < tag.getNumElems(); ++i) {
            values[i * 2 + 2] = this.getString(tag.getElemAt(i).getName());
            values[i * 2 + 2 + 1] = this.encodeAnnotationElementValue(tag.getElemAt(i));
        }
        return new StructureConstant(this.getAnnotationTagType(tag), values);
    }

    private Constant encodeAttributes(Host host) {
        List exceptions;
        ArrayList<Constant> attributes = new ArrayList<Constant>();
        for (Tag tag : host.getTags()) {
            if (tag instanceof SourceFileTag) {
                Constant sourceFile = this.getString(((SourceFileTag)tag).getSourceFile());
                attributes.add(new StructureConstant(new StructureType(Type.I8, Type.I8_PTR), new IntegerConstant(1), sourceFile));
                continue;
            }
            if (tag instanceof EnclosingMethodTag) {
                EnclosingMethodTag emt = (EnclosingMethodTag)tag;
                Constant eClass = this.getString(emt.getEnclosingClass());
                Constant eMethod = this.getStringOrNull(emt.getEnclosingMethod());
                Constant eDesc = this.getStringOrNull(emt.getEnclosingMethodSig());
                attributes.add(new StructureConstant(new StructureType(Type.I8, Type.I8_PTR, Type.I8_PTR, Type.I8_PTR), new IntegerConstant(4), eClass, eMethod, eDesc));
                continue;
            }
            if (tag instanceof SignatureTag) {
                Constant signature = this.getString(((SignatureTag)tag).getSignature());
                attributes.add(new StructureConstant(new StructureType(Type.I8, Type.I8_PTR), new IntegerConstant(2), signature));
                continue;
            }
            if (tag instanceof InnerClassTag) {
                InnerClassTag ict = (InnerClassTag)tag;
                Constant innerClass = this.getStringOrNull(ict.getInnerClass());
                Constant outerClass = this.getStringOrNull(ict.getOuterClass());
                Constant innerName = this.getStringOrNull(ict.getShortName());
                Iterator innerClassAccess = new IntegerConstant(ict.getAccessFlags());
                attributes.add(new StructureConstant(new StructureType(Type.I8, Type.I8_PTR, Type.I8_PTR, Type.I8_PTR, Type.I32), new Value[]{new IntegerConstant(3), innerClass, outerClass, innerName, innerClassAccess}));
                continue;
            }
            if (tag instanceof AnnotationDefaultTag) {
                StructureConstant value = this.encodeAnnotationElementValue(((AnnotationDefaultTag)tag).getDefaultVal());
                attributes.add(new StructureConstant(new StructureType(Type.I8, value.getType()), new IntegerConstant(8), value));
                continue;
            }
            if (tag instanceof VisibilityAnnotationTag) {
                VisibilityAnnotationTag vat = (VisibilityAnnotationTag)tag;
                if (vat.getVisibility() != 0) continue;
                Type[] types = new Type[vat.getAnnotations().size()];
                Value[] values = new Value[vat.getAnnotations().size()];
                int i = 0;
                for (AnnotationTag at : vat.getAnnotations()) {
                    values[i] = this.encodeAnnotationTagValue(at);
                    types[i] = values[i].getType();
                    ++i;
                }
                attributes.add(new StructureConstant(new StructureType(Type.I8, Type.I32, new StructureType(types)), new IntegerConstant(6), new IntegerConstant(vat.getAnnotations().size()), new StructureConstant(new StructureType(types), values)));
                continue;
            }
            if (!(tag instanceof VisibilityParameterAnnotationTag)) continue;
            VisibilityParameterAnnotationTag vpat = (VisibilityParameterAnnotationTag)tag;
            ArrayList<Type> typesList = new ArrayList<Type>();
            ArrayList<Constant> valuesList = new ArrayList<Constant>();
            boolean hasRuntimeVisible = false;
            for (VisibilityAnnotationTag vat : vpat.getVisibilityAnnotations()) {
                typesList.add(Type.I32);
                if (vat.getVisibility() == 0 && vat.getAnnotations() != null && !vat.getAnnotations().isEmpty()) {
                    hasRuntimeVisible = true;
                    valuesList.add(new IntegerConstant(vat.getAnnotations().size()));
                    for (AnnotationTag at : vat.getAnnotations()) {
                        StructureConstant value = this.encodeAnnotationTagValue(at);
                        valuesList.add(value);
                        typesList.add(value.getType());
                    }
                    continue;
                }
                valuesList.add(new IntegerConstant(0));
            }
            if (!hasRuntimeVisible) continue;
            Type[] types = typesList.toArray(new Type[0]);
            Value[] values = valuesList.toArray(new Value[0]);
            attributes.add(new StructureConstant(new StructureType(Type.I8, Type.I32, new StructureType(types)), new IntegerConstant(7), new IntegerConstant(vpat.getVisibilityAnnotations().size()), new StructureConstant(new StructureType(types), values)));
        }
        if (host instanceof SootMethod && !(exceptions = ((SootMethod)host).getExceptions()).isEmpty()) {
            Value[] values = new Value[exceptions.size()];
            for (int i = 0; i < exceptions.size(); ++i) {
                String exName = Types.getInternalName((SootClass)exceptions.get(i));
                values[i] = this.getString(exName);
                this.addDependency(exName);
            }
            attributes.add(new StructureConstant(new StructureType(Type.I8, Type.I32, new ArrayType(exceptions.size(), Type.I8_PTR)), new IntegerConstant(5), new IntegerConstant(exceptions.size()), new ArrayConstant(new ArrayType(exceptions.size(), Type.I8_PTR), values)));
        }
        if (attributes.isEmpty()) {
            return null;
        }
        attributes.add(0, new IntegerConstant(attributes.size()));
        Type[] types = new Type[attributes.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = ((Value)attributes.get(i)).getType();
        }
        return new StructureConstant(new StructureType(types), attributes.toArray(new Value[0])).flatten();
    }

    private Constant getString(String string) {
        return this.mb.getString(string);
    }

    private Constant getStringOrNull(String string) {
        return this.mb.getStringOrNull(string);
    }

    private void addDependency(String internalName) {
        this.dependencies.add(internalName);
    }

    private void addDependencyIfNeeded(String desc) {
        if (desc == null || Types.isPrimitive(desc) || Types.isArray(desc) && Types.isPrimitiveBaseType(desc)) {
            return;
        }
        if (Types.isArray(desc)) {
            this.dependencies.add(Types.getBaseType(desc));
        } else {
            this.dependencies.add(Types.getInternalNameFromDescriptor(desc));
        }
    }
}

