/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.watchconnectivity;

import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.watchconnectivity.WCSessionActivationState;
import org.robovm.apple.watchconnectivity.WCSessionDelegate;
import org.robovm.apple.watchconnectivity.WCSessionFileTransfer;
import org.robovm.apple.watchconnectivity.WCSessionUserInfoTransfer;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="WatchConnectivity")
@NativeClass
public class WCSession
extends NSObject {
    protected WCSession() {
    }

    protected WCSession(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected WCSession(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="defaultSession")
    public static native WCSession getDefaultSession();

    @Property(selector="delegate")
    public native WCSessionDelegate getDelegate();

    @Property(selector="setDelegate:", strongRef=true)
    public native void setDelegate(WCSessionDelegate var1);

    @Property(selector="activationState")
    public native WCSessionActivationState getActivationState();

    @Property(selector="hasContentPending")
    public native boolean hasContentPending();

    @Property(selector="isPaired")
    public native boolean isPaired();

    @Property(selector="isWatchAppInstalled")
    public native boolean isWatchAppInstalled();

    @Property(selector="isComplicationEnabled")
    public native boolean isComplicationEnabled();

    @Property(selector="remainingComplicationUserInfoTransfers")
    @MachineSizedUInt
    public native long getRemainingComplicationUserInfoTransfers();

    @Property(selector="watchDirectoryURL")
    public native NSURL getWatchDirectoryURL();

    @Property(selector="isReachable")
    public native boolean isReachable();

    @Property(selector="applicationContext")
    public native NSDictionary<NSString, ?> getApplicationContext();

    @Property(selector="receivedApplicationContext")
    public native NSDictionary<NSString, ?> getReceivedApplicationContext();

    @Property(selector="outstandingUserInfoTransfers")
    public native NSArray<WCSessionUserInfoTransfer> getOutstandingUserInfoTransfers();

    @Property(selector="outstandingFileTransfers")
    public native NSArray<WCSessionFileTransfer> getOutstandingFileTransfers();

    @Method(selector="activateSession")
    public native void activateSession();

    @Method(selector="sendMessage:replyHandler:errorHandler:")
    public native void sendMessage(NSDictionary<NSString, ?> var1, @Block VoidBlock1<NSDictionary<NSString, ?>> var2, @Block VoidBlock1<NSError> var3);

    @Method(selector="sendMessageData:replyHandler:errorHandler:")
    public native void sendMessageData(NSData var1, @Block VoidBlock1<NSData> var2, @Block VoidBlock1<NSError> var3);

    public boolean updateApplicationContext(NSDictionary<NSString, ?> applicationContext) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.updateApplicationContext(applicationContext, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="updateApplicationContext:error:")
    private native boolean updateApplicationContext(NSDictionary<NSString, ?> var1, NSError.NSErrorPtr var2);

    @Method(selector="transferUserInfo:")
    public native WCSessionUserInfoTransfer transferUserInfo(NSDictionary<NSString, ?> var1);

    @Method(selector="transferCurrentComplicationUserInfo:")
    public native WCSessionUserInfoTransfer transferCurrentComplicationUserInfo(NSDictionary<NSString, ?> var1);

    @Method(selector="transferFile:metadata:")
    public native WCSessionFileTransfer transferFile(NSURL var1, NSDictionary<NSString, ?> var2);

    @Method(selector="isSupported")
    public static native boolean isSupported();

    static {
        ObjCRuntime.bind(WCSession.class);
    }

    public static class WCSessionPtr
    extends Ptr<WCSession, WCSessionPtr> {
    }
}

