/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import java.util.Set;
import org.robovm.apple.coregraphics.CGAffineTransform;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSCoder;
import org.robovm.apple.foundation.NSMutableSet;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSSecureCoding;
import org.robovm.apple.foundation.NSSet;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.uikit.UIFontDescriptorAttribute;
import org.robovm.apple.uikit.UIFontDescriptorAttributes;
import org.robovm.apple.uikit.UIFontDescriptorSymbolicTraits;
import org.robovm.apple.uikit.UIFontTextStyle;
import org.robovm.apple.uikit.UITraitCollection;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="UIKit")
@NativeClass
public class UIFontDescriptor
extends NSObject
implements NSSecureCoding {
    public UIFontDescriptor() {
    }

    protected UIFontDescriptor(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected UIFontDescriptor(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithCoder:")
    public UIFontDescriptor(NSCoder aDecoder) {
        super(null);
        this.initObject(this.init(aDecoder));
    }

    @Method(selector="initWithFontAttributes:")
    public UIFontDescriptor(UIFontDescriptorAttributes attributes) {
        super(null);
        this.initObject(this.init(attributes));
    }

    public UIFontDescriptor(String fontName, @MachineSizedFloat double size) {
        super(null, UIFontDescriptor.create(fontName, size));
        UIFontDescriptor.retain(this.getHandle());
    }

    public UIFontDescriptor(String fontName, @ByVal CGAffineTransform matrix) {
        super(null, UIFontDescriptor.create(fontName, matrix));
        UIFontDescriptor.retain(this.getHandle());
    }

    @Property(selector="postscriptName")
    public native String getPostscriptName();

    @Property(selector="pointSize")
    @MachineSizedFloat
    public native double getPointSize();

    @Property(selector="matrix")
    @ByVal
    public native CGAffineTransform getMatrix();

    @Property(selector="symbolicTraits")
    public native UIFontDescriptorSymbolicTraits getSymbolicTraits();

    @Property(selector="fontAttributes")
    public native UIFontDescriptorAttributes getFontAttributes();

    @Property(selector="supportsSecureCoding")
    public static native boolean supportsSecureCoding();

    public NSObject getValue(String attribute) {
        return this.getValue(new NSString(attribute));
    }

    public NSObject getValue(UIFontDescriptorAttribute attribute) {
        return this.getValue((NSString)attribute.value());
    }

    public NSArray<UIFontDescriptor> getMatchingFontDescriptors(String ... mandatoryAttributes) {
        return this.getMatchingFontDescriptors(NSSet.fromStrings(mandatoryAttributes));
    }

    public NSArray<UIFontDescriptor> getMatchingFontDescriptors(Set<UIFontDescriptorAttribute> mandatoryAttributes) {
        NSMutableSet<NSString> set = new NSMutableSet<NSString>();
        for (UIFontDescriptorAttribute attr : mandatoryAttributes) {
            set.add((NSString)((NSObject)attr.value()));
        }
        return this.getMatchingFontDescriptors((NSSet<NSString>)set);
    }

    @Method(selector="initWithCoder:")
    @Pointer
    protected native long init(NSCoder var1);

    @Method(selector="objectForKey:")
    protected native NSObject getValue(NSString var1);

    @Method(selector="matchingFontDescriptorsWithMandatoryKeys:")
    protected native NSArray<UIFontDescriptor> getMatchingFontDescriptors(NSSet<NSString> var1);

    @Method(selector="initWithFontAttributes:")
    @Pointer
    protected native long init(UIFontDescriptorAttributes var1);

    @Method(selector="fontDescriptorByAddingAttributes:")
    public native UIFontDescriptor newWithAttributes(UIFontDescriptorAttributes var1);

    @Method(selector="fontDescriptorWithSize:")
    public native UIFontDescriptor newWithSize(@MachineSizedFloat double var1);

    @Method(selector="fontDescriptorWithMatrix:")
    public native UIFontDescriptor newWithMatrix(@ByVal CGAffineTransform var1);

    @Method(selector="fontDescriptorWithFace:")
    public native UIFontDescriptor newWithFace(String var1);

    @Method(selector="fontDescriptorWithFamily:")
    public native UIFontDescriptor newWithFamily(String var1);

    @Method(selector="fontDescriptorWithSymbolicTraits:")
    public native UIFontDescriptor newWithSymbolicTraits(UIFontDescriptorSymbolicTraits var1);

    @Method(selector="fontDescriptorWithName:size:")
    @Pointer
    protected static native long create(String var0, @MachineSizedFloat double var1);

    @Method(selector="fontDescriptorWithName:matrix:")
    @Pointer
    protected static native long create(String var0, @ByVal CGAffineTransform var1);

    @Method(selector="preferredFontDescriptorWithTextStyle:")
    public static native UIFontDescriptor getPreferredFontDescriptor(UIFontTextStyle var0);

    @Method(selector="preferredFontDescriptorWithTextStyle:compatibleWithTraitCollection:")
    public static native UIFontDescriptor getPreferredFontDescriptor(UIFontTextStyle var0, UITraitCollection var1);

    @Override
    @Method(selector="encodeWithCoder:")
    public native void encode(NSCoder var1);

    static {
        ObjCRuntime.bind(UIFontDescriptor.class);
    }

    public static class UIFontDescriptorPtr
    extends Ptr<UIFontDescriptor, UIFontDescriptorPtr> {
    }
}

