/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSFileAttributes;
import org.robovm.apple.foundation.NSFilePresenter;
import org.robovm.apple.foundation.NSFileVersion;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSProgress;
import org.robovm.apple.foundation.NSProgressReporting;
import org.robovm.apple.foundation.NSSet;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.foundation.NSUndoManager;
import org.robovm.apple.foundation.NSUserActivity;
import org.robovm.apple.uikit.UIDocumentChangeKind;
import org.robovm.apple.uikit.UIDocumentSaveOperation;
import org.robovm.apple.uikit.UIDocumentState;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBooleanBlock;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="UIKit")
@NativeClass
public class UIDocument
extends NSObject
implements NSFilePresenter,
NSProgressReporting {
    public UIDocument() {
    }

    protected UIDocument(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected UIDocument(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithFileURL:")
    public UIDocument(NSURL url) {
        super(null);
        this.initObject(this.init(url));
    }

    @Property(selector="fileURL")
    public native NSURL getFileURL();

    @Property(selector="localizedName")
    public native String getLocalizedName();

    @Property(selector="fileType")
    public native String getFileType();

    @Property(selector="fileModificationDate")
    public native NSDate getFileModificationDate();

    @Property(selector="setFileModificationDate:")
    public native void setFileModificationDate(NSDate var1);

    @Property(selector="documentState")
    public native UIDocumentState getDocumentState();

    @Override
    @Property(selector="progress")
    public native NSProgress getProgress();

    @Property(selector="undoManager")
    public native NSUndoManager getUndoManager();

    @Property(selector="setUndoManager:")
    public native void setUndoManager(NSUndoManager var1);

    @Property(selector="hasUnsavedChanges")
    public native boolean hasUnsavedChanges();

    @Property(selector="savingFileType")
    public native String getSavingFileType();

    @Property(selector="userActivity")
    public native NSUserActivity getUserActivity();

    @Property(selector="setUserActivity:")
    public native void setUserActivity(NSUserActivity var1);

    @Override
    @Property(selector="presentedItemURL")
    public native NSURL getPresentedItemURL();

    @Override
    @Property(selector="presentedItemOperationQueue")
    public native NSOperationQueue getPresentedItemOperationQueue();

    @Override
    @Property(selector="observedPresentedItemUbiquityAttributes")
    public native NSSet<NSString> getObservedPresentedItemUbiquityAttributes();

    @GlobalValue(symbol="UIDocumentStateChangedNotification", optional=true)
    public static native NSString StateChangedNotification();

    @GlobalValue(symbol="NSUserActivityDocumentURLKey", optional=true)
    public static native String UserActivityDocumentURLKey();

    @Method(selector="initWithFileURL:")
    @Pointer
    protected native long init(NSURL var1);

    @Method(selector="openWithCompletionHandler:")
    public native void open(@Block VoidBooleanBlock var1);

    @Method(selector="closeWithCompletionHandler:")
    public native void close(@Block VoidBooleanBlock var1);

    public boolean loadFromContents(NSObject contents, String typeName) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.loadFromContents(contents, typeName, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="loadFromContents:ofType:error:")
    private native boolean loadFromContents(NSObject var1, String var2, NSError.NSErrorPtr var3);

    public NSObject getContentsForType(String typeName) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSObject result = this.getContentsForType(typeName, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="contentsForType:error:")
    private native NSObject getContentsForType(String var1, NSError.NSErrorPtr var2);

    @Method(selector="disableEditing")
    public native void disableEditing();

    @Method(selector="enableEditing")
    public native void enableEditing();

    @Method(selector="updateChangeCount:")
    public native void updateChangeCount(UIDocumentChangeKind var1);

    @Method(selector="changeCountTokenForSaveOperation:")
    public native NSObject getChangeCountToken(UIDocumentSaveOperation var1);

    @Method(selector="updateChangeCountWithToken:forSaveOperation:")
    public native void updateChangeCount(NSObject var1, UIDocumentSaveOperation var2);

    @Method(selector="saveToURL:forSaveOperation:completionHandler:")
    public native void save(NSURL var1, UIDocumentSaveOperation var2, @Block VoidBooleanBlock var3);

    @Method(selector="autosaveWithCompletionHandler:")
    public native void autoSave(@Block VoidBooleanBlock var1);

    @Method(selector="fileNameExtensionForType:saveOperation:")
    public native String getFileNameExtension(String var1, UIDocumentSaveOperation var2);

    public boolean writeContents(NSObject contents, NSFileAttributes additionalFileAttributes, NSURL url, UIDocumentSaveOperation saveOperation) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.writeContents(contents, additionalFileAttributes, url, saveOperation, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="writeContents:andAttributes:safelyToURL:forSaveOperation:error:")
    private native boolean writeContents(NSObject var1, NSFileAttributes var2, NSURL var3, UIDocumentSaveOperation var4, NSError.NSErrorPtr var5);

    public boolean writeContents(NSObject contents, NSURL url, UIDocumentSaveOperation saveOperation, NSURL originalContentsURL) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.writeContents(contents, url, saveOperation, originalContentsURL, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="writeContents:toURL:forSaveOperation:originalContentsURL:error:")
    private native boolean writeContents(NSObject var1, NSURL var2, UIDocumentSaveOperation var3, NSURL var4, NSError.NSErrorPtr var5);

    public NSFileAttributes getFileAttributesToWrite(NSURL url, UIDocumentSaveOperation saveOperation) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSFileAttributes result = this.getFileAttributesToWrite(url, saveOperation, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="fileAttributesToWriteToURL:forSaveOperation:error:")
    private native NSFileAttributes getFileAttributesToWrite(NSURL var1, UIDocumentSaveOperation var2, NSError.NSErrorPtr var3);

    public boolean read(NSURL url) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.read(url, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="readFromURL:error:")
    private native boolean read(NSURL var1, NSError.NSErrorPtr var2);

    @Method(selector="performAsynchronousFileAccessUsingBlock:")
    public native void performAsynchronousFileAccess(@Block Runnable var1);

    @Method(selector="handleError:userInteractionPermitted:")
    public native void handleError(NSError var1, boolean var2);

    @Method(selector="finishedHandlingError:recovered:")
    public native void finishedHandlingError(NSError var1, boolean var2);

    @Method(selector="userInteractionNoLongerPermittedForError:")
    public native void userInteractionNoLongerPermitted(NSError var1);

    @Method(selector="revertToContentsOfURL:completionHandler:")
    public native void revert(NSURL var1, @Block VoidBooleanBlock var2);

    @Method(selector="updateUserActivityState:")
    public native void updateUserActivityState(NSUserActivity var1);

    @Method(selector="restoreUserActivityState:")
    public native void restoreUserActivityState(NSUserActivity var1);

    @Override
    @Method(selector="relinquishPresentedItemToReader:")
    public native void relinquishPresentedItemToReader(@Block(value="(@Block)") VoidBlock1<Runnable> var1);

    @Override
    @Method(selector="relinquishPresentedItemToWriter:")
    public native void relinquishPresentedItemToWriter(@Block(value="(@Block)") VoidBlock1<Runnable> var1);

    @Override
    @Method(selector="savePresentedItemChangesWithCompletionHandler:")
    public native void savePresentedItemChanges(@Block VoidBlock1<NSError> var1);

    @Override
    @Method(selector="accommodatePresentedItemDeletionWithCompletionHandler:")
    public native void accommodatePresentedItemDeletion(@Block VoidBlock1<NSError> var1);

    @Override
    @Method(selector="presentedItemDidMoveToURL:")
    public native void presentedItemDidMoveToURL(NSURL var1);

    @Override
    @Method(selector="presentedItemDidChange")
    public native void presentedItemDidChange();

    @Override
    @Method(selector="presentedItemDidChangeUbiquityAttributes:")
    public native void presentedItemDidChangeUbiquityAttributes(NSSet<NSString> var1);

    @Override
    @Method(selector="presentedItemDidGainVersion:")
    public native void presentedItemDidGainVersion(NSFileVersion var1);

    @Override
    @Method(selector="presentedItemDidLoseVersion:")
    public native void presentedItemDidLoseVersion(NSFileVersion var1);

    @Override
    @Method(selector="presentedItemDidResolveConflictVersion:")
    public native void presentedItemDidResolveConflictVersion(NSFileVersion var1);

    @Override
    @Method(selector="accommodatePresentedSubitemDeletionAtURL:completionHandler:")
    public native void accommodatePresentedSubitemDeletionAtURL(NSURL var1, @Block VoidBlock1<NSError> var2);

    @Override
    @Method(selector="presentedSubitemDidAppearAtURL:")
    public native void presentedSubitemDidAppearAtURL(NSURL var1);

    @Override
    @Method(selector="presentedSubitemAtURL:didMoveToURL:")
    public native void presentedSubitemAtURLDidMoveToURL(NSURL var1, NSURL var2);

    @Override
    @Method(selector="presentedSubitemDidChangeAtURL:")
    public native void presentedSubitemDidChangeAtURL(NSURL var1);

    @Override
    @Method(selector="presentedSubitemAtURL:didGainVersion:")
    public native void presentedSubitemAtURLDidGainVersion(NSURL var1, NSFileVersion var2);

    @Override
    @Method(selector="presentedSubitemAtURL:didLoseVersion:")
    public native void presentedSubitemAtURLDidLoseVersion(NSURL var1, NSFileVersion var2);

    @Override
    @Method(selector="presentedSubitemAtURL:didResolveConflictVersion:")
    public native void presentedSubitemAtURLDidResolveConflictVersion(NSURL var1, NSFileVersion var2);

    static {
        ObjCRuntime.bind(UIDocument.class);
    }

    public static class UIDocumentPtr
    extends Ptr<UIDocument, UIDocumentPtr> {
    }

    public static class Notifications {
        public static NSObject observeStateChanged(UIDocument object, final VoidBlock1<UIDocument> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIDocument.StateChangedNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((UIDocument)a.getObject()));
                }
            });
        }
    }
}

