/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSLigature;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSTextDirection;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.uikit.NSAttributedStringAttribute;
import org.robovm.apple.uikit.NSParagraphStyle;
import org.robovm.apple.uikit.NSShadow;
import org.robovm.apple.uikit.NSTextAttachment;
import org.robovm.apple.uikit.NSTextEffect;
import org.robovm.apple.uikit.NSUnderlineStyle;
import org.robovm.apple.uikit.UIColor;
import org.robovm.apple.uikit.UIFont;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="UIKit")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class NSAttributedStringAttributes
extends NSDictionaryWrapper {
    public NSAttributedStringAttributes(NSDictionary data) {
        super(data);
    }

    public NSAttributedStringAttributes() {
    }

    public boolean has(String key) {
        return this.data.containsKey(new NSString(key));
    }

    public NSObject get(String key) {
        if (this.has(key)) {
            return this.data.get(new NSString(key));
        }
        return null;
    }

    public NSAttributedStringAttributes set(String key, NSObject value) {
        this.data.put(new NSString(key), value);
        return this;
    }

    public boolean has(NSAttributedStringAttribute key) {
        return this.data.containsKey(key.value());
    }

    public NSObject get(NSAttributedStringAttribute key) {
        if (this.has(key)) {
            return this.data.get(key.value());
        }
        return null;
    }

    public NSAttributedStringAttributes set(NSAttributedStringAttribute key, NSObject value) {
        this.data.put((NSObject)key.value(), value);
        return this;
    }

    public boolean isSpeechPunctuation() {
        if (this.has(NSAttributedStringAttribute.SpeechPunctuation)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringAttribute.SpeechPunctuation);
            return val.booleanValue();
        }
        return false;
    }

    public NSAttributedStringAttributes setSpeechPunctuation(boolean speechPunctuation) {
        this.set(NSAttributedStringAttribute.SpeechPunctuation, (NSObject)NSNumber.valueOf(speechPunctuation));
        return this;
    }

    public String getSpeechLanguage() {
        if (this.has(NSAttributedStringAttribute.SpeechLanguage)) {
            NSString val = (NSString)this.get(NSAttributedStringAttribute.SpeechLanguage);
            return val.toString();
        }
        return null;
    }

    public NSAttributedStringAttributes setSpeechLanguage(String speechLanguage) {
        this.set(NSAttributedStringAttribute.SpeechLanguage, (NSObject)new NSString(speechLanguage));
        return this;
    }

    public double getSpeechPitch() {
        if (this.has(NSAttributedStringAttribute.SpeechPitch)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringAttribute.SpeechPitch);
            return val.doubleValue();
        }
        return 0.0;
    }

    public NSAttributedStringAttributes setSpeechPitch(double speechPitch) {
        this.set(NSAttributedStringAttribute.SpeechPitch, (NSObject)NSNumber.valueOf(speechPitch));
        return this;
    }

    public UIFont getFont() {
        if (this.has(NSAttributedStringAttribute.Font)) {
            UIFont val = (UIFont)this.get(NSAttributedStringAttribute.Font);
            return val;
        }
        return null;
    }

    public NSAttributedStringAttributes setFont(UIFont font) {
        this.set(NSAttributedStringAttribute.Font, (NSObject)font);
        return this;
    }

    public NSParagraphStyle getParagraphStyle() {
        if (this.has(NSAttributedStringAttribute.ParagraphStyle)) {
            NSParagraphStyle val = (NSParagraphStyle)this.get(NSAttributedStringAttribute.ParagraphStyle);
            return val;
        }
        return null;
    }

    public NSAttributedStringAttributes setParagraphStyle(NSParagraphStyle paragraphStyle) {
        this.set(NSAttributedStringAttribute.ParagraphStyle, (NSObject)paragraphStyle);
        return this;
    }

    public UIColor getForegroundColor() {
        if (this.has(NSAttributedStringAttribute.ForegroundColor)) {
            UIColor val = (UIColor)this.get(NSAttributedStringAttribute.ForegroundColor);
            return val;
        }
        return null;
    }

    public NSAttributedStringAttributes setForegroundColor(UIColor foregroundColor) {
        this.set(NSAttributedStringAttribute.ForegroundColor, (NSObject)foregroundColor);
        return this;
    }

    public UIColor getBackgroundColor() {
        if (this.has(NSAttributedStringAttribute.BackgroundColor)) {
            UIColor val = (UIColor)this.get(NSAttributedStringAttribute.BackgroundColor);
            return val;
        }
        return null;
    }

    public NSAttributedStringAttributes setBackgroundColor(UIColor backgroundColor) {
        this.set(NSAttributedStringAttribute.BackgroundColor, (NSObject)backgroundColor);
        return this;
    }

    public double getKerning() {
        if (this.has(NSAttributedStringAttribute.Kern)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringAttribute.Kern);
            return val.doubleValue();
        }
        return 0.0;
    }

    public NSAttributedStringAttributes setKerning(double kerning) {
        this.set(NSAttributedStringAttribute.Kern, (NSObject)NSNumber.valueOf(kerning));
        return this;
    }

    public NSUnderlineStyle getStrikethroughStyle() {
        if (this.has(NSAttributedStringAttribute.StrikethroughStyle)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringAttribute.StrikethroughStyle);
            return NSUnderlineStyle.valueOf(val.longValue());
        }
        return null;
    }

    public NSAttributedStringAttributes setStrikethroughStyle(NSUnderlineStyle strikethroughStyle) {
        this.set(NSAttributedStringAttribute.StrikethroughStyle, (NSObject)NSNumber.valueOf(strikethroughStyle.value()));
        return this;
    }

    public NSUnderlineStyle getUnderlineStyle() {
        if (this.has(NSAttributedStringAttribute.UnderlineStyle)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringAttribute.UnderlineStyle);
            return NSUnderlineStyle.valueOf(val.longValue());
        }
        return null;
    }

    public NSAttributedStringAttributes setUnderlineStyle(NSUnderlineStyle underlineStyle) {
        this.set(NSAttributedStringAttribute.UnderlineStyle, (NSObject)NSNumber.valueOf(underlineStyle.value()));
        return this;
    }

    public UIColor getStrokeColor() {
        if (this.has(NSAttributedStringAttribute.StrokeColor)) {
            UIColor val = (UIColor)this.get(NSAttributedStringAttribute.StrokeColor);
            return val;
        }
        return null;
    }

    public NSAttributedStringAttributes setStrokeColor(UIColor strokeColor) {
        this.set(NSAttributedStringAttribute.StrokeColor, (NSObject)strokeColor);
        return this;
    }

    public double getStrokeWidth() {
        if (this.has(NSAttributedStringAttribute.StrokeWidth)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringAttribute.StrokeWidth);
            return val.doubleValue();
        }
        return 0.0;
    }

    public NSAttributedStringAttributes setStrokeWidth(double strokeWidth) {
        this.set(NSAttributedStringAttribute.StrokeWidth, (NSObject)NSNumber.valueOf(strokeWidth));
        return this;
    }

    public NSShadow getShadow() {
        if (this.has(NSAttributedStringAttribute.Shadow)) {
            NSShadow val = (NSShadow)this.get(NSAttributedStringAttribute.Shadow);
            return val;
        }
        return null;
    }

    public NSAttributedStringAttributes setShadow(NSShadow shadow) {
        this.set(NSAttributedStringAttribute.Shadow, (NSObject)shadow);
        return this;
    }

    public NSTextEffect getTextEffect() {
        if (this.has(NSAttributedStringAttribute.TextEffect)) {
            NSString val = (NSString)this.get(NSAttributedStringAttribute.TextEffect);
            return NSTextEffect.valueOf(val);
        }
        return null;
    }

    public NSAttributedStringAttributes setTextEffect(NSTextEffect textEffect) {
        this.set(NSAttributedStringAttribute.TextEffect, (NSObject)textEffect.value());
        return this;
    }

    public NSTextAttachment getAttachment() {
        if (this.has(NSAttributedStringAttribute.Attachment)) {
            NSTextAttachment val = (NSTextAttachment)this.get(NSAttributedStringAttribute.Attachment);
            return val;
        }
        return null;
    }

    public NSAttributedStringAttributes setAttachment(NSTextAttachment attachment) {
        this.set(NSAttributedStringAttribute.Attachment, (NSObject)attachment);
        return this;
    }

    public NSURL getLink() {
        if (this.has(NSAttributedStringAttribute.Link)) {
            NSURL val = (NSURL)this.get(NSAttributedStringAttribute.Link);
            return val;
        }
        return null;
    }

    public NSAttributedStringAttributes setLink(NSURL link) {
        this.set(NSAttributedStringAttribute.Link, (NSObject)link);
        return this;
    }

    public double getBaselineOffset() {
        if (this.has(NSAttributedStringAttribute.BaselineOffset)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringAttribute.BaselineOffset);
            return val.doubleValue();
        }
        return 0.0;
    }

    public NSAttributedStringAttributes setBaselineOffset(double baselineOffset) {
        this.set(NSAttributedStringAttribute.BaselineOffset, (NSObject)NSNumber.valueOf(baselineOffset));
        return this;
    }

    public UIColor getUnderlineColor() {
        if (this.has(NSAttributedStringAttribute.UnderlineColor)) {
            UIColor val = (UIColor)this.get(NSAttributedStringAttribute.UnderlineColor);
            return val;
        }
        return null;
    }

    public NSAttributedStringAttributes setUnderlineColor(UIColor underlineColor) {
        this.set(NSAttributedStringAttribute.UnderlineColor, (NSObject)underlineColor);
        return this;
    }

    public UIColor getStrikethroughColor() {
        if (this.has(NSAttributedStringAttribute.StrikethroughColor)) {
            UIColor val = (UIColor)this.get(NSAttributedStringAttribute.StrikethroughColor);
            return val;
        }
        return null;
    }

    public NSAttributedStringAttributes setStrikethroughColor(UIColor strikethroughColor) {
        this.set(NSAttributedStringAttribute.StrikethroughColor, (NSObject)strikethroughColor);
        return this;
    }

    public double getObliqueness() {
        if (this.has(NSAttributedStringAttribute.Obliqueness)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringAttribute.Obliqueness);
            return val.doubleValue();
        }
        return 0.0;
    }

    public NSAttributedStringAttributes setObliqueness(double obliqueness) {
        this.set(NSAttributedStringAttribute.Obliqueness, (NSObject)NSNumber.valueOf(obliqueness));
        return this;
    }

    public double getExpansion() {
        if (this.has(NSAttributedStringAttribute.Expansion)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringAttribute.Expansion);
            return val.doubleValue();
        }
        return 0.0;
    }

    public NSAttributedStringAttributes setExpansion(double expansion) {
        this.set(NSAttributedStringAttribute.Expansion, (NSObject)NSNumber.valueOf(expansion));
        return this;
    }

    public boolean isVerticalText() {
        if (this.has(NSAttributedStringAttribute.VerticalGlyphForm)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringAttribute.VerticalGlyphForm);
            return val.booleanValue();
        }
        return false;
    }

    public NSAttributedStringAttributes setVerticalText(boolean verticalText) {
        this.set(NSAttributedStringAttribute.VerticalGlyphForm, (NSObject)NSNumber.valueOf(verticalText));
        return this;
    }

    public List<NSTextDirection> getWritingDirections() {
        ArrayList<NSTextDirection> list = new ArrayList<NSTextDirection>();
        if (this.has(NSAttributedStringAttribute.WritingDirection)) {
            NSArray val = (NSArray)this.get(NSAttributedStringAttribute.WritingDirection);
            for (NSNumber n : val) {
                list.add(NSTextDirection.values()[n.intValue()]);
            }
        }
        return list;
    }

    public NSAttributedStringAttributes setWritingDirections(List<NSTextDirection> writingDirections) {
        NSMutableArray<NSNumber> list = new NSMutableArray<NSNumber>();
        for (NSTextDirection n : writingDirections) {
            list.add(NSNumber.valueOf(n.ordinal()));
        }
        this.set(NSAttributedStringAttribute.WritingDirection, list);
        return this;
    }

    public NSLigature getLigature() {
        if (this.has(NSAttributedStringAttribute.Ligature)) {
            NSNumber val = (NSNumber)this.get(NSAttributedStringAttribute.Ligature);
            return NSLigature.values()[val.intValue()];
        }
        return null;
    }

    public NSAttributedStringAttributes setLigature(NSLigature ligature) {
        this.set(NSAttributedStringAttribute.Ligature, (NSObject)NSNumber.valueOf(ligature.ordinal()));
        return this;
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<NSAttributedStringAttributes> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<NSAttributedStringAttributes> list = new ArrayList<NSAttributedStringAttributes>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new NSAttributedStringAttributes((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<NSAttributedStringAttributes> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (NSAttributedStringAttributes i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSAttributedStringAttributes toObject(Class<NSAttributedStringAttributes> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSAttributedStringAttributes(o);
        }

        @MarshalsPointer
        public static long toNative(NSAttributedStringAttributes o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

