/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.security;

import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFData;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.dispatch.DispatchQueue;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.security.SecCertificate;
import org.robovm.apple.security.SecKey;
import org.robovm.apple.security.SecPolicy;
import org.robovm.apple.security.SecTrustProperties;
import org.robovm.apple.security.SecTrustResult;
import org.robovm.apple.security.SecTrustResultType;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Security")
public class SecTrust
extends CFType {
    protected SecTrust() {
    }

    public static SecTrust create(SecCertificate certificate, SecPolicy policy) throws OSStatusException {
        if (certificate == null) {
            throw new NullPointerException("certificate");
        }
        if (policy == null) {
            throw new NullPointerException("policy");
        }
        SecTrustPtr ptr = new SecTrustPtr();
        OSStatus status = SecTrust.create0(certificate, policy, ptr);
        OSStatusException.throwIfNecessary(status);
        return (SecTrust)ptr.get();
    }

    public static SecTrust create(List<SecCertificate> certificates, List<SecPolicy> policies) throws OSStatusException {
        if (certificates == null) {
            throw new NullPointerException("certificates");
        }
        if (policies == null) {
            throw new NullPointerException("policies");
        }
        SecTrustPtr ptr = new SecTrustPtr();
        OSStatus status = SecTrust.create0(CFArray.create(certificates), CFArray.create(policies), ptr);
        OSStatusException.throwIfNecessary(status);
        return (SecTrust)ptr.get();
    }

    public void setPolicy(SecPolicy policy) throws OSStatusException {
        OSStatus status = this.setPolicies0(policy);
        OSStatusException.throwIfNecessary(status);
    }

    public void setPolicies(List<SecPolicy> policies) throws OSStatusException {
        OSStatus status = this.setPolicies0(CFArray.create(policies));
        OSStatusException.throwIfNecessary(status);
    }

    public List<SecPolicy> getPolicies() throws OSStatusException {
        CFArray.CFArrayPtr ptr = new CFArray.CFArrayPtr();
        OSStatus status = this.getPolicies0(ptr);
        OSStatusException.throwIfNecessary(status);
        if (ptr.get() != null) {
            return ((CFArray)ptr.get()).toList(SecPolicy.class);
        }
        return null;
    }

    public void setNetworkFetchAllowed(boolean allowFetch) throws OSStatusException {
        OSStatus status = this.setNetworkFetchAllowed0(allowFetch);
        OSStatusException.throwIfNecessary(status);
    }

    public boolean isNetworkFetchAllowed() throws OSStatusException {
        BooleanPtr ptr = new BooleanPtr();
        OSStatus status = this.isNetworkFetchAllowed0(ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public void setAnchorCertificates(List<SecCertificate> anchorCertificates) throws OSStatusException {
        OSStatus status = this.setAnchorCertificates0(anchorCertificates);
        OSStatusException.throwIfNecessary(status);
    }

    public void setAnchorCertificatesOnly(boolean anchorCertificatesOnly) throws OSStatusException {
        OSStatus status = this.setAnchorCertificatesOnly0(anchorCertificatesOnly);
        OSStatusException.throwIfNecessary(status);
    }

    public List<SecCertificate> getCustomAnchorCertificates() throws OSStatusException {
        CFArray.CFArrayPtr ptr = new CFArray.CFArrayPtr();
        OSStatus status = this.getCustomAnchorCertificates0(ptr);
        OSStatusException.throwIfNecessary(status);
        if (ptr.get() != null) {
            return ((CFArray)ptr.get()).toList(SecCertificate.class);
        }
        return null;
    }

    public void setVerifyDate(NSDate verifyDate) throws OSStatusException {
        OSStatus status = this.setVerifyDate0(verifyDate);
        OSStatusException.throwIfNecessary(status);
    }

    public SecTrustResultType evaluate() throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.evaluate0(ptr);
        OSStatusException.throwIfNecessary(status);
        return SecTrustResultType.valueOf(ptr.get());
    }

    @WeaklyLinked
    public void evaluateAsync(DispatchQueue queue, VoidBlock2<SecTrust, SecTrustResultType> result) throws OSStatusException {
        OSStatus status = this.evaluateAsync0(queue, result);
        OSStatusException.throwIfNecessary(status);
    }

    public SecTrustResultType getTrustResult() throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.getTrustResult0(ptr);
        OSStatusException.throwIfNecessary(status);
        return SecTrustResultType.valueOf(ptr.get());
    }

    public void setOCSPResponse(NSData responseData) throws OSStatusException {
        if (responseData == null) {
            throw new NullPointerException("responseData");
        }
        OSStatus status = this.setOCSPResponse0((CFType)responseData.as(CFData.class));
        OSStatusException.throwIfNecessary(status);
    }

    public void setOCSPResponse(List<NSData> responseData) throws OSStatusException {
        if (responseData == null) {
            throw new NullPointerException("responseData");
        }
        OSStatus status = this.setOCSPResponse0(CFArray.create(responseData));
        OSStatusException.throwIfNecessary(status);
    }

    @Bridge(symbol="SecTrustGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="SecTrustCreateWithCertificates", optional=true)
    protected static native OSStatus create0(CFType var0, CFType var1, SecTrustPtr var2);

    @Bridge(symbol="SecTrustSetPolicies", optional=true)
    protected native OSStatus setPolicies0(CFType var1);

    @Bridge(symbol="SecTrustCopyPolicies", optional=true)
    protected native OSStatus getPolicies0(CFArray.CFArrayPtr var1);

    @Bridge(symbol="SecTrustSetNetworkFetchAllowed", optional=true)
    protected native OSStatus setNetworkFetchAllowed0(boolean var1);

    @Bridge(symbol="SecTrustGetNetworkFetchAllowed", optional=true)
    protected native OSStatus isNetworkFetchAllowed0(BooleanPtr var1);

    @Bridge(symbol="SecTrustSetAnchorCertificates", optional=true)
    protected native OSStatus setAnchorCertificates0(@Marshaler(value=CFType.AsListMarshaler.class) List<SecCertificate> var1);

    @Bridge(symbol="SecTrustSetAnchorCertificatesOnly", optional=true)
    protected native OSStatus setAnchorCertificatesOnly0(boolean var1);

    @Bridge(symbol="SecTrustCopyCustomAnchorCertificates", optional=true)
    protected native OSStatus getCustomAnchorCertificates0(CFArray.CFArrayPtr var1);

    @Bridge(symbol="SecTrustSetVerifyDate", optional=true)
    protected native OSStatus setVerifyDate0(NSDate var1);

    @Bridge(symbol="SecTrustGetVerifyTime", optional=true)
    public native double getVerifyTime();

    @Bridge(symbol="SecTrustEvaluate", optional=true)
    protected native OSStatus evaluate0(IntPtr var1);

    @Bridge(symbol="SecTrustEvaluateAsync", optional=true)
    @WeaklyLinked
    protected native OSStatus evaluateAsync0(DispatchQueue var1, @Block VoidBlock2<SecTrust, SecTrustResultType> var2);

    @Bridge(symbol="SecTrustGetTrustResult", optional=true)
    protected native OSStatus getTrustResult0(IntPtr var1);

    @Bridge(symbol="SecTrustCopyPublicKey", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public native SecKey getPublicKey();

    @Bridge(symbol="SecTrustGetCertificateCount", optional=true)
    @MachineSizedSInt
    public native long getCertificateCount();

    @Bridge(symbol="SecTrustGetCertificateAtIndex", optional=true)
    public native SecCertificate getCertificate(@MachineSizedSInt long var1);

    @Bridge(symbol="SecTrustCopyExceptions", optional=true)
    @Marshaler(value=NSObject.NoRetainMarshaler.class)
    public native NSData getExceptions();

    @Bridge(symbol="SecTrustSetExceptions", optional=true)
    public native boolean setExceptions(NSData var1);

    @Bridge(symbol="SecTrustCopyProperties", optional=true)
    public native SecTrustProperties getProperties();

    @Bridge(symbol="SecTrustCopyResult", optional=true)
    public native SecTrustResult getResult();

    @Bridge(symbol="SecTrustSetOCSPResponse", optional=true)
    protected native OSStatus setOCSPResponse0(CFType var1);

    static {
        Bro.bind(SecTrust.class);
    }

    public static class SecTrustPtr
    extends Ptr<SecTrust, SecTrustPtr> {
    }
}

