/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.security;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.security.SecImportExportOptions;
import org.robovm.apple.security.SecImportItem;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;

@Library(value="Security")
public class SecImportExport
extends CocoaUtility {
    public static List<SecImportItem> importPKCS12(NSData pkcs12_data, SecImportExportOptions options) throws OSStatusException {
        CFArray.CFArrayPtr ptr = new CFArray.CFArrayPtr();
        OSStatus status = SecImportExport.importPKCS120(pkcs12_data, options, ptr);
        OSStatusException.throwIfNecessary(status);
        CFArray arr = (CFArray)ptr.get();
        if (arr == null) {
            return null;
        }
        ArrayList<SecImportItem> list = new ArrayList<SecImportItem>();
        int i = 0;
        while ((long)i < arr.size()) {
            list.add(new SecImportItem(arr.get(i, CFDictionary.class)));
            ++i;
        }
        return list;
    }

    @Bridge(symbol="SecPKCS12Import", optional=true)
    protected static native OSStatus importPKCS120(NSData var0, SecImportExportOptions var1, CFArray.CFArrayPtr var2);

    static {
        Bro.bind(SecImportExport.class);
    }
}

