/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.security;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFBoolean;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.localauthentication.LAContext;
import org.robovm.apple.security.SecAccessControl;
import org.robovm.apple.security.SecAttrAccessible;
import org.robovm.apple.security.SecAttrAuthenticationType;
import org.robovm.apple.security.SecAttrKeyClass;
import org.robovm.apple.security.SecAttrKeyType;
import org.robovm.apple.security.SecAttrProtocol;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="Security")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class SecAttributes
extends CFDictionaryWrapper {
    SecAttributes(CFDictionary data) {
        super(data);
    }

    public SecAttributes() {
    }

    public boolean has(CFType key) {
        return this.data.containsKey(key);
    }

    public <T extends NativeObject> T get(CFType key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get(key, type);
        }
        return null;
    }

    public SecAttributes set(CFType key, NativeObject value) {
        this.data.put(key, value);
        return this;
    }

    public SecAttrAccessible getAccessible() {
        if (this.has(Keys.Accessible())) {
            CFType val = this.get(Keys.Accessible(), CFType.class);
            return SecAttrAccessible.valueOf(val);
        }
        return null;
    }

    public SecAttributes setAccessible(SecAttrAccessible accessible) {
        this.set(Keys.Accessible(), (NativeObject)accessible.value());
        return this;
    }

    public SecAccessControl getAccessControl() {
        if (this.has(Keys.AccessControl())) {
            SecAccessControl val = this.get(Keys.AccessControl(), SecAccessControl.class);
            return val;
        }
        return null;
    }

    public SecAttributes setAccessControl(SecAccessControl accessControl) {
        this.set(Keys.AccessControl(), accessControl);
        return this;
    }

    public String getAccessGroup() {
        if (this.has(Keys.AccessGroup())) {
            CFString val = this.get(Keys.AccessGroup(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public SecAttributes setAccessGroup(String accessGroup) {
        this.set(Keys.AccessGroup(), new CFString(accessGroup));
        return this;
    }

    public boolean isSynchronizable() {
        if (this.has(Keys.Synchronizable())) {
            CFBoolean val = this.get(Keys.Synchronizable(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public SecAttributes setSynchronizable(boolean synchronizable) {
        this.set(Keys.Synchronizable(), CFBoolean.valueOf(synchronizable));
        return this;
    }

    public NSDate getCreationDate() {
        if (this.has(Keys.CreationDate())) {
            NSDate val = this.get(Keys.CreationDate(), NSDate.class);
            return val;
        }
        return null;
    }

    public SecAttributes setCreationDate(NSDate creationDate) {
        this.set(Keys.CreationDate(), (NativeObject)creationDate);
        return this;
    }

    public NSDate getModificationDate() {
        if (this.has(Keys.ModificationDate())) {
            NSDate val = this.get(Keys.ModificationDate(), NSDate.class);
            return val;
        }
        return null;
    }

    public SecAttributes setModificationDate(NSDate modificationDate) {
        this.set(Keys.ModificationDate(), (NativeObject)modificationDate);
        return this;
    }

    public String getDescription() {
        if (this.has(Keys.Description())) {
            CFString val = this.get(Keys.Description(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public SecAttributes setDescription(String description) {
        this.set(Keys.Description(), new CFString(description));
        return this;
    }

    public String getComment() {
        if (this.has(Keys.Comment())) {
            CFString val = this.get(Keys.Comment(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public SecAttributes setComment(String comment) {
        this.set(Keys.Comment(), new CFString(comment));
        return this;
    }

    public long getCreator() {
        if (this.has(Keys.Creator())) {
            CFNumber val = this.get(Keys.Creator(), CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public SecAttributes setCreator(long creator) {
        this.set(Keys.Creator(), CFNumber.valueOf(creator));
        return this;
    }

    public long getType() {
        if (this.has(Keys.Type())) {
            CFNumber val = this.get(Keys.Type(), CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public SecAttributes setType(long type) {
        this.set(Keys.Type(), CFNumber.valueOf(type));
        return this;
    }

    public String getLabel() {
        if (this.has(Keys.Label())) {
            CFString val = this.get(Keys.Label(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public SecAttributes setLabel(String label) {
        this.set(Keys.Label(), new CFString(label));
        return this;
    }

    public boolean isInvisible() {
        if (this.has(Keys.IsInvisible())) {
            CFBoolean val = this.get(Keys.IsInvisible(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public SecAttributes setIsInvisible(boolean isInvisible) {
        this.set(Keys.IsInvisible(), CFBoolean.valueOf(isInvisible));
        return this;
    }

    public boolean isNegative() {
        if (this.has(Keys.IsNegative())) {
            CFBoolean val = this.get(Keys.IsNegative(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public SecAttributes setIsNegative(boolean isNegative) {
        this.set(Keys.IsNegative(), CFBoolean.valueOf(isNegative));
        return this;
    }

    public String getAccount() {
        if (this.has(Keys.Account())) {
            CFString val = this.get(Keys.Account(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public SecAttributes setAccount(String account) {
        this.set(Keys.Account(), new CFString(account));
        return this;
    }

    public String getService() {
        if (this.has(Keys.Service())) {
            CFString val = this.get(Keys.Service(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public SecAttributes setService(String service) {
        this.set(Keys.Service(), new CFString(service));
        return this;
    }

    public NSData getGeneric() {
        if (this.has(Keys.Generic())) {
            NSData val = this.get(Keys.Generic(), NSData.class);
            return val;
        }
        return null;
    }

    public SecAttributes setGeneric(NSData generic) {
        this.set(Keys.Generic(), (NativeObject)generic);
        return this;
    }

    public String getSecurityDomain() {
        if (this.has(Keys.SecurityDomain())) {
            CFString val = this.get(Keys.SecurityDomain(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public SecAttributes setSecurityDomain(String securityDomain) {
        this.set(Keys.SecurityDomain(), new CFString(securityDomain));
        return this;
    }

    public String getServer() {
        if (this.has(Keys.Server())) {
            CFString val = this.get(Keys.Server(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public SecAttributes setServer(String server) {
        this.set(Keys.Server(), new CFString(server));
        return this;
    }

    public SecAttrProtocol getProtocol() {
        if (this.has(Keys.Protocol())) {
            CFType val = this.get(Keys.Protocol(), CFType.class);
            return SecAttrProtocol.valueOf(val);
        }
        return null;
    }

    public SecAttributes setProtocol(SecAttrProtocol protocol) {
        this.set(Keys.Protocol(), (NativeObject)protocol.value());
        return this;
    }

    public SecAttrAuthenticationType getAuthenticationType() {
        if (this.has(Keys.AuthenticationType())) {
            CFType val = this.get(Keys.AuthenticationType(), CFType.class);
            return SecAttrAuthenticationType.valueOf(val);
        }
        return null;
    }

    public SecAttributes setAuthenticationType(SecAttrAuthenticationType authenticationType) {
        this.set(Keys.AuthenticationType(), (NativeObject)authenticationType.value());
        return this;
    }

    public int getPort() {
        if (this.has(Keys.Port())) {
            CFNumber val = this.get(Keys.Port(), CFNumber.class);
            return val.intValue();
        }
        return 0;
    }

    public SecAttributes setPort(int port) {
        this.set(Keys.Port(), CFNumber.valueOf(port));
        return this;
    }

    public String getPath() {
        if (this.has(Keys.Path())) {
            CFString val = this.get(Keys.Path(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public SecAttributes setPath(String path) {
        this.set(Keys.Path(), new CFString(path));
        return this;
    }

    public NSData getSubject() {
        if (this.has(Keys.Subject())) {
            NSData val = this.get(Keys.Subject(), NSData.class);
            return val;
        }
        return null;
    }

    public SecAttributes setSubject(NSData subject) {
        this.set(Keys.Subject(), (NativeObject)subject);
        return this;
    }

    public NSData getIssuer() {
        if (this.has(Keys.Issuer())) {
            NSData val = this.get(Keys.Issuer(), NSData.class);
            return val;
        }
        return null;
    }

    public SecAttributes setIssuer(NSData issuer) {
        this.set(Keys.Issuer(), (NativeObject)issuer);
        return this;
    }

    public NSData getSerialNumber() {
        if (this.has(Keys.SerialNumber())) {
            NSData val = this.get(Keys.SerialNumber(), NSData.class);
            return val;
        }
        return null;
    }

    public SecAttributes setSerialNumber(NSData serialNumber) {
        this.set(Keys.SerialNumber(), (NativeObject)serialNumber);
        return this;
    }

    public NSData getSubjectKeyID() {
        if (this.has(Keys.SubjectKeyID())) {
            NSData val = this.get(Keys.SubjectKeyID(), NSData.class);
            return val;
        }
        return null;
    }

    public SecAttributes setSubjectKeyID(NSData subjectKeyID) {
        this.set(Keys.SubjectKeyID(), (NativeObject)subjectKeyID);
        return this;
    }

    public NSData getPublicKeyHash() {
        if (this.has(Keys.PublicKeyHash())) {
            NSData val = this.get(Keys.PublicKeyHash(), NSData.class);
            return val;
        }
        return null;
    }

    public SecAttributes setPublicKeyHash(NSData publicKeyHash) {
        this.set(Keys.PublicKeyHash(), (NativeObject)publicKeyHash);
        return this;
    }

    public long getCertificateType() {
        if (this.has(Keys.CertificateType())) {
            CFNumber val = this.get(Keys.CertificateType(), CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public SecAttributes setCertificateType(long certificateType) {
        this.set(Keys.CertificateType(), CFNumber.valueOf(certificateType));
        return this;
    }

    public long getCertificateEncoding() {
        if (this.has(Keys.CertificateEncoding())) {
            CFNumber val = this.get(Keys.CertificateEncoding(), CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public SecAttributes setCertificateEncoding(long certificateEncoding) {
        this.set(Keys.CertificateEncoding(), CFNumber.valueOf(certificateEncoding));
        return this;
    }

    public SecAttrKeyClass getKeyClass() {
        if (this.has(Keys.KeyClass())) {
            CFType val = this.get(Keys.KeyClass(), CFType.class);
            return SecAttrKeyClass.valueOf(val);
        }
        return null;
    }

    public SecAttributes setKeyClass(SecAttrKeyClass keyClass) {
        this.set(Keys.KeyClass(), (NativeObject)keyClass.value());
        return this;
    }

    public String getApplicationLabel() {
        if (this.has(Keys.ApplicationLabel())) {
            CFString val = this.get(Keys.ApplicationLabel(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public SecAttributes setApplicationLabel(String applicationLabel) {
        this.set(Keys.ApplicationLabel(), new CFString(applicationLabel));
        return this;
    }

    public boolean isPermanent() {
        if (this.has(Keys.IsPermanent())) {
            CFBoolean val = this.get(Keys.IsPermanent(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public SecAttributes setIsPermanent(boolean isPermanent) {
        this.set(Keys.IsPermanent(), CFBoolean.valueOf(isPermanent));
        return this;
    }

    public NSData getApplicationTag() {
        if (this.has(Keys.ApplicationTag())) {
            NSData val = this.get(Keys.ApplicationTag(), NSData.class);
            return val;
        }
        return null;
    }

    public SecAttributes setApplicationTag(NSData applicationTag) {
        this.set(Keys.ApplicationTag(), (NativeObject)applicationTag);
        return this;
    }

    public SecAttrKeyType getKeyType() {
        if (this.has(Keys.KeyType())) {
            CFType val = this.get(Keys.KeyType(), CFType.class);
            return SecAttrKeyType.valueOf(val);
        }
        return null;
    }

    public SecAttributes setKeyType(SecAttrKeyType keyType) {
        this.set(Keys.KeyType(), (NativeObject)keyType.value());
        return this;
    }

    public long getKeySizeInBits() {
        if (this.has(Keys.KeySizeInBits())) {
            CFNumber val = this.get(Keys.KeySizeInBits(), CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public SecAttributes setKeySizeInBits(long keySizeInBits) {
        this.set(Keys.KeySizeInBits(), CFNumber.valueOf(keySizeInBits));
        return this;
    }

    public int getEffectiveKeySize() {
        if (this.has(Keys.EffectiveKeySize())) {
            CFNumber val = this.get(Keys.EffectiveKeySize(), CFNumber.class);
            return val.intValue();
        }
        return 0;
    }

    public SecAttributes setEffectiveKeySize(int effectiveKeySize) {
        this.set(Keys.EffectiveKeySize(), CFNumber.valueOf(effectiveKeySize));
        return this;
    }

    public boolean canEncrypt() {
        if (this.has(Keys.CanEncrypt())) {
            CFBoolean val = this.get(Keys.CanEncrypt(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public SecAttributes setCanEncrypt(boolean canEncrypt) {
        this.set(Keys.CanEncrypt(), CFBoolean.valueOf(canEncrypt));
        return this;
    }

    public boolean canDecrypt() {
        if (this.has(Keys.CanDecrypt())) {
            CFBoolean val = this.get(Keys.CanDecrypt(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public SecAttributes setCanDecrypt(boolean canDecrypt) {
        this.set(Keys.CanDecrypt(), CFBoolean.valueOf(canDecrypt));
        return this;
    }

    public boolean canDerive() {
        if (this.has(Keys.CanDerive())) {
            CFBoolean val = this.get(Keys.CanDerive(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public SecAttributes setCanDerive(boolean canDerive) {
        this.set(Keys.CanDerive(), CFBoolean.valueOf(canDerive));
        return this;
    }

    public boolean canSign() {
        if (this.has(Keys.CanSign())) {
            CFBoolean val = this.get(Keys.CanSign(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public SecAttributes setCanSign(boolean canSign) {
        this.set(Keys.CanSign(), CFBoolean.valueOf(canSign));
        return this;
    }

    public boolean canVerify() {
        if (this.has(Keys.CanVerify())) {
            CFBoolean val = this.get(Keys.CanVerify(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public SecAttributes setCanVerify(boolean canVerify) {
        this.set(Keys.CanVerify(), CFBoolean.valueOf(canVerify));
        return this;
    }

    public boolean canWrap() {
        if (this.has(Keys.CanWrap())) {
            CFBoolean val = this.get(Keys.CanWrap(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public SecAttributes setCanWrap(boolean canWrap) {
        this.set(Keys.CanWrap(), CFBoolean.valueOf(canWrap));
        return this;
    }

    public boolean canUnwrap() {
        if (this.has(Keys.CanUnwrap())) {
            CFBoolean val = this.get(Keys.CanUnwrap(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public SecAttributes setCanUnwrap(boolean canUnwrap) {
        this.set(Keys.CanUnwrap(), CFBoolean.valueOf(canUnwrap));
        return this;
    }

    public List<CFType> getItemList() {
        if (this.has(Keys.UseItemList())) {
            CFArray val = this.get(Keys.UseItemList(), CFArray.class);
            return val.toList(CFType.class);
        }
        return null;
    }

    public SecAttributes setItemList(List<CFType> itemList) {
        this.set(Keys.UseItemList(), CFArray.create(itemList));
        return this;
    }

    public String getOperationPrompt() {
        if (this.has(Keys.UseOperationPrompt())) {
            CFString val = this.get(Keys.UseOperationPrompt(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public SecAttributes setOperationPrompt(String operationPrompt) {
        this.set(Keys.UseOperationPrompt(), new CFString(operationPrompt));
        return this;
    }

    @Deprecated
    public boolean usesNoAuthenticationUI() {
        if (this.has(Keys.UseNoAuthenticationUI())) {
            CFBoolean val = this.get(Keys.UseNoAuthenticationUI(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    @Deprecated
    public SecAttributes setUsesNoAuthenticationUI(boolean usesNoAuthenticationUI) {
        this.set(Keys.UseNoAuthenticationUI(), CFBoolean.valueOf(usesNoAuthenticationUI));
        return this;
    }

    public boolean usesAuthenticationUI() {
        if (this.has(Keys.UseAuthenticationUI())) {
            CFBoolean val = this.get(Keys.UseAuthenticationUI(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public SecAttributes setUsesAuthenticationUI(boolean usesAuthenticationUI) {
        this.set(Keys.UseAuthenticationUI(), CFBoolean.valueOf(usesAuthenticationUI));
        return this;
    }

    public LAContext getUseAuthenticationContext() {
        if (this.has(Keys.UseAuthenticationContext())) {
            LAContext val = this.get(Keys.UseAuthenticationContext(), LAContext.class);
            return val;
        }
        return null;
    }

    public SecAttributes setUseAuthenticationContext(LAContext useAuthenticationContext) {
        this.set(Keys.UseAuthenticationContext(), (NativeObject)useAuthenticationContext);
        return this;
    }

    @Library(value="Security")
    public static class Keys {
        @GlobalValue(symbol="kSecAttrAccessible", optional=true)
        public static native CFType Accessible();

        @GlobalValue(symbol="kSecAttrAccessControl", optional=true)
        public static native CFType AccessControl();

        @GlobalValue(symbol="kSecAttrAccessGroup", optional=true)
        public static native CFType AccessGroup();

        @GlobalValue(symbol="kSecAttrSynchronizable", optional=true)
        public static native CFType Synchronizable();

        @GlobalValue(symbol="kSecAttrCreationDate", optional=true)
        public static native CFType CreationDate();

        @GlobalValue(symbol="kSecAttrModificationDate", optional=true)
        public static native CFType ModificationDate();

        @GlobalValue(symbol="kSecAttrDescription", optional=true)
        public static native CFType Description();

        @GlobalValue(symbol="kSecAttrComment", optional=true)
        public static native CFType Comment();

        @GlobalValue(symbol="kSecAttrCreator", optional=true)
        public static native CFType Creator();

        @GlobalValue(symbol="kSecAttrType", optional=true)
        public static native CFType Type();

        @GlobalValue(symbol="kSecAttrLabel", optional=true)
        public static native CFType Label();

        @GlobalValue(symbol="kSecAttrIsInvisible", optional=true)
        public static native CFType IsInvisible();

        @GlobalValue(symbol="kSecAttrIsNegative", optional=true)
        public static native CFType IsNegative();

        @GlobalValue(symbol="kSecAttrAccount", optional=true)
        public static native CFType Account();

        @GlobalValue(symbol="kSecAttrService", optional=true)
        public static native CFType Service();

        @GlobalValue(symbol="kSecAttrGeneric", optional=true)
        public static native CFType Generic();

        @GlobalValue(symbol="kSecAttrSecurityDomain", optional=true)
        public static native CFType SecurityDomain();

        @GlobalValue(symbol="kSecAttrServer", optional=true)
        public static native CFType Server();

        @GlobalValue(symbol="kSecAttrProtocol", optional=true)
        public static native CFType Protocol();

        @GlobalValue(symbol="kSecAttrAuthenticationType", optional=true)
        public static native CFType AuthenticationType();

        @GlobalValue(symbol="kSecAttrPort", optional=true)
        public static native CFType Port();

        @GlobalValue(symbol="kSecAttrPath", optional=true)
        public static native CFType Path();

        @GlobalValue(symbol="kSecAttrSubject", optional=true)
        public static native CFType Subject();

        @GlobalValue(symbol="kSecAttrIssuer", optional=true)
        public static native CFType Issuer();

        @GlobalValue(symbol="kSecAttrSerialNumber", optional=true)
        public static native CFType SerialNumber();

        @GlobalValue(symbol="kSecAttrSubjectKeyID", optional=true)
        public static native CFType SubjectKeyID();

        @GlobalValue(symbol="kSecAttrPublicKeyHash", optional=true)
        public static native CFType PublicKeyHash();

        @GlobalValue(symbol="kSecAttrCertificateType", optional=true)
        public static native CFType CertificateType();

        @GlobalValue(symbol="kSecAttrCertificateEncoding", optional=true)
        public static native CFType CertificateEncoding();

        @GlobalValue(symbol="kSecAttrKeyClass", optional=true)
        public static native CFType KeyClass();

        @GlobalValue(symbol="kSecAttrApplicationLabel", optional=true)
        public static native CFType ApplicationLabel();

        @GlobalValue(symbol="kSecAttrIsPermanent", optional=true)
        public static native CFType IsPermanent();

        @GlobalValue(symbol="kSecAttrIsSensitive", optional=true)
        public static native CFType IsSensitive();

        @GlobalValue(symbol="kSecAttrIsExtractable", optional=true)
        public static native CFType IsExtractable();

        @GlobalValue(symbol="kSecAttrApplicationTag", optional=true)
        public static native CFType ApplicationTag();

        @GlobalValue(symbol="kSecAttrKeyType", optional=true)
        public static native CFType KeyType();

        @GlobalValue(symbol="kSecAttrKeySizeInBits", optional=true)
        public static native CFType KeySizeInBits();

        @GlobalValue(symbol="kSecAttrEffectiveKeySize", optional=true)
        public static native CFType EffectiveKeySize();

        @GlobalValue(symbol="kSecAttrCanEncrypt", optional=true)
        public static native CFType CanEncrypt();

        @GlobalValue(symbol="kSecAttrCanDecrypt", optional=true)
        public static native CFType CanDecrypt();

        @GlobalValue(symbol="kSecAttrCanDerive", optional=true)
        public static native CFType CanDerive();

        @GlobalValue(symbol="kSecAttrCanSign", optional=true)
        public static native CFType CanSign();

        @GlobalValue(symbol="kSecAttrCanVerify", optional=true)
        public static native CFType CanVerify();

        @GlobalValue(symbol="kSecAttrCanWrap", optional=true)
        public static native CFType CanWrap();

        @GlobalValue(symbol="kSecAttrCanUnwrap", optional=true)
        public static native CFType CanUnwrap();

        @GlobalValue(symbol="kSecAttrSyncViewHint", optional=true)
        public static native CFType SyncViewHint();

        @GlobalValue(symbol="kSecAttrTokenID", optional=true)
        public static native CFType TokenID();

        @GlobalValue(symbol="kSecAttrPersistantReference", optional=true)
        public static native CFType PersistantReference();

        @GlobalValue(symbol="kSecAttrPersistentReference", optional=true)
        public static native CFType PersistentReference();

        @GlobalValue(symbol="kSecUseItemList", optional=true)
        public static native CFType UseItemList();

        @GlobalValue(symbol="kSecUseOperationPrompt", optional=true)
        public static native CFType UseOperationPrompt();

        @Deprecated
        @GlobalValue(symbol="kSecUseNoAuthenticationUI", optional=true)
        public static native CFType UseNoAuthenticationUI();

        @GlobalValue(symbol="kSecUseAuthenticationUI", optional=true)
        public static native CFType UseAuthenticationUI();

        @GlobalValue(symbol="kSecUseAuthenticationContext", optional=true)
        public static native CFType UseAuthenticationContext();

        @GlobalValue(symbol="kSecAttrTokenIDSecureEnclave", optional=true)
        public static native CFType TokenIDSecureEnclave();

        @GlobalValue(symbol="kSecAttrAccessGroupToken", optional=true)
        public static native CFType AccessGroupToken();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<SecAttributes> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(CFArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<SecAttributes> list = new ArrayList<SecAttributes>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new SecAttributes(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<SecAttributes> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (SecAttributes i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static SecAttributes toObject(Class<SecAttributes> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new SecAttributes(o);
        }

        @MarshalsPointer
        public static long toNative(SecAttributes o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

