/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.passkit;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.passkit.PKPass;
import org.robovm.apple.passkit.PKRemovedPassInfo;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="PassKit")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class PKPassLibraryNotification
extends NSDictionaryWrapper {
    PKPassLibraryNotification(NSDictionary data) {
        super(data);
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public NSArray<PKPass> getAddedPasses() {
        if (this.has(Keys.AddedPasses())) {
            NSArray val = (NSArray)this.get(Keys.AddedPasses());
            return val;
        }
        return null;
    }

    public NSArray<PKPass> getReplacementPasses() {
        if (this.has(Keys.ReplacementPasses())) {
            NSArray val = (NSArray)this.get(Keys.ReplacementPasses());
            return val;
        }
        return null;
    }

    public List<PKRemovedPassInfo> getRemovedPassInfos() {
        if (this.has(Keys.RemovedPassInfos())) {
            NSArray val = (NSArray)this.get(Keys.RemovedPassInfos());
            ArrayList<PKRemovedPassInfo> list = new ArrayList<PKRemovedPassInfo>();
            for (NSDictionary v : val) {
                list.add(new PKRemovedPassInfo(v));
            }
            return list;
        }
        return null;
    }

    @Library(value="PassKit")
    public static class Keys {
        @GlobalValue(symbol="PKPassLibraryAddedPassesUserInfoKey", optional=true)
        public static native NSString AddedPasses();

        @GlobalValue(symbol="PKPassLibraryReplacementPassesUserInfoKey", optional=true)
        public static native NSString ReplacementPasses();

        @GlobalValue(symbol="PKPassLibraryRemovedPassInfosUserInfoKey", optional=true)
        public static native NSString RemovedPassInfos();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<PKPassLibraryNotification> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<PKPassLibraryNotification> list = new ArrayList<PKPassLibraryNotification>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new PKPassLibraryNotification((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<PKPassLibraryNotification> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (PKPassLibraryNotification i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static PKPassLibraryNotification toObject(Class<PKPassLibraryNotification> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new PKPassLibraryNotification(o);
        }

        @MarshalsPointer
        public static long toNative(PKPassLibraryNotification o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

