/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.metalkit;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.metal.MTLCPUCacheMode;
import org.robovm.apple.metal.MTLTextureUsage;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="MetalKit")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class MTKTextureLoaderOptions
extends NSDictionaryWrapper {
    MTKTextureLoaderOptions(NSDictionary data) {
        super(data);
    }

    public MTKTextureLoaderOptions() {
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public MTKTextureLoaderOptions set(NSString key, NSObject value) {
        this.data.put(key, value);
        return this;
    }

    public boolean isAllocatesMipmaps() {
        if (this.has(Keys.AllocateMipmaps())) {
            NSNumber val = (NSNumber)this.get(Keys.AllocateMipmaps());
            return val.booleanValue();
        }
        return false;
    }

    public MTKTextureLoaderOptions setAllocatesMipmaps(boolean allocatesMipmaps) {
        this.set(Keys.AllocateMipmaps(), NSNumber.valueOf(allocatesMipmaps));
        return this;
    }

    public boolean isSRGB() {
        if (this.has(Keys.SRGB())) {
            NSNumber val = (NSNumber)this.get(Keys.SRGB());
            return val.booleanValue();
        }
        return false;
    }

    public MTKTextureLoaderOptions setSRGB(boolean sRGB) {
        this.set(Keys.SRGB(), NSNumber.valueOf(sRGB));
        return this;
    }

    public MTLTextureUsage getTextureUsage() {
        if (this.has(Keys.TextureUsage())) {
            NSNumber val = (NSNumber)this.get(Keys.TextureUsage());
            return new MTLTextureUsage(val.longValue());
        }
        return null;
    }

    public MTKTextureLoaderOptions setTextureUsage(MTLTextureUsage textureUsage) {
        this.set(Keys.TextureUsage(), NSNumber.valueOf(textureUsage.value()));
        return this;
    }

    public MTLCPUCacheMode getTextureCPUCacheMode() {
        if (this.has(Keys.TextureCPUCacheMode())) {
            NSNumber val = (NSNumber)this.get(Keys.TextureCPUCacheMode());
            return MTLCPUCacheMode.valueOf(val.longValue());
        }
        return null;
    }

    public MTKTextureLoaderOptions setTextureCPUCacheMode(MTLCPUCacheMode textureCPUCacheMode) {
        this.set(Keys.TextureCPUCacheMode(), NSNumber.valueOf(textureCPUCacheMode.value()));
        return this;
    }

    @Library(value="MetalKit")
    public static class Keys {
        @GlobalValue(symbol="MTKTextureLoaderOptionAllocateMipmaps", optional=true)
        public static native NSString AllocateMipmaps();

        @GlobalValue(symbol="MTKTextureLoaderOptionGenerateMipmaps", optional=true)
        public static native NSString GenerateMipmaps();

        @GlobalValue(symbol="MTKTextureLoaderOptionSRGB", optional=true)
        public static native NSString SRGB();

        @GlobalValue(symbol="MTKTextureLoaderOptionTextureUsage", optional=true)
        public static native NSString TextureUsage();

        @GlobalValue(symbol="MTKTextureLoaderOptionTextureCPUCacheMode", optional=true)
        public static native NSString TextureCPUCacheMode();

        @GlobalValue(symbol="MTKTextureLoaderOptionTextureStorageMode", optional=true)
        public static native NSString TextureStorageMode();

        @GlobalValue(symbol="MTKTextureLoaderOptionCubeLayout", optional=true)
        public static native NSString CubeLayout();

        @GlobalValue(symbol="MTKTextureLoaderCubeLayoutVertical", optional=true)
        public static native String CubeLayoutVertical();

        @GlobalValue(symbol="MTKTextureLoaderOptionOrigin", optional=true)
        public static native NSString Origin();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<MTKTextureLoaderOptions> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<MTKTextureLoaderOptions> list = new ArrayList<MTKTextureLoaderOptions>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new MTKTextureLoaderOptions((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<MTKTextureLoaderOptions> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (MTKTextureLoaderOptions i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static MTKTextureLoaderOptions toObject(Class<MTKTextureLoaderOptions> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new MTKTextureLoaderOptions(o);
        }

        @MarshalsPointer
        public static long toNative(MTKTextureLoaderOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

