/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.metalkit;

import org.robovm.apple.coregraphics.CGImage;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSBundle;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.metal.MTLDevice;
import org.robovm.apple.metal.MTLTexture;
import org.robovm.apple.metalkit.MTKTextureLoaderOptions;
import org.robovm.apple.modelio.MDLTexture;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="MetalKit")
@NativeClass
public class MTKTextureLoader
extends NSObject {
    protected MTKTextureLoader() {
    }

    protected MTKTextureLoader(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected MTKTextureLoader(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithDevice:")
    public MTKTextureLoader(MTLDevice device) {
        super(null);
        this.initObject(this.init(device));
    }

    @Property(selector="device")
    public native MTLDevice getDevice();

    @Method(selector="initWithDevice:")
    @Pointer
    protected native long init(MTLDevice var1);

    @Method(selector="newTextureWithContentsOfURL:options:completionHandler:")
    public native void newTexture(NSURL var1, MTKTextureLoaderOptions var2, @Block VoidBlock2<MTLTexture, NSError> var3);

    @Method(selector="newTextureWithName:scaleFactor:bundle:options:completionHandler:")
    public native void newTexture(String var1, @MachineSizedFloat double var2, NSBundle var4, MTKTextureLoaderOptions var5, @Block VoidBlock2<MTLTexture, NSError> var6);

    @Method(selector="newTexturesWithContentsOfURLs:options:completionHandler:")
    public native void newTexture(NSArray<NSURL> var1, MTKTextureLoaderOptions var2, @Block VoidBlock2<NSArray<?>, NSError> var3);

    @Method(selector="newTexturesWithNames:scaleFactor:bundle:options:completionHandler:")
    public native void newTexture(NSArray<NSString> var1, @MachineSizedFloat double var2, NSBundle var4, MTKTextureLoaderOptions var5, @Block VoidBlock2<NSArray<?>, NSError> var6);

    @Method(selector="newTextureWithData:options:completionHandler:")
    public native void newTexture(NSData var1, MTKTextureLoaderOptions var2, @Block VoidBlock2<MTLTexture, NSError> var3);

    @Method(selector="newTextureWithCGImage:options:completionHandler:")
    public native void newTexture(CGImage var1, MTKTextureLoaderOptions var2, @Block VoidBlock2<MTLTexture, NSError> var3);

    @Method(selector="newTextureWithMDLTexture:options:completionHandler:")
    public native void newTexture(MDLTexture var1, MTKTextureLoaderOptions var2, @Block VoidBlock2<MTLTexture, NSError> var3);

    public MTLTexture newTexture(NSURL URL2, MTKTextureLoaderOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLTexture result = this.newTexture(URL2, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newTextureWithContentsOfURL:options:error:")
    private native MTLTexture newTexture(NSURL var1, MTKTextureLoaderOptions var2, NSError.NSErrorPtr var3);

    public NSArray<?> newTextures(NSArray<NSURL> URLs, MTKTextureLoaderOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSArray<?> result = this.newTextures(URLs, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newTexturesWithContentsOfURLs:options:error:")
    private native NSArray<?> newTextures(NSArray<NSURL> var1, MTKTextureLoaderOptions var2, NSError.NSErrorPtr var3);

    public MTLTexture newTexture(NSData data, MTKTextureLoaderOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLTexture result = this.newTexture(data, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newTextureWithData:options:error:")
    private native MTLTexture newTexture(NSData var1, MTKTextureLoaderOptions var2, NSError.NSErrorPtr var3);

    public MTLTexture newTexture(CGImage cgImage, MTKTextureLoaderOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLTexture result = this.newTexture(cgImage, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newTextureWithCGImage:options:error:")
    private native MTLTexture newTexture(CGImage var1, MTKTextureLoaderOptions var2, NSError.NSErrorPtr var3);

    public MTLTexture newTexture(MDLTexture texture, MTKTextureLoaderOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLTexture result = this.newTexture(texture, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newTextureWithMDLTexture:options:error:")
    private native MTLTexture newTexture(MDLTexture var1, MTKTextureLoaderOptions var2, NSError.NSErrorPtr var3);

    public MTLTexture newTexture(String name, @MachineSizedFloat double scaleFactor, NSBundle bundle, MTKTextureLoaderOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLTexture result = this.newTexture(name, scaleFactor, bundle, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newTextureWithName:scaleFactor:bundle:options:error:")
    private native MTLTexture newTexture(String var1, @MachineSizedFloat double var2, NSBundle var4, MTKTextureLoaderOptions var5, NSError.NSErrorPtr var6);

    static {
        ObjCRuntime.bind(MTKTextureLoader.class);
    }

    public static class MTKTextureLoaderPtr
    extends Ptr<MTKTextureLoader, MTKTextureLoaderPtr> {
    }
}

