/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.metal;

import java.nio.ByteBuffer;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSRange;
import org.robovm.apple.metal.MTLCPUCacheMode;
import org.robovm.apple.metal.MTLDevice;
import org.robovm.apple.metal.MTLHeap;
import org.robovm.apple.metal.MTLPurgeableState;
import org.robovm.apple.metal.MTLResource;
import org.robovm.apple.metal.MTLStorageMode;
import org.robovm.apple.metal.MTLTexture;
import org.robovm.apple.metal.MTLTextureDescriptor;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeProtocolProxy;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.VM;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Metal")
@NativeProtocolProxy
public final class MTLBuffer
extends NSObject
implements MTLResource {
    @Property(selector="length")
    @MachineSizedUInt
    public native long getLength();

    @Override
    @Property(selector="label")
    public native String getLabel();

    @Override
    @Property(selector="setLabel:")
    public native void setLabel(String var1);

    @Override
    @Property(selector="device")
    public native MTLDevice getDevice();

    @Override
    @Property(selector="cpuCacheMode")
    public native MTLCPUCacheMode getCpuCacheMode();

    @Override
    @Property(selector="storageMode")
    public native MTLStorageMode getStorageMode();

    @Override
    @Property(selector="heap")
    public native MTLHeap getHeap();

    @Override
    @Property(selector="allocatedSize")
    @MachineSizedUInt
    public native long getAllocatedSize();

    public ByteBuffer getContents() {
        return VM.newDirectByteBuffer((long)this.getContents0(), (long)((int)this.getLength()));
    }

    @Method(selector="contents")
    @Pointer
    protected native long getContents0();

    @Method(selector="newTextureWithDescriptor:offset:bytesPerRow:")
    @Marshaler(value=NSObject.NoRetainMarshaler.class)
    public native MTLTexture newTexture(MTLTextureDescriptor var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4);

    @Method(selector="addDebugMarker:range:")
    public native void addDebugMarker(String var1, @ByVal NSRange var2);

    @Method(selector="removeAllDebugMarkers")
    public native void removeAllDebugMarkers();

    @Override
    @Method(selector="setPurgeableState:")
    public native MTLPurgeableState setPurgeableState(MTLPurgeableState var1);

    @Override
    @Method(selector="makeAliasable")
    public native void makeAliasable();

    @Override
    @Method(selector="isAliasable")
    public native boolean isAliasable();

    static {
        ObjCRuntime.bind(MTLBuffer.class);
    }

    public static class MTLBufferPtr
    extends Ptr<MTLBuffer, MTLBufferPtr> {
    }
}

