/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.mediatoolbox;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.coreaudio.AudioBufferList;
import org.robovm.apple.coreaudio.AudioStreamBasicDescription;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.coremedia.CMTimeRange;
import org.robovm.apple.mediatoolbox.MTAudioProcessingTapCallbacksStruct;
import org.robovm.apple.mediatoolbox.MTAudioProcessingTapCreationFlags;
import org.robovm.apple.mediatoolbox.MTAudioProcessingTapFlags;
import org.robovm.apple.mediatoolbox.MTAudioProcessingTapMutableFlags;
import org.robovm.objc.LongMap;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.LongPtr;
import org.robovm.rt.bro.ptr.MachineSizedSIntPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="MediaToolbox")
@WeaklyLinked
public class MTAudioProcessingTap
extends CFType {
    private static final AtomicLong callbackId = new AtomicLong();
    private static final LongMap<Callbacks> callbacks = new LongMap();
    private static final Method cbInit;
    private static final Method cbFinalize;
    private static final Method cbPrepare;
    private static final Method cbUnprepare;
    private static final Method cbProcess;
    private CMTimeRange lastTimeRange;

    protected MTAudioProcessingTap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbInit(MTAudioProcessingTap tap, @Pointer long clientInfo, LongPtr.LongPtrPtr tapStorageOut) {
        Callbacks cb = null;
        LongMap<Callbacks> longMap = callbacks;
        synchronized (longMap) {
            cb = (Callbacks)callbacks.get(clientInfo);
        }
        cb.init(tap);
        tapStorageOut.set(clientInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbFinalize(MTAudioProcessingTap tap) {
        long storage = tap.getStorage();
        Callbacks cb = null;
        LongMap<Callbacks> longMap = callbacks;
        synchronized (longMap) {
            cb = (Callbacks)callbacks.remove(storage);
        }
        cb.finalize(tap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbPrepare(MTAudioProcessingTap tap, @MachineSizedSInt long maxFrames, AudioStreamBasicDescription processingFormat) {
        Callbacks cb = null;
        LongMap<Callbacks> longMap = callbacks;
        synchronized (longMap) {
            cb = (Callbacks)callbacks.get(tap.getStorage());
        }
        cb.prepare(tap, maxFrames, processingFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbUnprepare(MTAudioProcessingTap tap) {
        Callbacks cb = null;
        LongMap<Callbacks> longMap = callbacks;
        synchronized (longMap) {
            cb = (Callbacks)callbacks.get(tap.getStorage());
        }
        cb.unprepare(tap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbProcess(MTAudioProcessingTap tap, @MachineSizedSInt long numberFrames, MTAudioProcessingTapMutableFlags flags, AudioBufferList bufferListInOut, MachineSizedSIntPtr numberFramesOut, MTAudioProcessingTapFlags.MTAudioProcessingTapFlagsPtr flagsOut) {
        Callbacks cb = null;
        LongMap<Callbacks> longMap = callbacks;
        synchronized (longMap) {
            cb = (Callbacks)callbacks.get(tap.getStorage());
        }
        long frames = cb.process(tap, numberFrames, flags, bufferListInOut);
        numberFramesOut.set(frames);
        flagsOut.set(flags.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MTAudioProcessingTap create(Callbacks callbacks, MTAudioProcessingTapCreationFlags flags) throws OSStatusException {
        MTAudioProcessingTapPtr ptr = new MTAudioProcessingTapPtr();
        long callbackId = MTAudioProcessingTap.callbackId.getAndIncrement();
        MTAudioProcessingTapCallbacksStruct struct = new MTAudioProcessingTapCallbacksStruct(0, callbackId, new FunctionPtr(cbInit), new FunctionPtr(cbFinalize), new FunctionPtr(cbPrepare), new FunctionPtr(cbUnprepare), new FunctionPtr(cbProcess));
        OSStatus status = MTAudioProcessingTap.create(null, struct, flags, ptr);
        if (OSStatusException.throwIfNecessary(status)) {
            LongMap<Callbacks> longMap = MTAudioProcessingTap.callbacks;
            synchronized (longMap) {
                MTAudioProcessingTap.callbacks.put(callbackId, (Object)callbacks);
            }
            return (MTAudioProcessingTap)ptr.get();
        }
        return null;
    }

    public long getSourceAudio(long numberFrames, AudioBufferList bufferList, MTAudioProcessingTapMutableFlags flags) throws OSStatusException {
        CMTimeRange timeRangePtr = new CMTimeRange();
        MachineSizedSIntPtr numberFramesPtr = new MachineSizedSIntPtr();
        OSStatus status = this.getSourceAudio0(numberFrames, bufferList, flags, timeRangePtr, numberFramesPtr);
        OSStatusException.throwIfNecessary(status);
        this.lastTimeRange = timeRangePtr;
        return numberFramesPtr.get();
    }

    public CMTimeRange getLastTimeRange() {
        return this.lastTimeRange;
    }

    @Bridge(symbol="MTAudioProcessingTapGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="MTAudioProcessingTapCreate", optional=true)
    protected static native OSStatus create(CFAllocator var0, MTAudioProcessingTapCallbacksStruct var1, MTAudioProcessingTapCreationFlags var2, MTAudioProcessingTapPtr var3);

    @Bridge(symbol="MTAudioProcessingTapGetStorage", optional=true)
    @Pointer
    protected native long getStorage();

    @Bridge(symbol="MTAudioProcessingTapGetSourceAudio", optional=true)
    protected native OSStatus getSourceAudio0(@MachineSizedSInt long var1, AudioBufferList var3, MTAudioProcessingTapMutableFlags var4, CMTimeRange var5, MachineSizedSIntPtr var6);

    static {
        try {
            cbInit = MTAudioProcessingTap.class.getDeclaredMethod("cbInit", MTAudioProcessingTap.class, Long.TYPE, LongPtr.LongPtrPtr.class);
            cbFinalize = MTAudioProcessingTap.class.getDeclaredMethod("cbFinalize", MTAudioProcessingTap.class);
            cbPrepare = MTAudioProcessingTap.class.getDeclaredMethod("cbPrepare", MTAudioProcessingTap.class, Long.TYPE, AudioStreamBasicDescription.class);
            cbUnprepare = MTAudioProcessingTap.class.getDeclaredMethod("cbUnprepare", MTAudioProcessingTap.class);
            cbProcess = MTAudioProcessingTap.class.getDeclaredMethod("cbProcess", MTAudioProcessingTap.class, Long.TYPE, MTAudioProcessingTapMutableFlags.class, AudioBufferList.class, MachineSizedSIntPtr.class, MTAudioProcessingTapFlags.MTAudioProcessingTapFlagsPtr.class);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(MTAudioProcessingTap.class);
    }

    public static class MTAudioProcessingTapPtr
    extends Ptr<MTAudioProcessingTap, MTAudioProcessingTapPtr> {
    }

    public static interface Callbacks {
        public void init(MTAudioProcessingTap var1);

        public void finalize(MTAudioProcessingTap var1);

        public void prepare(MTAudioProcessingTap var1, long var2, AudioStreamBasicDescription var4);

        public void unprepare(MTAudioProcessingTap var1);

        public long process(MTAudioProcessingTap var1, long var2, MTAudioProcessingTapMutableFlags var4, AudioBufferList var5);
    }
}

