/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.mediaplayer;

import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.mediaplayer.MPMediaItem;
import org.robovm.apple.mediaplayer.MPMediaItemCollection;
import org.robovm.apple.mediaplayer.MPMediaPlayback;
import org.robovm.apple.mediaplayer.MPMediaQuery;
import org.robovm.apple.mediaplayer.MPMusicPlaybackState;
import org.robovm.apple.mediaplayer.MPMusicPlayerApplicationController;
import org.robovm.apple.mediaplayer.MPMusicPlayerQueueDescriptor;
import org.robovm.apple.mediaplayer.MPMusicRepeatMode;
import org.robovm.apple.mediaplayer.MPMusicShuffleMode;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="MediaPlayer")
@NativeClass
public class MPMusicPlayerController
extends NSObject
implements MPMediaPlayback {
    public MPMusicPlayerController() {
    }

    protected MPMusicPlayerController(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected MPMusicPlayerController(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="applicationMusicPlayer")
    public static native MPMusicPlayerController getApplicationMusicPlayer();

    @Property(selector="applicationQueuePlayer")
    public static native MPMusicPlayerApplicationController getApplicationQueuePlayer();

    @Property(selector="systemMusicPlayer")
    public static native MPMusicPlayerController getSystemMusicPlayer();

    @Deprecated
    @Property(selector="iPodMusicPlayer")
    public static native MPMusicPlayerController getIPodMusicPlayer();

    @Property(selector="playbackState")
    public native MPMusicPlaybackState getPlaybackState();

    @Property(selector="repeatMode")
    public native MPMusicRepeatMode getRepeatMode();

    @Property(selector="setRepeatMode:")
    public native void setRepeatMode(MPMusicRepeatMode var1);

    @Property(selector="shuffleMode")
    public native MPMusicShuffleMode getShuffleMode();

    @Property(selector="setShuffleMode:")
    public native void setShuffleMode(MPMusicShuffleMode var1);

    @Deprecated
    @Property(selector="volume")
    public native float getVolume();

    @Deprecated
    @Property(selector="setVolume:")
    public native void setVolume(float var1);

    @Property(selector="nowPlayingItem")
    public native MPMediaItem getNowPlayingItem();

    @Property(selector="setNowPlayingItem:")
    public native void setNowPlayingItem(MPMediaItem var1);

    @Property(selector="indexOfNowPlayingItem")
    @MachineSizedUInt
    public native long getIndexOfNowPlayingItem();

    @Override
    @Property(selector="isPreparedToPlay")
    public native boolean isPreparedToPlay();

    @Override
    @Property(selector="currentPlaybackTime")
    public native double getCurrentPlaybackTime();

    @Override
    @Property(selector="setCurrentPlaybackTime:")
    public native void setCurrentPlaybackTime(double var1);

    @Override
    @Property(selector="currentPlaybackRate")
    public native float getCurrentPlaybackRate();

    @Override
    @Property(selector="setCurrentPlaybackRate:")
    public native void setCurrentPlaybackRate(float var1);

    @Deprecated
    @GlobalValue(symbol="MPMediaPlaybackIsPreparedToPlayDidChangeNotification", optional=true)
    public static native NSString IsPreparedToPlayDidChangeNotification();

    @GlobalValue(symbol="MPMusicPlayerControllerPlaybackStateDidChangeNotification", optional=true)
    public static native NSString PlaybackStateDidChangeNotification();

    @GlobalValue(symbol="MPMusicPlayerControllerNowPlayingItemDidChangeNotification", optional=true)
    public static native NSString NowPlayingItemDidChangeNotification();

    @GlobalValue(symbol="MPMusicPlayerControllerVolumeDidChangeNotification", optional=true)
    public static native NSString VolumeDidChangeNotification();

    @GlobalValue(symbol="MPMusicPlayerControllerQueueDidChangeNotification", optional=true)
    public static native NSString QueueDidChangeNotification();

    @Method(selector="setQueueWithQuery:")
    public native void setQueue(MPMediaQuery var1);

    @Method(selector="setQueueWithItemCollection:")
    public native void setQueue(MPMediaItemCollection var1);

    @Method(selector="setQueueWithStoreIDs:")
    public native void setQueueWithStoreIDs(NSArray<NSString> var1);

    @Method(selector="setQueueWithDescriptor:")
    public native void setQueueWithDescriptor(MPMusicPlayerQueueDescriptor var1);

    @Method(selector="prependQueueDescriptor:")
    public native void prependQueueDescriptor(MPMusicPlayerQueueDescriptor var1);

    @Method(selector="appendQueueDescriptor:")
    public native void appendQueueDescriptor(MPMusicPlayerQueueDescriptor var1);

    @Method(selector="prepareToPlayWithCompletionHandler:")
    public native void prepareToPlayWithCompletionHandler(@Block VoidBlock1<NSError> var1);

    @Method(selector="skipToNextItem")
    public native void skipToNextItem();

    @Method(selector="skipToBeginning")
    public native void skipToBeginning();

    @Method(selector="skipToPreviousItem")
    public native void skipToPreviousItem();

    @Method(selector="beginGeneratingPlaybackNotifications")
    public native void beginGeneratingPlaybackNotifications();

    @Method(selector="endGeneratingPlaybackNotifications")
    public native void endGeneratingPlaybackNotifications();

    @Override
    @Method(selector="prepareToPlay")
    public native void prepareToPlay();

    @Override
    @Method(selector="play")
    public native void play();

    @Override
    @Method(selector="pause")
    public native void pause();

    @Override
    @Method(selector="stop")
    public native void stop();

    @Override
    @Method(selector="beginSeekingForward")
    public native void beginSeekingForward();

    @Override
    @Method(selector="beginSeekingBackward")
    public native void beginSeekingBackward();

    @Override
    @Method(selector="endSeeking")
    public native void endSeeking();

    static {
        ObjCRuntime.bind(MPMusicPlayerController.class);
    }

    public static class MPMusicPlayerControllerPtr
    extends Ptr<MPMusicPlayerController, MPMusicPlayerControllerPtr> {
    }

    public static class Notifications {
        public static NSObject observeIsPreparedToPlayDidChange(MPMusicPlayerController object, final VoidBlock1<MPMediaPlayback> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(MPMusicPlayerController.IsPreparedToPlayDidChangeNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((MPMediaPlayback)((Object)a.getObject())));
                }
            });
        }

        public static NSObject observePlaybackStateDidChange(MPMusicPlayerController object, final VoidBlock1<MPMusicPlayerController> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(MPMusicPlayerController.PlaybackStateDidChangeNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((MPMusicPlayerController)a.getObject()));
                }
            });
        }

        public static NSObject observeNowPlayingItemDidChange(MPMusicPlayerController object, final VoidBlock1<MPMusicPlayerController> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(MPMusicPlayerController.NowPlayingItemDidChangeNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((MPMusicPlayerController)a.getObject()));
                }
            });
        }

        public static NSObject observeVolumeDidChange(MPMusicPlayerController object, final VoidBlock1<MPMusicPlayerController> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(MPMusicPlayerController.VolumeDidChangeNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((MPMusicPlayerController)a.getObject()));
                }
            });
        }
    }
}

