/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.glkit;

import java.util.List;
import org.robovm.apple.coregraphics.CGImage;
import org.robovm.apple.dispatch.DispatchQueue;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSBundle;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.glkit.GLKTextureInfo;
import org.robovm.apple.glkit.GLKTextureLoaderOptions;
import org.robovm.apple.opengles.EAGLSharegroup;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="GLKit")
@NativeClass
public class GLKTextureLoader
extends NSObject {
    public GLKTextureLoader() {
    }

    protected GLKTextureLoader(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected GLKTextureLoader(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithSharegroup:")
    public GLKTextureLoader(EAGLSharegroup sharegroup) {
        super(null);
        this.initObject(this.init(sharegroup));
    }

    @Method(selector="initWithSharegroup:")
    @Pointer
    protected native long init(EAGLSharegroup var1);

    @Method(selector="textureWithContentsOfFile:options:queue:completionHandler:")
    @WeaklyLinked
    public native void loadTexture(String var1, GLKTextureLoaderOptions var2, DispatchQueue var3, @Block VoidBlock2<GLKTextureInfo, NSError> var4);

    @Method(selector="textureWithContentsOfURL:options:queue:completionHandler:")
    @WeaklyLinked
    public native void loadTexture(NSURL var1, GLKTextureLoaderOptions var2, DispatchQueue var3, @Block VoidBlock2<GLKTextureInfo, NSError> var4);

    @Method(selector="textureWithName:scaleFactor:bundle:options:queue:completionHandler:")
    @WeaklyLinked
    public native void createTexture(String var1, @MachineSizedFloat double var2, NSBundle var4, GLKTextureLoaderOptions var5, DispatchQueue var6, @Block VoidBlock2<GLKTextureInfo, NSError> var7);

    @Method(selector="textureWithContentsOfData:options:queue:completionHandler:")
    @WeaklyLinked
    public native void createTexture(NSData var1, GLKTextureLoaderOptions var2, DispatchQueue var3, @Block VoidBlock2<GLKTextureInfo, NSError> var4);

    @Method(selector="textureWithCGImage:options:queue:completionHandler:")
    @WeaklyLinked
    public native void createTexture(CGImage var1, GLKTextureLoaderOptions var2, DispatchQueue var3, @Block VoidBlock2<GLKTextureInfo, NSError> var4);

    @Method(selector="cubeMapWithContentsOfFiles:options:queue:completionHandler:")
    @WeaklyLinked
    public native void loadCubeMap(@Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var1, GLKTextureLoaderOptions var2, DispatchQueue var3, @Block VoidBlock2<GLKTextureInfo, NSError> var4);

    @Method(selector="cubeMapWithContentsOfFile:options:queue:completionHandler:")
    @WeaklyLinked
    public native void loadCubeMap(String var1, GLKTextureLoaderOptions var2, DispatchQueue var3, @Block VoidBlock2<GLKTextureInfo, NSError> var4);

    @Method(selector="cubeMapWithContentsOfURL:options:queue:completionHandler:")
    @WeaklyLinked
    public native void loadCubeMap(NSURL var1, GLKTextureLoaderOptions var2, DispatchQueue var3, @Block VoidBlock2<GLKTextureInfo, NSError> var4);

    public static GLKTextureInfo loadTexture(String path, GLKTextureLoaderOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        GLKTextureInfo result = GLKTextureLoader.loadTexture(path, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="textureWithContentsOfFile:options:error:")
    private static native GLKTextureInfo loadTexture(String var0, GLKTextureLoaderOptions var1, NSError.NSErrorPtr var2);

    public static GLKTextureInfo loadTexture(NSURL url, GLKTextureLoaderOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        GLKTextureInfo result = GLKTextureLoader.loadTexture(url, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="textureWithContentsOfURL:options:error:")
    private static native GLKTextureInfo loadTexture(NSURL var0, GLKTextureLoaderOptions var1, NSError.NSErrorPtr var2);

    public static GLKTextureInfo createTexture(String name, @MachineSizedFloat double scaleFactor, NSBundle bundle, GLKTextureLoaderOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        GLKTextureInfo result = GLKTextureLoader.createTexture(name, scaleFactor, bundle, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="textureWithName:scaleFactor:bundle:options:error:")
    private static native GLKTextureInfo createTexture(String var0, @MachineSizedFloat double var1, NSBundle var3, GLKTextureLoaderOptions var4, NSError.NSErrorPtr var5);

    public static GLKTextureInfo createTexture(NSData data, GLKTextureLoaderOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        GLKTextureInfo result = GLKTextureLoader.createTexture(data, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="textureWithContentsOfData:options:error:")
    private static native GLKTextureInfo createTexture(NSData var0, GLKTextureLoaderOptions var1, NSError.NSErrorPtr var2);

    public static GLKTextureInfo createTexture(CGImage cgImage, GLKTextureLoaderOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        GLKTextureInfo result = GLKTextureLoader.createTexture(cgImage, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="textureWithCGImage:options:error:")
    private static native GLKTextureInfo createTexture(CGImage var0, GLKTextureLoaderOptions var1, NSError.NSErrorPtr var2);

    public static GLKTextureInfo loadCubeMap(List<String> paths, GLKTextureLoaderOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        GLKTextureInfo result = GLKTextureLoader.loadCubeMap(paths, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="cubeMapWithContentsOfFiles:options:error:")
    private static native GLKTextureInfo loadCubeMap(@Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var0, GLKTextureLoaderOptions var1, NSError.NSErrorPtr var2);

    public static GLKTextureInfo loadCubeMap(String path, GLKTextureLoaderOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        GLKTextureInfo result = GLKTextureLoader.loadCubeMap(path, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="cubeMapWithContentsOfFile:options:error:")
    private static native GLKTextureInfo loadCubeMap(String var0, GLKTextureLoaderOptions var1, NSError.NSErrorPtr var2);

    public static GLKTextureInfo loadCubeMap(NSURL url, GLKTextureLoaderOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        GLKTextureInfo result = GLKTextureLoader.loadCubeMap(url, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="cubeMapWithContentsOfURL:options:error:")
    private static native GLKTextureInfo loadCubeMap(NSURL var0, GLKTextureLoaderOptions var1, NSError.NSErrorPtr var2);

    static {
        ObjCRuntime.bind(GLKTextureLoader.class);
    }

    public static class GLKTextureLoaderPtr
    extends Ptr<GLKTextureLoader, GLKTextureLoaderPtr> {
    }
}

