/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.gameplaykit;

import java.util.NoSuchElementException;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSFastEnumeration;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.gameplaykit.GKGoal;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="GameplayKit")
@NativeClass
public class GKBehavior
extends NSObject
implements NSFastEnumeration,
Iterable<GKGoal> {
    public GKBehavior() {
    }

    protected GKBehavior(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected GKBehavior(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public GKBehavior(GKGoal goal, float weight) {
        super(null, GKBehavior.create(goal, weight));
        GKBehavior.retain(this.getHandle());
    }

    public GKBehavior(NSArray<GKGoal> goals) {
        super(null, GKBehavior.create(goals));
        GKBehavior.retain(this.getHandle());
    }

    public GKBehavior(NSArray<GKGoal> goals, NSArray<NSNumber> weights) {
        super(null, GKBehavior.create(goals, weights));
        GKBehavior.retain(this.getHandle());
    }

    public GKBehavior(NSDictionary<GKGoal, NSNumber> weightedGoals) {
        super(null, GKBehavior.create(weightedGoals));
        GKBehavior.retain(this.getHandle());
    }

    @Property(selector="goalCount")
    @MachineSizedSInt
    public native long getGoalCount();

    @Override
    public java.util.Iterator<GKGoal> iterator() {
        return new Iterator(this);
    }

    @Method(selector="setWeight:forGoal:")
    private native void setGoalWeight(float var1, GKGoal var2);

    @Method(selector="weightForGoal:")
    public native float getGoalWeight(GKGoal var1);

    @Method(selector="removeGoal:")
    public native void removeGoal(GKGoal var1);

    @Method(selector="removeAllGoals")
    public native void removeAllGoals();

    @Method(selector="objectAtIndexedSubscript:")
    protected native GKGoal get(@MachineSizedUInt long var1);

    @Method(selector="behaviorWithGoal:weight:")
    @Pointer
    protected static native long create(GKGoal var0, float var1);

    @Method(selector="behaviorWithGoals:")
    @Pointer
    protected static native long create(NSArray<GKGoal> var0);

    @Method(selector="behaviorWithGoals:andWeights:")
    @Pointer
    protected static native long create(NSArray<GKGoal> var0, NSArray<NSNumber> var1);

    @Method(selector="behaviorWithWeightedGoals:")
    @Pointer
    protected static native long create(NSDictionary<GKGoal, NSNumber> var0);

    static {
        ObjCRuntime.bind(GKBehavior.class);
    }

    private static class Iterator
    implements java.util.Iterator<GKGoal> {
        GKBehavior enumerator;
        int index;
        GKGoal current;
        GKGoal next;

        Iterator(GKBehavior enumerator) {
            this.enumerator = enumerator;
            this.index = -1;
            this.current = null;
            this.next = enumerator.get(0L);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public GKGoal next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            ++this.index;
            this.next = this.enumerator.get(this.index + 1);
            return this.current;
        }

        void remove(int index, GKGoal o) {
            this.enumerator.removeGoal(o);
        }

        @Override
        public void remove() {
            if (this.current == null || this.next == null) {
                throw new IllegalStateException();
            }
            this.remove(this.index, this.current);
        }
    }

    public static class GKBehaviorPtr
    extends Ptr<GKBehavior, GKBehaviorPtr> {
    }
}

