/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorUserInfo;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.foundation.NSURLErrorCode;
import org.robovm.apple.foundation.NSURLErrorUserInfoKey;
import org.robovm.apple.foundation.NSURLProperty;
import org.robovm.apple.security.SecTrust;
import org.robovm.rt.annotation.StronglyLinked;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;

@Library(value="Foundation")
@StronglyLinked
public class NSURLError
extends NSError {
    private NSErrorUserInfo userInfo;

    protected NSURLError(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    private NSErrorUserInfo getCachedUserInfo() {
        if (this.userInfo == null) {
            this.userInfo = this.getUserInfo();
        }
        return this.userInfo;
    }

    @Override
    public NSURLErrorCode getErrorCode() {
        NSURLErrorCode code = null;
        try {
            code = NSURLErrorCode.valueOf(this.getCode());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return code;
    }

    public NSURL getFailingURL() {
        if (this.getCachedUserInfo().has(NSURLErrorUserInfoKey.FailingURL)) {
            NSURL val = (NSURL)this.getCachedUserInfo().get(NSURLErrorUserInfoKey.FailingURL);
            return val;
        }
        return null;
    }

    public String getFailingURLString() {
        if (this.getCachedUserInfo().has(NSURLErrorUserInfoKey.FailingURLString)) {
            NSString val = (NSString)this.getCachedUserInfo().get(NSURLErrorUserInfoKey.FailingURLString);
            return val.toString();
        }
        return null;
    }

    @WeaklyLinked
    public SecTrust getFailingURLPeerTrust() {
        if (this.getCachedUserInfo().has(NSURLErrorUserInfoKey.FailingURLPeerTrust)) {
            SecTrust val = this.getCachedUserInfo().get(NSURLErrorUserInfoKey.FailingURLPeerTrust, SecTrust.class);
            return val;
        }
        return null;
    }

    public List<NSURLProperty> getUnsetProperties() {
        ArrayList<NSURLProperty> properties = new ArrayList<NSURLProperty>();
        if (this.getCachedUserInfo().has(NSURLErrorUserInfoKey.KeysOfUnsetValues)) {
            NSArray val = (NSArray)this.getCachedUserInfo().get(NSURLErrorUserInfoKey.KeysOfUnsetValues);
            for (NSString s : val) {
                NSURLProperty p = NSURLProperty.valueOf(s);
                if (p == null) continue;
                properties.add(p);
            }
        }
        return properties;
    }

    @GlobalValue(symbol="NSURLErrorDomain", optional=true)
    public static native String getClassDomain();

    static {
        Bro.bind(NSURLError.class);
    }
}

