/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.List;
import java.util.Locale;
import org.robovm.apple.foundation.Foundation;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSCharacterSet;
import org.robovm.apple.foundation.NSCoder;
import org.robovm.apple.foundation.NSLocaleComponent;
import org.robovm.apple.foundation.NSLocaleComponents;
import org.robovm.apple.foundation.NSLocaleLanguageDirection;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSSecureCoding;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSLocale
extends NSObject
implements NSSecureCoding {
    protected NSLocale(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSLocale(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithLocaleIdentifier:")
    public NSLocale(String string) {
        super(null);
        this.initObject(this.init(string));
    }

    @Method(selector="initWithCoder:")
    public NSLocale(NSCoder decoder) {
        super(null);
        this.initObject(this.init(decoder));
    }

    public NSLocale(Locale locale) {
        super(null);
        this.initObject(this.init(locale.toString()));
    }

    @Property(selector="localeIdentifier")
    private native String getLocaleIdentifier0();

    @Property(selector="languageCode")
    private native String getLanguageCode0();

    @Property(selector="countryCode")
    private native String getCountryCode0();

    @Property(selector="scriptCode")
    private native String getScriptCode0();

    @Property(selector="variantCode")
    private native String getVariantCode0();

    @Property(selector="exemplarCharacterSet")
    private native NSCharacterSet getExemplarCharacterSet0();

    @Property(selector="calendarIdentifier")
    public native String getCalendarIdentifier();

    @Property(selector="collationIdentifier")
    private native String getCollationIdentifier0();

    @Property(selector="usesMetricSystem")
    private native boolean usesMetricSystem0();

    @Property(selector="decimalSeparator")
    private native String getDecimalSeparator0();

    @Property(selector="groupingSeparator")
    private native String getGroupingSeparator0();

    @Property(selector="currencySymbol")
    private native String getCurrencySymbol0();

    @Property(selector="currencyCode")
    private native String getCurrencyCode0();

    @Property(selector="collatorIdentifier")
    private native String getCollatorIdentifier0();

    @Property(selector="quotationBeginDelimiter")
    private native String getQuotationBeginDelimiter0();

    @Property(selector="quotationEndDelimiter")
    private native String getQuotationEndDelimiter0();

    @Property(selector="alternateQuotationBeginDelimiter")
    private native String getAlternateQuotationBeginDelimiter0();

    @Property(selector="alternateQuotationEndDelimiter")
    private native String getAlternateQuotationEndDelimiter0();

    @Property(selector="autoupdatingCurrentLocale")
    public static native NSLocale getAutoupdatingCurrentLocale();

    @Property(selector="currentLocale")
    public static native NSLocale getCurrentLocale();

    @Property(selector="systemLocale")
    public static native NSLocale getSystemLocale();

    @Property(selector="availableLocaleIdentifiers")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> getAvailableLocaleIdentifiers();

    @Property(selector="ISOLanguageCodes")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> getISOLanguageCodes();

    @Property(selector="ISOCountryCodes")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> getISOCountryCodes();

    @Property(selector="ISOCurrencyCodes")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> getISOCurrencyCodes();

    @Property(selector="commonISOCurrencyCodes")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> getCommonISOCurrencyCodes();

    @Property(selector="preferredLanguages")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> getPreferredLanguages();

    @Property(selector="supportsSecureCoding")
    public static native boolean supportsSecureCoding();

    public Locale toLocale() {
        String language = this.getLanguageCode();
        String country = this.getCountryCode();
        String variant = this.getVariantCode();
        if (language != null && country != null && variant != null) {
            return new Locale(language, country, variant);
        }
        if (language != null && country != null) {
            return new Locale(language, country);
        }
        if (language != null) {
            return new Locale(language);
        }
        throw new IllegalArgumentException("Failed to convert NSLocale " + this.toString() + " to Java Locale");
    }

    public String getLocaleIdentifier() {
        if (Foundation.getMajorSystemVersion() >= 10) {
            return this.getLocaleIdentifier0();
        }
        NSString val = (NSString)this.getComponent(NSLocaleComponent.Identifier);
        return val.toString();
    }

    public String getLanguageCode() {
        if (Foundation.getMajorSystemVersion() >= 10) {
            return this.getLanguageCode0();
        }
        NSString val = (NSString)this.getComponent(NSLocaleComponent.LanguageCode);
        return val.toString();
    }

    public String getCountryCode() {
        if (Foundation.getMajorSystemVersion() >= 10) {
            return this.getCountryCode0();
        }
        NSString val = (NSString)this.getComponent(NSLocaleComponent.CountryCode);
        return val.toString();
    }

    public String getScriptCode() {
        if (Foundation.getMajorSystemVersion() >= 10) {
            return this.getScriptCode0();
        }
        NSString val = (NSString)this.getComponent(NSLocaleComponent.ScriptCode);
        return val.toString();
    }

    public String getVariantCode() {
        if (Foundation.getMajorSystemVersion() >= 10) {
            return this.getVariantCode0();
        }
        NSString val = (NSString)this.getComponent(NSLocaleComponent.VariantCode);
        return val.toString();
    }

    public NSCharacterSet getExemplarCharacterSet() {
        if (Foundation.getMajorSystemVersion() >= 10) {
            return this.getExemplarCharacterSet0();
        }
        NSCharacterSet val = (NSCharacterSet)this.getComponent(NSLocaleComponent.ExemplarCharacterSet);
        return val;
    }

    public String getCollationIdentifier() {
        if (Foundation.getMajorSystemVersion() >= 10) {
            return this.getCollationIdentifier0();
        }
        NSString val = (NSString)this.getComponent(NSLocaleComponent.CollationIdentifier);
        return val.toString();
    }

    public boolean usesMetricSystem() {
        if (Foundation.getMajorSystemVersion() >= 10) {
            return this.usesMetricSystem0();
        }
        NSNumber val = (NSNumber)this.getComponent(NSLocaleComponent.UsesMetricSystem);
        return val.booleanValue();
    }

    public String getMeasurementSystem() {
        NSString val = (NSString)this.getComponent(NSLocaleComponent.MeasurementSystem);
        return val.toString();
    }

    public String getDecimalSeparator() {
        if (Foundation.getMajorSystemVersion() >= 10) {
            return this.getDecimalSeparator0();
        }
        NSString val = (NSString)this.getComponent(NSLocaleComponent.DecimalSeparator);
        return val.toString();
    }

    public String getGroupingSeparator() {
        if (Foundation.getMajorSystemVersion() >= 10) {
            return this.getGroupingSeparator0();
        }
        NSString val = (NSString)this.getComponent(NSLocaleComponent.GroupingSeparator);
        return val.toString();
    }

    public String getCurrencySymbol() {
        if (Foundation.getMajorSystemVersion() >= 10) {
            return this.getCurrencySymbol0();
        }
        NSString val = (NSString)this.getComponent(NSLocaleComponent.CurrencySymbol);
        return val.toString();
    }

    public String getCurrencyCode() {
        if (Foundation.getMajorSystemVersion() >= 10) {
            return this.getCurrencyCode0();
        }
        NSString val = (NSString)this.getComponent(NSLocaleComponent.CurrencyCode);
        return val.toString();
    }

    public String getCollatorIdentifier() {
        if (Foundation.getMajorSystemVersion() >= 10) {
            return this.getCollatorIdentifier0();
        }
        NSString val = (NSString)this.getComponent(NSLocaleComponent.CollatorIdentifier);
        return val.toString();
    }

    public String getQuotationBeginDelimiter() {
        if (Foundation.getMajorSystemVersion() >= 10) {
            return this.getQuotationBeginDelimiter0();
        }
        NSString val = (NSString)this.getComponent(NSLocaleComponent.QuotationBeginDelimiterKey);
        return val.toString();
    }

    public String getQuotationEndDelimiter() {
        if (Foundation.getMajorSystemVersion() >= 10) {
            return this.getQuotationEndDelimiter0();
        }
        NSString val = (NSString)this.getComponent(NSLocaleComponent.QuotationEndDelimiterKey);
        return val.toString();
    }

    public String getAlternateQuotationBeginDelimiter() {
        if (Foundation.getMajorSystemVersion() >= 10) {
            return this.getAlternateQuotationBeginDelimiter0();
        }
        NSString val = (NSString)this.getComponent(NSLocaleComponent.AlternateQuotationBeginDelimiterKey);
        return val.toString();
    }

    public String getAlternateQuotationEndDelimiter() {
        if (Foundation.getMajorSystemVersion() >= 10) {
            return this.getAlternateQuotationEndDelimiter0();
        }
        NSString val = (NSString)this.getComponent(NSLocaleComponent.AlternateQuotationEndDelimiterKey);
        return val.toString();
    }

    @GlobalValue(symbol="NSCurrentLocaleDidChangeNotification", optional=true)
    public static native NSString CurrentLocaleDidChangeNotification();

    @Method(selector="objectForKey:")
    public native NSObject getComponent(NSLocaleComponent var1);

    @Method(selector="displayNameForKey:value:")
    public native String getComponentDisplayName(NSLocaleComponent var1, NSObject var2);

    @Method(selector="initWithLocaleIdentifier:")
    @Pointer
    protected native long init(String var1);

    @Method(selector="componentsFromLocaleIdentifier:")
    public static native NSLocaleComponents getComponentsFromLocaleIdentifier(String var0);

    @Method(selector="localeIdentifierFromComponents:")
    public static native String getLocaleIdentifierFromComponents(NSLocaleComponents var0);

    @Method(selector="canonicalLocaleIdentifierFromString:")
    public static native String getCanonicalLocaleIdentifier(String var0);

    @Method(selector="canonicalLanguageIdentifierFromString:")
    public static native String getCanonicalLanguageIdentifier(String var0);

    @Method(selector="localeIdentifierFromWindowsLocaleCode:")
    public static native String getLocaleIdentifierFromWindowsLocaleCode(int var0);

    @Method(selector="windowsLocaleCodeFromLocaleIdentifier:")
    public static native int getWindowsLocaleCodeFromLocaleIdentifier(String var0);

    @Method(selector="characterDirectionForLanguage:")
    public static native NSLocaleLanguageDirection getCharacterDirection(String var0);

    @Method(selector="lineDirectionForLanguage:")
    public static native NSLocaleLanguageDirection getLineDirection(String var0);

    @Override
    @Method(selector="encodeWithCoder:")
    public native void encode(NSCoder var1);

    @Method(selector="initWithCoder:")
    @Pointer
    protected native long init(NSCoder var1);

    static {
        ObjCRuntime.bind(NSLocale.class);
    }

    public static class NSLocalePtr
    extends Ptr<NSLocale, NSLocalePtr> {
    }

    public static class Notifications {
        public static NSObject observeCurrentLocaleDidChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSLocale.CurrentLocaleDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }
    }
}

