/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSIndexSet;
import org.robovm.apple.foundation.NSKeyValueChange;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="Foundation")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class NSKeyValueChangeInfo
extends NSDictionaryWrapper {
    NSKeyValueChangeInfo(NSDictionary data) {
        super(data);
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public NSKeyValueChange getKind() {
        if (this.has(Keys.Kind())) {
            NSNumber val = (NSNumber)this.get(Keys.Kind());
            return NSKeyValueChange.valueOf(val.longValue());
        }
        return null;
    }

    public NSObject getNew() {
        if (this.has(Keys.New())) {
            NSObject val = this.get(Keys.New());
            return val;
        }
        return null;
    }

    public NSObject getOld() {
        if (this.has(Keys.Old())) {
            NSObject val = this.get(Keys.Old());
            return val;
        }
        return null;
    }

    public NSIndexSet getIndexes() {
        if (this.has(Keys.Indexes())) {
            NSIndexSet val = (NSIndexSet)this.get(Keys.Indexes());
            return val;
        }
        return null;
    }

    public boolean isNotificationSentPriorToChange() {
        if (this.has(Keys.NotificationIsPrior())) {
            NSNumber val = (NSNumber)this.get(Keys.NotificationIsPrior());
            return val.booleanValue();
        }
        return false;
    }

    @Library(value="Foundation")
    public static class Keys {
        @GlobalValue(symbol="NSKeyValueChangeKindKey", optional=true)
        public static native NSString Kind();

        @GlobalValue(symbol="NSKeyValueChangeNewKey", optional=true)
        public static native NSString New();

        @GlobalValue(symbol="NSKeyValueChangeOldKey", optional=true)
        public static native NSString Old();

        @GlobalValue(symbol="NSKeyValueChangeIndexesKey", optional=true)
        public static native NSString Indexes();

        @GlobalValue(symbol="NSKeyValueChangeNotificationIsPriorKey", optional=true)
        public static native NSString NotificationIsPrior();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<NSKeyValueChangeInfo> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<NSKeyValueChangeInfo> list = new ArrayList<NSKeyValueChangeInfo>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new NSKeyValueChangeInfo((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<NSKeyValueChangeInfo> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (NSKeyValueChangeInfo i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSKeyValueChangeInfo toObject(Class<NSKeyValueChangeInfo> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSKeyValueChangeInfo(o);
        }

        @MarshalsPointer
        public static long toNative(NSKeyValueChangeInfo o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

