/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSCocoaErrorCode;
import org.robovm.apple.foundation.NSCoder;
import org.robovm.apple.foundation.NSErrorCode;
import org.robovm.apple.foundation.NSErrorRecoveryAttempting;
import org.robovm.apple.foundation.NSErrorUserInfo;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSSecureCoding;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCObject;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.Selector;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.Block2;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.ForceLinkClass;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MarshalsPointer;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
@ForceLinkClass(value=NSErrorUserInfo.class)
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class NSError
extends NSObject
implements NSSecureCoding {
    private static final Map<String, Class<? extends NSError>> allNSErrorClasses = new HashMap<String, Class<? extends NSError>>();
    private static final int ABSTRACT = 1024;
    private static final Selector domain;

    protected NSError(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSError(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithDomain:code:userInfo:")
    public NSError(String domain, @MachineSizedSInt long code, NSErrorUserInfo dict) {
        super(null);
        this.initObject(this.init(domain, code, dict));
    }

    @Method(selector="initWithCoder:")
    public NSError(NSCoder decoder) {
        super(null);
        this.initObject(this.init(decoder));
    }

    protected static String domain(long handle) {
        long h = ObjCRuntime.ptr_objc_msgSend((long)handle, (long)domain.getHandle());
        NSString s = (NSString)ObjCObject.toObjCObject(NSString.class, (long)h, (int)0);
        return s.toString();
    }

    @Property(selector="domain")
    public native String getDomain();

    @Property(selector="code")
    @MachineSizedSInt
    public native long getCode();

    @Property(selector="userInfo")
    public native NSErrorUserInfo getUserInfo();

    @Property(selector="localizedDescription")
    public native String getLocalizedDescription();

    @Property(selector="localizedFailureReason")
    public native String getLocalizedFailureReason();

    @Property(selector="localizedRecoverySuggestion")
    public native String getLocalizedRecoverySuggestion();

    @Property(selector="localizedRecoveryOptions")
    @org.robovm.rt.bro.annotation.Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getLocalizedRecoveryOptions();

    @Property(selector="recoveryAttempter")
    public native NSErrorRecoveryAttempting getRecoveryAttempter();

    @Property(selector="helpAnchor")
    public native String getHelpAnchor();

    @Property(selector="supportsSecureCoding")
    public static native boolean supportsSecureCoding();

    public NSURL getURL() {
        NSErrorUserInfo info = this.getUserInfo();
        if (info == null) {
            return null;
        }
        return info.getURL();
    }

    public NSErrorCode getErrorCode() {
        NSErrorCode code = null;
        try {
            code = NSCocoaErrorCode.valueOf(this.getCode());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return code;
    }

    @Method(selector="initWithDomain:code:userInfo:")
    @Pointer
    protected native long init(String var1, @MachineSizedSInt long var2, NSErrorUserInfo var4);

    @Method(selector="setUserInfoValueProviderForDomain:provider:")
    public static native void setUserInfoValueProvider(String var0, @Block Block2<NSError, String, NSObject> var1);

    @Method(selector="userInfoValueProviderForDomain:")
    @Block
    public static native Block2<NSError, String, NSObject> getUserInfoValueProvider(NSError var0, String var1, String var2);

    @Override
    @Method(selector="encodeWithCoder:")
    public native void encode(NSCoder var1);

    @Method(selector="initWithCoder:")
    @Pointer
    protected native long init(NSCoder var1);

    static {
        Class[] classes = VM.listClasses(NSError.class, (ClassLoader)ClassLoader.getSystemClassLoader());
        Class[] emptyArgs = new Class[]{};
        Class<NSError> nsErrorClass = NSError.class;
        for (Class cls : classes) {
            if (cls == nsErrorClass || (cls.getModifiers() & 0x400) != 0) continue;
            try {
                Bro.bind((Class)cls);
                java.lang.reflect.Method m = cls.getMethod("getClassDomain", emptyArgs);
                String domain = (String)m.invoke(null, new Object[0]);
                allNSErrorClasses.put(domain, cls);
            }
            catch (Throwable e) {
                System.err.println("WARN: Failed to call getClassDomain() for the NSError subclass " + cls.getName());
            }
        }
        ObjCRuntime.bind(NSError.class);
        domain = Selector.register((String)"domain");
    }

    public static class NSErrorPtr
    extends Ptr<NSError, NSErrorPtr> {
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSError toObject(Class<? extends NSError> cls, long handle, long flags) {
            if (handle == 0L) {
                return null;
            }
            String domain = NSError.domain(handle);
            Class nsErrorClass = (Class)allNSErrorClasses.get(domain);
            if (nsErrorClass != null) {
                cls = nsErrorClass;
            }
            NSError o = (NSError)ObjCObject.toObjCObject((Class)cls, (long)handle, (int)0, (boolean)true);
            return o;
        }

        @MarshalsPointer
        public static long toNative(NSError o, long flags) {
            if (o == null) {
                return 0L;
            }
            return o.getHandle();
        }
    }
}

