/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.Date;
import org.robovm.apple.foundation.NSComparisonResult;
import org.robovm.apple.foundation.NSLocale;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSPropertyList;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSDate
extends NSObject
implements NSPropertyList {
    public static final double TimeIntervalSince1970 = 9.783072E8;

    public NSDate() {
    }

    protected NSDate(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSDate(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithTimeIntervalSince1970:")
    public NSDate(double secs) {
        super(null);
        this.initObject(this.init(secs));
    }

    public NSDate(Date date) {
        this((double)date.getTime() / 1000.0);
    }

    @Property(selector="timeIntervalSinceReferenceDate")
    public native double getTimeIntervalSinceReferenceDate();

    @Property(selector="timeIntervalSinceNow")
    public native double getTimeIntervalSinceNow();

    @Property(selector="timeIntervalSince1970")
    public native double getTimeIntervalSince1970();

    @Property(selector="distantFuture")
    public static native NSDate getDistantFuture();

    @Property(selector="distantPast")
    public static native NSDate getDistantPast();

    public Date toDate() {
        return new Date((long)(this.getTimeIntervalSince1970() * 1000.0));
    }

    @GlobalValue(symbol="NSSystemClockDidChangeNotification", optional=true)
    public static native NSString SystemClockDidChangeNotification();

    @Method(selector="timeIntervalSinceDate:")
    public native double getTimeIntervalSince(NSDate var1);

    @Method(selector="dateByAddingTimeInterval:")
    public native NSDate newDateByAddingTimeInterval(double var1);

    @Method(selector="earlierDate:")
    public native NSDate earlierDate(NSDate var1);

    @Method(selector="laterDate:")
    public native NSDate laterDate(NSDate var1);

    @Method(selector="compare:")
    public native NSComparisonResult compare(NSDate var1);

    @Method(selector="isEqualToDate:")
    public native boolean equalsTo(NSDate var1);

    @Method(selector="descriptionWithLocale:")
    public native String toString(NSLocale var1);

    @Method(selector="initWithTimeIntervalSince1970:")
    @Pointer
    protected native long init(double var1);

    @Method(selector="date")
    public static native NSDate now();

    @Method(selector="dateWithTimeIntervalSinceNow:")
    public static native NSDate createWithTimeIntervalSinceNow(double var0);

    @Method(selector="dateWithTimeIntervalSinceReferenceDate:")
    public static native NSDate createWithTimeIntervalSinceReferenceDate(double var0);

    @Method(selector="dateWithTimeIntervalSince1970:")
    public static native NSDate createWithTimeIntervalSince1970(double var0);

    @Method(selector="dateWithTimeInterval:sinceDate:")
    public static native NSDate createWithTimeIntervalSinceDate(double var0, NSDate var2);

    static {
        ObjCRuntime.bind(NSDate.class);
    }

    public static class NSDatePtr
    extends Ptr<NSDate, NSDatePtr> {
    }

    public static class Notifications {
        public static NSObject observeSystemClockDidChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSDate.SystemClockDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }
    }
}

