/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.robovm.apple.foundation.NSDataBase64DecodingOptions;
import org.robovm.apple.foundation.NSDataBase64EncodingOptions;
import org.robovm.apple.foundation.NSDataReadingOptions;
import org.robovm.apple.foundation.NSDataSearchOptions;
import org.robovm.apple.foundation.NSDataWritingOptions;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSPropertyList;
import org.robovm.apple.foundation.NSRange;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.VM;
import org.robovm.rt.bro.BufferMarshalers;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSData
extends NSObject
implements NSPropertyList {
    public NSData() {
    }

    protected NSData(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSData(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithData:")
    public NSData(NSData data) {
        super(null);
        this.initObject(this.init(data));
    }

    public NSData(byte[] bytes) {
        super(null);
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        this.initObject(this.init(VM.getArrayValuesAddress((Object)bytes), bytes.length));
    }

    public NSData(ByteBuffer bytes) {
        super(null);
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        long handle = BufferMarshalers.BufferMarshaler.getBufferAddress((Buffer)bytes) + (long)bytes.position();
        this.initObject(this.init(handle, bytes.remaining(), false));
        this.addStrongRef(bytes);
    }

    public NSData(BytePtr bytes, int length, boolean freeWhenDone) {
        super(null);
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        this.initObject(this.init(bytes.getHandle(), length, freeWhenDone));
    }

    public <T extends Struct<T>> NSData(T structData) {
        super(null);
        if (structData == null) {
            throw new NullPointerException("structData");
        }
        this.initObject(this.init(structData.getHandle(), Struct.sizeOf(structData)));
    }

    @Property(selector="length")
    @MachineSizedUInt
    public native long getLength();

    @Property(selector="bytes")
    @Pointer
    protected native long getBytes0();

    public ByteBuffer asByteBuffer() {
        return VM.newDirectByteBuffer((long)this.getBytes0(), (long)this.getLength());
    }

    public byte[] getBytes() {
        int length = (int)this.getLength();
        byte[] bytes = new byte[length];
        this.getBytes(VM.getArrayValuesAddress((Object)bytes), length);
        return bytes;
    }

    public int copy(ByteBuffer buffer, int dataOffset, int count) {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        if (dataOffset < 0 || count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if ((long)dataOffset >= this.getLength() || !buffer.hasRemaining()) {
            return -1;
        }
        if (count == 0) {
            return 0;
        }
        int n = Math.min(count, Math.min(buffer.remaining(), (int)this.getLength() - dataOffset));
        VM.memcpy((long)(BufferMarshalers.BufferMarshaler.getBufferAddress((Buffer)buffer) + (long)buffer.position()), (long)(this.getBytes0() + (long)dataOffset), (long)n);
        return n;
    }

    public int copy(byte[] buffer, int bufferOffset, int dataOffset, int count) {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        if (bufferOffset < 0 || dataOffset < 0 || count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if ((long)dataOffset >= this.getLength() || bufferOffset > buffer.length) {
            return -1;
        }
        if (count == 0) {
            return 0;
        }
        int n = Math.min(count, Math.min(buffer.length - bufferOffset, (int)this.getLength() - dataOffset));
        VM.memcpy((long)(VM.getArrayValuesAddress((Object)buffer) + (long)bufferOffset), (long)(this.getBytes0() + (long)dataOffset), (long)n);
        return n;
    }

    public <T extends Struct<T>> T getStructData(Class<T> type) {
        int length = (int)this.getLength();
        Struct struct = Struct.allocate(type);
        this.getBytes(struct.getHandle(), length);
        return (T)struct;
    }

    public static NSData fromBaseEncodedData(NSData base64Data, NSDataBase64DecodingOptions options) {
        NSData data = new NSData((NSObject.SkipInit)null);
        long handle = data.init(base64Data, options);
        if (handle == 0L) {
            return null;
        }
        data.initObject(handle);
        return data;
    }

    public static NSData fromBaseEncodedString(String base64String, NSDataBase64DecodingOptions options) {
        NSData data = new NSData((NSObject.SkipInit)null);
        long handle = data.init(base64String, options);
        if (handle == 0L) {
            return null;
        }
        data.initObject(handle);
        return data;
    }

    public static NSData read(File file, NSDataReadingOptions readOptionsMask) throws NSErrorException {
        return NSData.readFile(file.getAbsolutePath(), readOptionsMask);
    }

    public static NSData read(File file) {
        return NSData.readFile(file.getAbsolutePath());
    }

    @Deprecated
    public static NSData readMapped(File file) {
        return (NSData)NSData.readMappedFile(file.getAbsolutePath());
    }

    public void write(File file, boolean useAuxiliaryFile) {
        this.writeFile(file.getAbsolutePath(), useAuxiliaryFile);
    }

    public void write(File file, NSDataWritingOptions writeOptionsMask) throws NSErrorException {
        this.writeFile(file.getAbsolutePath(), writeOptionsMask);
    }

    @Method(selector="getBytes:length:")
    protected native void getBytes(@Pointer long var1, @MachineSizedUInt long var3);

    @Method(selector="subdataWithRange:")
    public native NSData getSubdata(@ByVal NSRange var1);

    @Method(selector="writeToFile:atomically:")
    protected native boolean writeFile(String var1, boolean var2);

    @Method(selector="writeToURL:atomically:")
    public native boolean write(NSURL var1, boolean var2);

    protected boolean writeFile(String path, NSDataWritingOptions writeOptionsMask) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.writeFile(path, writeOptionsMask, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="writeToFile:options:error:")
    private native boolean writeFile(String var1, NSDataWritingOptions var2, NSError.NSErrorPtr var3);

    public boolean write(NSURL url, NSDataWritingOptions writeOptionsMask) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.write(url, writeOptionsMask, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="writeToURL:options:error:")
    private native boolean write(NSURL var1, NSDataWritingOptions var2, NSError.NSErrorPtr var3);

    @Method(selector="rangeOfData:options:range:")
    @ByVal
    public native NSRange find(NSData var1, NSDataSearchOptions var2, @ByVal NSRange var3);

    @Method(selector="initWithBytes:length:")
    @Pointer
    protected native long init(@Pointer long var1, @MachineSizedUInt long var3);

    @Method(selector="initWithBytesNoCopy:length:freeWhenDone:")
    @Pointer
    protected native long init(@Pointer long var1, @MachineSizedUInt long var3, boolean var5);

    @Method(selector="initWithData:")
    @Pointer
    protected native long init(NSData var1);

    protected static NSData readFile(String path, NSDataReadingOptions readOptionsMask) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSData result = NSData.readFile(path, readOptionsMask, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="dataWithContentsOfFile:options:error:")
    private static native NSData readFile(String var0, NSDataReadingOptions var1, NSError.NSErrorPtr var2);

    public static NSData read(NSURL url, NSDataReadingOptions readOptionsMask) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSData result = NSData.read(url, readOptionsMask, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="dataWithContentsOfURL:options:error:")
    private static native NSData read(NSURL var0, NSDataReadingOptions var1, NSError.NSErrorPtr var2);

    @Method(selector="dataWithContentsOfFile:")
    protected static native NSData readFile(String var0);

    @Method(selector="dataWithContentsOfURL:")
    public static native NSData read(NSURL var0);

    @Method(selector="initWithBase64EncodedString:options:")
    @Pointer
    protected native long init(String var1, NSDataBase64DecodingOptions var2);

    @Method(selector="base64EncodedStringWithOptions:")
    public native String toBase64EncodedString(NSDataBase64EncodingOptions var1);

    @Method(selector="initWithBase64EncodedData:options:")
    @Pointer
    protected native long init(NSData var1, NSDataBase64DecodingOptions var2);

    @Method(selector="base64EncodedDataWithOptions:")
    public native NSData toBase64EncodedData(NSDataBase64EncodingOptions var1);

    @Deprecated
    @Method(selector="dataWithContentsOfMappedFile:")
    protected static native NSObject readMappedFile(String var0);

    static {
        ObjCRuntime.bind(NSData.class);
    }

    public static class NSDataPtr
    extends Ptr<NSData, NSDataPtr> {
    }
}

