/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coretext;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.coretext.CTLineBoundsOptions;
import org.robovm.apple.coretext.CTLineBreakMode;
import org.robovm.apple.coretext.CTParagraphStyleSetting;
import org.robovm.apple.coretext.CTParagraphStyleSpecifier;
import org.robovm.apple.coretext.CTTextAlignment;
import org.robovm.apple.coretext.CTTextTab;
import org.robovm.apple.coretext.CTWritingDirection;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.LongPtr;
import org.robovm.rt.bro.ptr.MachineSizedFloatPtr;
import org.robovm.rt.bro.ptr.VoidPtr;

public class CTParagraphStyleSettings {
    private Map<CTParagraphStyleSpecifier, CTParagraphStyleSetting> settings = new HashMap<CTParagraphStyleSpecifier, CTParagraphStyleSetting>();

    public void setAlignment(CTTextAlignment alignment) {
        BytePtr ptr = new BytePtr((byte)alignment.value());
        this.setValueForSpecifier(CTParagraphStyleSpecifier.Alignment, (VoidPtr)ptr.as(VoidPtr.class));
    }

    public void setLineBreakMode(CTLineBreakMode lineBreakMode) {
        BytePtr ptr = new BytePtr((byte)lineBreakMode.value());
        this.setValueForSpecifier(CTParagraphStyleSpecifier.LineBreakMode, (VoidPtr)ptr.as(VoidPtr.class));
    }

    public void setBaseWritingDirection(CTWritingDirection writingDirection) {
        BytePtr ptr = new BytePtr((byte)writingDirection.value());
        this.setValueForSpecifier(CTParagraphStyleSpecifier.BaseWritingDirection, (VoidPtr)ptr.as(VoidPtr.class));
    }

    public void setFirstLineHeadIndent(double lineHeadIndent) {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        ptr.set(lineHeadIndent);
        this.setValueForSpecifier(CTParagraphStyleSpecifier.FirstLineHeadIndent, (VoidPtr)ptr.as(VoidPtr.class));
    }

    public void setHeadIndent(double headIndent) {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        ptr.set(headIndent);
        this.setValueForSpecifier(CTParagraphStyleSpecifier.HeadIndent, (VoidPtr)ptr.as(VoidPtr.class));
    }

    public void setTailIndent(double tailIndent) {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        ptr.set(tailIndent);
        this.setValueForSpecifier(CTParagraphStyleSpecifier.TailIndent, (VoidPtr)ptr.as(VoidPtr.class));
    }

    public void setDefaultTabInterval(double defaultTabInterval) {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        ptr.set(defaultTabInterval);
        this.setValueForSpecifier(CTParagraphStyleSpecifier.DefaultTabInterval, (VoidPtr)ptr.as(VoidPtr.class));
    }

    public void setLineHeightMultiple(double lineHeightMultiple) {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        ptr.set(lineHeightMultiple);
        this.setValueForSpecifier(CTParagraphStyleSpecifier.LineHeightMultiple, (VoidPtr)ptr.as(VoidPtr.class));
    }

    public void setMaximumLineHeight(double maximumLineHeight) {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        ptr.set(maximumLineHeight);
        this.setValueForSpecifier(CTParagraphStyleSpecifier.MaximumLineHeight, (VoidPtr)ptr.as(VoidPtr.class));
    }

    public void setMinimumLineHeight(double minimumLineHeight) {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        ptr.set(minimumLineHeight);
        this.setValueForSpecifier(CTParagraphStyleSpecifier.MinimumLineHeight, (VoidPtr)ptr.as(VoidPtr.class));
    }

    public void setParagraphSpacing(double paragraphSpacing) {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        ptr.set(paragraphSpacing);
        this.setValueForSpecifier(CTParagraphStyleSpecifier.ParagraphSpacing, (VoidPtr)ptr.as(VoidPtr.class));
    }

    public void setParagraphSpacingBefore(double paragraphSpacingBefore) {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        ptr.set(paragraphSpacingBefore);
        this.setValueForSpecifier(CTParagraphStyleSpecifier.ParagraphSpacingBefore, (VoidPtr)ptr.as(VoidPtr.class));
    }

    public void setMaximumLineSpacing(double maximumLineSpacing) {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        ptr.set(maximumLineSpacing);
        this.setValueForSpecifier(CTParagraphStyleSpecifier.MaximumLineSpacing, (VoidPtr)ptr.as(VoidPtr.class));
    }

    public void setMinimumLineSpacing(double minimumLineSpacing) {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        ptr.set(minimumLineSpacing);
        this.setValueForSpecifier(CTParagraphStyleSpecifier.MinimumLineSpacing, (VoidPtr)ptr.as(VoidPtr.class));
    }

    public void setLineSpacingAdjustment(double lineSpacingAdjustment) {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        ptr.set(lineSpacingAdjustment);
        this.setValueForSpecifier(CTParagraphStyleSpecifier.LineSpacingAdjustment, (VoidPtr)ptr.as(VoidPtr.class));
    }

    public void setTabStops(List<CTTextTab> tabStops) {
        CFArray array = CFArray.create(tabStops);
        CFArray.CFArrayPtr ptr = new CFArray.CFArrayPtr();
        ptr.set(array);
        this.setValueForSpecifier(CTParagraphStyleSpecifier.TabStops, (VoidPtr)ptr.as(VoidPtr.class));
    }

    public void setLineBoundsOptions(CTLineBoundsOptions lineBoundsOptions) {
        LongPtr ptr = new LongPtr(lineBoundsOptions.value());
        this.setValueForSpecifier(CTParagraphStyleSpecifier.LineBoundsOptions, (VoidPtr)ptr.as(VoidPtr.class));
    }

    public void setValueForSpecifier(CTParagraphStyleSpecifier spec, VoidPtr value) {
        if (spec == null) {
            throw new NullPointerException("spec");
        }
        CTParagraphStyleSetting setting = this.settings.get((Object)spec);
        if (setting == null) {
            setting = this.createSettingForSpecifier(spec);
            this.settings.put(spec, setting);
        }
        setting.setValue(value);
    }

    private CTParagraphStyleSetting createSettingForSpecifier(CTParagraphStyleSpecifier spec) {
        CTParagraphStyleSetting setting = new CTParagraphStyleSetting();
        setting.setSpec(spec);
        int size = 0;
        switch (spec) {
            case Alignment: 
            case LineBreakMode: 
            case BaseWritingDirection: {
                size = BytePtr.sizeOf();
                break;
            }
            case FirstLineHeadIndent: 
            case HeadIndent: 
            case TailIndent: 
            case DefaultTabInterval: 
            case LineHeightMultiple: 
            case MaximumLineHeight: 
            case MinimumLineHeight: 
            case ParagraphSpacing: 
            case ParagraphSpacingBefore: 
            case MaximumLineSpacing: 
            case MinimumLineSpacing: 
            case LineSpacingAdjustment: {
                size = MachineSizedFloatPtr.sizeOf();
                break;
            }
            case TabStops: {
                size = CFArray.CFArrayPtr.sizeOf();
                break;
            }
            case LineBoundsOptions: {
                size = LongPtr.sizeOf();
                break;
            }
        }
        setting.setValueSize(size);
        return setting;
    }

    public Map<CTParagraphStyleSpecifier, CTParagraphStyleSetting> getSettings() {
        return this.settings;
    }
}

