/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coretext;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coretext.CTFontDescriptor;
import org.robovm.apple.foundation.NSError;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreText")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CTFontDescriptorProgressData
extends CFDictionaryWrapper {
    CTFontDescriptorProgressData(CFDictionary data) {
        super(data);
    }

    public boolean has(CFString key) {
        return this.data.containsKey(key);
    }

    public <T extends NativeObject> T get(CFString key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get(key, type);
        }
        return null;
    }

    public CTFontDescriptor getSourceDescriptor() {
        if (this.has(Keys.SourceDescriptor())) {
            CTFontDescriptor val = this.get(Keys.SourceDescriptor(), CTFontDescriptor.class);
            return val;
        }
        return null;
    }

    public List<CTFontDescriptor> getDescriptors() {
        if (this.has(Keys.Descriptors())) {
            CFArray val = this.get(Keys.Descriptors(), CFArray.class);
            return val.toList(CTFontDescriptor.class);
        }
        return null;
    }

    public List<CTFontDescriptor> getResult() {
        if (this.has(Keys.Result())) {
            CFArray val = this.get(Keys.Result(), CFArray.class);
            return val.toList(CTFontDescriptor.class);
        }
        return null;
    }

    public double getPercentage() {
        if (this.has(Keys.Percentage())) {
            CFNumber val = this.get(Keys.Percentage(), CFNumber.class);
            return val.doubleValue();
        }
        return 0.0;
    }

    public long getCurrentAssetSize() {
        if (this.has(Keys.CurrentAssetSize())) {
            CFNumber val = this.get(Keys.CurrentAssetSize(), CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public long getTotalDownloadedSize() {
        if (this.has(Keys.TotalDownloadedSize())) {
            CFNumber val = this.get(Keys.TotalDownloadedSize(), CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public long getTotalAssetSize() {
        if (this.has(Keys.TotalAssetSize())) {
            CFNumber val = this.get(Keys.TotalAssetSize(), CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public NSError getError() {
        if (this.has(Keys.Error())) {
            NSError val = this.get(Keys.Error(), NSError.class);
            return val;
        }
        return null;
    }

    @Library(value="CoreText")
    public static class Keys {
        @GlobalValue(symbol="kCTFontDescriptorMatchingSourceDescriptor", optional=true)
        public static native CFString SourceDescriptor();

        @GlobalValue(symbol="kCTFontDescriptorMatchingDescriptors", optional=true)
        public static native CFString Descriptors();

        @GlobalValue(symbol="kCTFontDescriptorMatchingResult", optional=true)
        public static native CFString Result();

        @GlobalValue(symbol="kCTFontDescriptorMatchingPercentage", optional=true)
        public static native CFString Percentage();

        @GlobalValue(symbol="kCTFontDescriptorMatchingCurrentAssetSize", optional=true)
        public static native CFString CurrentAssetSize();

        @GlobalValue(symbol="kCTFontDescriptorMatchingTotalDownloadedSize", optional=true)
        public static native CFString TotalDownloadedSize();

        @GlobalValue(symbol="kCTFontDescriptorMatchingTotalAssetSize", optional=true)
        public static native CFString TotalAssetSize();

        @GlobalValue(symbol="kCTFontDescriptorMatchingError", optional=true)
        public static native CFString Error();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CTFontDescriptorProgressData> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(CFArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CTFontDescriptorProgressData> list = new ArrayList<CTFontDescriptorProgressData>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new CTFontDescriptorProgressData(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CTFontDescriptorProgressData> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (CTFontDescriptorProgressData i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CTFontDescriptorProgressData toObject(Class<CTFontDescriptorProgressData> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CTFontDescriptorProgressData(o);
        }

        @MarshalsPointer
        public static long toNative(CTFontDescriptorProgressData o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

