/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreservices;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Map;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFStreamError;
import org.robovm.apple.corefoundation.CFStreamErrorException;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coreservices.CFHTTPAuthentication;
import org.robovm.apple.coreservices.CFHTTPAuthenticationCredentials;
import org.robovm.apple.coreservices.CFHTTPAuthenticationScheme;
import org.robovm.apple.coreservices.CFHTTPVersion;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSURL;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CFNetwork")
public class CFHTTPMessage
extends CFType {
    private static final int EFFECTIVE_DIRECT_ADDRESS_OFFSET;

    static long getEffectiveAddress(ByteBuffer bytes) {
        if (!bytes.isDirect()) {
            throw new IllegalArgumentException("Direct ByteBuffer expected");
        }
        return VM.getLong((long)(VM.getObjectAddress((Object)bytes) + (long)EFFECTIVE_DIRECT_ADDRESS_OFFSET));
    }

    protected CFHTTPMessage() {
    }

    static void checkOffsetAndCount(int arrayLength, int offset, int count) {
        if ((offset | count) < 0 || offset > arrayLength || arrayLength - offset < count) {
            throw new ArrayIndexOutOfBoundsException("length=" + arrayLength + "; regionStart=" + offset + "; regionLength=" + count);
        }
    }

    public CFHTTPMessage append(ByteBuffer bytes) {
        long handle = CFHTTPMessage.getEffectiveAddress(bytes) + (long)bytes.position();
        this.appendBytes(handle, bytes.remaining());
        return this;
    }

    public CFHTTPMessage append(byte[] bytes) {
        return this.append(bytes, 0, bytes.length);
    }

    public CFHTTPMessage append(byte[] bytes, int offset, int length) {
        CFHTTPMessage.checkOffsetAndCount(bytes.length, offset, length);
        if (length == 0) {
            return this;
        }
        this.appendBytes(VM.getArrayValuesAddress((Object)bytes) + (long)offset, length);
        return this;
    }

    public static CFHTTPMessage createRequest(String requestMethod, NSURL url, CFHTTPVersion httpVersion) {
        return CFHTTPMessage.createRequest(null, requestMethod, url, httpVersion);
    }

    public static CFHTTPMessage createResponse(@MachineSizedSInt long statusCode, String statusDescription, CFHTTPVersion httpVersion) {
        return CFHTTPMessage.createResponse(null, statusCode, statusDescription, httpVersion);
    }

    public static CFHTTPMessage createEmpty(boolean isRequest) {
        return CFHTTPMessage.createEmpty(null, isRequest);
    }

    public static CFHTTPMessage createCopy(CFHTTPMessage message) {
        return CFHTTPMessage.createCopy(null, message);
    }

    public boolean applyCredentials(CFHTTPAuthentication auth, String username, String password, String accountDomain) {
        CFHTTPAuthenticationCredentials credentials = new CFHTTPAuthenticationCredentials();
        if (username != null) {
            credentials.setUsername(username);
        }
        if (password != null) {
            credentials.setPassword(password);
        }
        if (accountDomain != null) {
            credentials.setAccountDomain(accountDomain);
        }
        return this.applyCredentials(auth, credentials, null);
    }

    @Bridge(symbol="CFHTTPMessageGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CFHTTPMessageCreateRequest", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFHTTPMessage createRequest(CFAllocator var0, String var1, NSURL var2, CFHTTPVersion var3);

    @Bridge(symbol="CFHTTPMessageCreateResponse", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFHTTPMessage createResponse(CFAllocator var0, @MachineSizedSInt long var1, String var3, CFHTTPVersion var4);

    @Bridge(symbol="CFHTTPMessageCreateEmpty", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFHTTPMessage createEmpty(CFAllocator var0, boolean var1);

    @Bridge(symbol="CFHTTPMessageCreateCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFHTTPMessage createCopy(CFAllocator var0, CFHTTPMessage var1);

    @Bridge(symbol="CFHTTPMessageIsRequest", optional=true)
    public native boolean isRequest();

    @Bridge(symbol="CFHTTPMessageCopyVersion", optional=true)
    public native CFHTTPVersion getVersion();

    @Bridge(symbol="CFHTTPMessageCopyBody", optional=true)
    public native NSData getBody();

    @Bridge(symbol="CFHTTPMessageSetBody", optional=true)
    public native void setBody(NSData var1);

    @Bridge(symbol="CFHTTPMessageCopyHeaderFieldValue", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getHeaderFieldValue(String var1);

    @Bridge(symbol="CFHTTPMessageCopyAllHeaderFields", optional=true)
    @Marshaler(value=CFDictionary.AsStringStringMapMarshaler.class)
    public native Map<String, String> getAllHeaderFields();

    @Bridge(symbol="CFHTTPMessageSetHeaderFieldValue", optional=true)
    public native void setHeaderFieldValue(String var1, String var2);

    @Bridge(symbol="CFHTTPMessageAppendBytes", optional=true)
    private native boolean appendBytes(@Pointer long var1, @MachineSizedSInt long var3);

    @Bridge(symbol="CFHTTPMessageIsHeaderComplete", optional=true)
    public native boolean isHeaderComplete();

    @Bridge(symbol="CFHTTPMessageCopySerializedMessage", optional=true)
    @Marshaler(value=NSObject.NoRetainMarshaler.class)
    public native NSData getSerializedMessage();

    @Bridge(symbol="CFHTTPMessageCopyRequestURL", optional=true)
    @Marshaler(value=NSObject.NoRetainMarshaler.class)
    public native NSURL getRequestURL();

    @Bridge(symbol="CFHTTPMessageCopyRequestMethod", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getRequestMethod();

    @Bridge(symbol="CFHTTPMessageAddAuthentication", optional=true)
    public native boolean addAuthentication(CFHTTPMessage var1, String var2, String var3, CFHTTPAuthenticationScheme var4, boolean var5);

    @Bridge(symbol="CFHTTPMessageGetResponseStatusCode", optional=true)
    @MachineSizedSInt
    public native long getResponseStatusCode();

    @Bridge(symbol="CFHTTPMessageCopyResponseStatusLine", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getResponseStatusLine();

    public boolean applyCredentials(CFHTTPAuthentication auth, String username, String password) throws CFStreamErrorException {
        CFStreamError.CFStreamErrorPtr ptr = new CFStreamError.CFStreamErrorPtr();
        boolean result = this.applyCredentials(auth, username, password, ptr);
        if (ptr.get() != null) {
            throw new CFStreamErrorException((CFStreamError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CFHTTPMessageApplyCredentials", optional=true)
    private native boolean applyCredentials(CFHTTPAuthentication var1, String var2, String var3, CFStreamError.CFStreamErrorPtr var4);

    public boolean applyCredentials(CFHTTPAuthentication auth, CFHTTPAuthenticationCredentials dict) throws CFStreamErrorException {
        CFStreamError.CFStreamErrorPtr ptr = new CFStreamError.CFStreamErrorPtr();
        boolean result = this.applyCredentials(auth, dict, ptr);
        if (ptr.get() != null) {
            throw new CFStreamErrorException((CFStreamError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CFHTTPMessageApplyCredentialDictionary", optional=true)
    private native boolean applyCredentials(CFHTTPAuthentication var1, CFHTTPAuthenticationCredentials var2, CFStreamError.CFStreamErrorPtr var3);

    static {
        try {
            Field f1 = Buffer.class.getDeclaredField("effectiveDirectAddress");
            if (f1.getType() != Long.TYPE) {
                throw new Error("java.nio.Buffer.effectiveDirectAddress should be a long");
            }
            EFFECTIVE_DIRECT_ADDRESS_OFFSET = VM.getInstanceFieldOffset((long)VM.getFieldAddress((Field)f1));
        }
        catch (NoSuchFieldException e) {
            throw new Error(e);
        }
        Bro.bind(CFHTTPMessage.class);
    }

    public static class CFHTTPMessagePtr
    extends Ptr<CFHTTPMessage, CFHTTPMessagePtr> {
    }
}

