/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreml;

import org.robovm.apple.coreml.MLFeatureProvider;
import org.robovm.apple.coreml.MLModelDescription;
import org.robovm.apple.coreml.MLPredictionOptions;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreML")
@NativeClass
public class MLModel
extends NSObject {
    public MLModel() {
    }

    protected MLModel(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected MLModel(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public MLModel(NSURL url) throws NSErrorException {
        this(url, new NSError.NSErrorPtr());
    }

    private MLModel(NSURL url, NSError.NSErrorPtr ptr) throws NSErrorException {
        super(null, MLModel.create(url, ptr));
        MLModel.retain(this.getHandle());
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
    }

    @Property(selector="modelDescription")
    public native MLModelDescription getModelDescription();

    public MLFeatureProvider predictionFromFeatures(MLFeatureProvider input) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MLFeatureProvider result = this.predictionFromFeatures(input, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="predictionFromFeatures:error:")
    private native MLFeatureProvider predictionFromFeatures(MLFeatureProvider var1, NSError.NSErrorPtr var2);

    @Method(selector="predictionFromFeatures:options:error:")
    public native MLFeatureProvider predictionFromFeatures(MLFeatureProvider var1, MLPredictionOptions var2, NSError.NSErrorPtr var3);

    @Method(selector="modelWithContentsOfURL:error:")
    @Pointer
    protected static native long create(NSURL var0, NSError.NSErrorPtr var1);

    public static NSURL compileModel(NSURL modelURL) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSURL result = MLModel.compileModel(modelURL, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="compileModelAtURL:error:")
    private static native NSURL compileModel(NSURL var0, NSError.NSErrorPtr var1);

    static {
        ObjCRuntime.bind(MLModel.class);
    }

    public static class MLModelPtr
    extends Ptr<MLModel, MLModelPtr> {
    }
}

