/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreimage;

import org.robovm.apple.avfoundation.AVDepthData;
import org.robovm.apple.coregraphics.CGAffineTransform;
import org.robovm.apple.coregraphics.CGColorSpace;
import org.robovm.apple.coregraphics.CGImage;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.coregraphics.CGSize;
import org.robovm.apple.coreimage.CIColor;
import org.robovm.apple.coreimage.CIFilter;
import org.robovm.apple.coreimage.CIFilterInputParameters;
import org.robovm.apple.coreimage.CIImageOptions;
import org.robovm.apple.corevideo.CVImageBuffer;
import org.robovm.apple.corevideo.CVPixelBuffer;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.imageio.CGImagePropertyOrientation;
import org.robovm.apple.iosurface.IOSurface;
import org.robovm.apple.metal.MTLTexture;
import org.robovm.apple.uikit.CIImageExtensions;
import org.robovm.apple.uikit.UIImage;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreImage")
@NativeClass
public class CIImage
extends NSObject {
    protected CIImage() {
    }

    protected CIImage(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected CIImage(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithCGImage:")
    public CIImage(CGImage image) {
        super(null);
        this.initObject(this.init(image));
    }

    @Method(selector="initWithCGImage:options:")
    public CIImage(CGImage image, CIImageOptions options) {
        super(null);
        this.initObject(this.init(image, options));
    }

    @Method(selector="initWithData:")
    public CIImage(NSData data) {
        super(null);
        this.initObject(this.init(data));
    }

    @Method(selector="initWithData:options:")
    public CIImage(NSData data, CIImageOptions options) {
        super(null);
        this.initObject(this.init(data, options));
    }

    @Method(selector="initWithBitmapData:bytesPerRow:size:format:colorSpace:")
    public CIImage(NSData data, @MachineSizedUInt long bytesPerRow, @ByVal CGSize size, int format, CGColorSpace colorSpace) {
        super(null);
        this.initObject(this.init(data, bytesPerRow, size, format, colorSpace));
    }

    @Method(selector="initWithTexture:size:flipped:colorSpace:")
    public CIImage(int name, @ByVal CGSize size, boolean flipped, CGColorSpace colorSpace) {
        super(null);
        this.initObject(this.init(name, size, flipped, colorSpace));
    }

    @Method(selector="initWithMTLTexture:options:")
    public CIImage(MTLTexture texture, CIImageOptions options) {
        super(null);
        this.initObject(this.init(texture, options));
    }

    @Method(selector="initWithContentsOfURL:")
    public CIImage(NSURL url) {
        super(null);
        this.initObject(this.init(url));
    }

    @Method(selector="initWithContentsOfURL:options:")
    public CIImage(NSURL url, CIImageOptions options) {
        super(null);
        this.initObject(this.init(url, options));
    }

    @Method(selector="initWithIOSurface:")
    public CIImage(IOSurface surface) {
        super(null);
        this.initObject(this.init(surface));
    }

    @Method(selector="initWithIOSurface:options:")
    public CIImage(IOSurface surface, CIImageOptions options) {
        super(null);
        this.initObject(this.init(surface, options));
    }

    @Method(selector="initWithCVImageBuffer:")
    public CIImage(CVImageBuffer imageBuffer) {
        super(null);
        this.initObject(this.init(imageBuffer));
    }

    @Method(selector="initWithCVImageBuffer:options:")
    public CIImage(CVImageBuffer imageBuffer, CIImageOptions options) {
        super(null);
        this.initObject(this.init(imageBuffer, options));
    }

    @Method(selector="initWithCVPixelBuffer:")
    @WeaklyLinked
    public CIImage(CVPixelBuffer pixelBuffer) {
        super(null);
        this.initObject(this.init(pixelBuffer));
    }

    @Method(selector="initWithCVPixelBuffer:options:")
    @WeaklyLinked
    public CIImage(CVPixelBuffer pixelBuffer, NSDictionary<NSString, ?> options) {
        super(null);
        this.initObject(this.init(pixelBuffer, options));
    }

    @Method(selector="initWithColor:")
    public CIImage(CIColor color) {
        super(null);
        this.initObject(this.init(color));
    }

    @Method(selector="initWithImageProvider:size::format:colorSpace:options:")
    public CIImage(NSObject p, @MachineSizedUInt long width, @MachineSizedUInt long height, int f, CGColorSpace cs, CIImageOptions options) {
        super(null);
        this.initObject(this.init(p, width, height, f, cs, options));
    }

    @Property(selector="extent")
    @ByVal
    public native CGRect getExtent();

    @Property(selector="properties")
    public native NSDictionary<NSString, ?> getProperties();

    @Property(selector="url")
    public native NSURL getUrl();

    @Property(selector="colorSpace")
    public native CGColorSpace getColorSpace();

    @Property(selector="pixelBuffer")
    public native CVPixelBuffer getPixelBuffer();

    @Property(selector="CGImage")
    public native CGImage getCGImage();

    @Property(selector="depthData")
    public native AVDepthData getDepthData();

    public CIImage(UIImage image) {
        super(null);
        CIImage i = CIImageExtensions.create(image);
        this.initObject(i.getHandle());
    }

    public CIImage(UIImage image, CIImageOptions options) {
        super(null);
        CIImage i = CIImageExtensions.create(image, options);
        this.initObject(i.getHandle());
    }

    @Method(selector="initWithCGImage:")
    @Pointer
    protected native long init(CGImage var1);

    @Method(selector="initWithCGImage:options:")
    @Pointer
    protected native long init(CGImage var1, CIImageOptions var2);

    @Method(selector="initWithData:")
    @Pointer
    protected native long init(NSData var1);

    @Method(selector="initWithData:options:")
    @Pointer
    protected native long init(NSData var1, CIImageOptions var2);

    @Method(selector="initWithBitmapData:bytesPerRow:size:format:colorSpace:")
    @Pointer
    protected native long init(NSData var1, @MachineSizedUInt long var2, @ByVal CGSize var4, int var5, CGColorSpace var6);

    @Method(selector="initWithTexture:size:flipped:colorSpace:")
    @Pointer
    protected native long init(int var1, @ByVal CGSize var2, boolean var3, CGColorSpace var4);

    @Method(selector="initWithMTLTexture:options:")
    @Pointer
    protected native long init(MTLTexture var1, CIImageOptions var2);

    @Method(selector="initWithContentsOfURL:")
    @Pointer
    protected native long init(NSURL var1);

    @Method(selector="initWithContentsOfURL:options:")
    @Pointer
    protected native long init(NSURL var1, CIImageOptions var2);

    @Method(selector="initWithIOSurface:")
    @Pointer
    protected native long init(IOSurface var1);

    @Method(selector="initWithIOSurface:options:")
    @Pointer
    protected native long init(IOSurface var1, CIImageOptions var2);

    @Method(selector="initWithCVImageBuffer:")
    @Pointer
    protected native long init(CVImageBuffer var1);

    @Method(selector="initWithCVImageBuffer:options:")
    @Pointer
    protected native long init(CVImageBuffer var1, CIImageOptions var2);

    @Method(selector="initWithCVPixelBuffer:")
    @Pointer
    @WeaklyLinked
    protected native long init(CVPixelBuffer var1);

    @Method(selector="initWithCVPixelBuffer:options:")
    @Pointer
    @WeaklyLinked
    protected native long init(CVPixelBuffer var1, NSDictionary<NSString, ?> var2);

    @Method(selector="initWithColor:")
    @Pointer
    protected native long init(CIColor var1);

    @Method(selector="imageByApplyingTransform:")
    public native CIImage newImageByApplyingTransform(@ByVal CGAffineTransform var1);

    @Method(selector="imageByApplyingOrientation:")
    @WeaklyLinked
    public native CIImage newImageByApplyingOrientation(CGImagePropertyOrientation var1);

    @Method(selector="imageTransformForOrientation:")
    @ByVal
    @WeaklyLinked
    public native CGAffineTransform getImageTransformForOrientation(CGImagePropertyOrientation var1);

    @Method(selector="imageByApplyingCGOrientation:")
    public native CIImage newImageByApplyingCGOrientation(CGImagePropertyOrientation var1);

    @Method(selector="imageTransformForCGOrientation:")
    @ByVal
    public native CGAffineTransform imageTransformForCGOrientation(CGImagePropertyOrientation var1);

    @Method(selector="imageByCompositingOverImage:")
    public native CIImage newImageByCompositingOverImage(CIImage var1);

    @Method(selector="imageByCroppingToRect:")
    public native CIImage newImageByCroppingToRect(@ByVal CGRect var1);

    @Method(selector="imageByClampingToExtent")
    public native CIImage newImageByClampingToExtent();

    @Method(selector="imageByClampingToRect:")
    public native CIImage newImageByClampingToRect(@ByVal CGRect var1);

    @Method(selector="imageByApplyingFilter:withInputParameters:")
    public native CIImage newImageByApplyingFilter(String var1, CIFilterInputParameters var2);

    @Method(selector="imageByApplyingFilter:")
    public native CIImage newImageByApplyingFilter(String var1);

    @Method(selector="imageByColorMatchingColorSpaceToWorkingSpace:")
    public native CIImage newImageByColorMatchingColorSpaceToWorkingSpace(CGColorSpace var1);

    @Method(selector="imageByColorMatchingWorkingSpaceToColorSpace:")
    public native CIImage newImageByColorMatchingWorkingSpaceToColorSpace(CGColorSpace var1);

    @Method(selector="imageByPremultiplyingAlpha")
    public native CIImage newImageByPremultiplyingAlpha();

    @Method(selector="imageByUnpremultiplyingAlpha")
    public native CIImage newImageByUnpremultiplyingAlpha();

    @Method(selector="imageBySettingAlphaOneInExtent:")
    public native CIImage newImageBySettingAlphaOneInExtent(@ByVal CGRect var1);

    @Method(selector="imageByApplyingGaussianBlurWithSigma:")
    public native CIImage newImageByApplyingGaussianBlurWithSigma(double var1);

    @Method(selector="imageBySettingProperties:")
    public native CIImage newImageBySettingProperties(NSDictionary<?, ?> var1);

    @Method(selector="imageBySamplingLinear")
    public native CIImage newImageBySamplingLinear();

    @Method(selector="imageBySamplingNearest")
    public native CIImage newImageBySamplingNearest();

    @Method(selector="regionOfInterestForImage:inRect:")
    @ByVal
    public native CGRect getRegionOfInterest(CIImage var1, @ByVal CGRect var2);

    @Method(selector="emptyImage")
    public static native CIImage getEmptyImage();

    @Method(selector="autoAdjustmentFilters")
    public native NSArray<CIFilter> getAutoAdjustmentFilters();

    @Method(selector="autoAdjustmentFiltersWithOptions:")
    public native NSArray<CIFilter> getAutoAdjustmentFilters(NSDictionary<NSString, ?> var1);

    @Method(selector="initWithImageProvider:size::format:colorSpace:options:")
    @Pointer
    protected native long init(NSObject var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4, int var6, CGColorSpace var7, CIImageOptions var8);

    static {
        ObjCRuntime.bind(CIImage.class);
    }

    public static class CIImagePtr
    extends Ptr<CIImage, CIImagePtr> {
    }
}

